/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication;

import ch.systemsx.cisd.authentication.BasicSession;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.ILogMessagePrefixGenerator;
import ch.systemsx.cisd.authentication.IPrincipalProvider;
import ch.systemsx.cisd.authentication.ISessionFactory;
import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.security.TokenGenerator;
import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.log4j.Logger;

public class DefaultSessionManager<T extends BasicSession>
implements ISessionManager<T> {
    private static final String LOGOUT_PREFIX = "LOGOUT: ";
    private static final String LOGIN_PREFIX_TEMPLATE = "(%dms) LOGIN: ";
    private static final char SESSION_TOKEN_SEPARATOR = '-';
    private static final char TIMESTAMP_TOKEN_SEPARATOR = 'x';
    private static final Logger authenticationLog = LogFactory.getLogger(LogCategory.AUTH, DefaultSessionManager.class);
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DefaultSessionManager.class);
    private static final Logger notifyLog = LogFactory.getLogger(LogCategory.NOTIFY, DefaultSessionManager.class);
    private static final TokenGenerator tokenGenerator = new TokenGenerator();
    @Resource(name="propertyConfigurer")
    protected ExposablePropertyPlaceholderConfigurer configurer;
    private final ISessionFactory<T> sessionFactory;
    private final ILogMessagePrefixGenerator<T> prefixGenerator;
    protected final Map<String, FullSession<T>> sessions = new LinkedHashMap<String, FullSession<T>>();
    private final IAuthenticationService authenticationService;
    private final IRemoteHostProvider remoteHostProvider;
    private final int sessionExpirationPeriodMillis;
    private final boolean tryEmailAsUserName;
    private volatile ISessionMonitor sessionMonitor;

    public DefaultSessionManager(ISessionFactory<T> sessionFactory, ILogMessagePrefixGenerator<T> prefixGenerator, IAuthenticationService authenticationService, IRemoteHostProvider remoteHostProvider, int sessionExpirationPeriodMinutes) {
        this(sessionFactory, prefixGenerator, authenticationService, remoteHostProvider, sessionExpirationPeriodMinutes, false);
    }

    public DefaultSessionManager(ISessionFactory<T> sessionFactory, ILogMessagePrefixGenerator<T> prefixGenerator, IAuthenticationService authenticationService, IRemoteHostProvider remoteHostProvider, int sessionExpirationPeriodMinutes, boolean tryEmailAsUserName) {
        assert (sessionFactory != null) : "Missing session factory.";
        assert (prefixGenerator != null) : "Missing prefix generator";
        assert (authenticationService != null) : "Missing authentication service.";
        assert (remoteHostProvider != null) : "Missing remote host provider.";
        assert (sessionExpirationPeriodMinutes >= 0) : "Session experation time has to be a positive value: " + sessionExpirationPeriodMinutes;
        this.sessionFactory = sessionFactory;
        this.prefixGenerator = prefixGenerator;
        this.authenticationService = authenticationService;
        this.remoteHostProvider = remoteHostProvider;
        this.sessionExpirationPeriodMillis = (int)((long)sessionExpirationPeriodMinutes * 60000L);
        this.tryEmailAsUserName = tryEmailAsUserName;
        operationLog.info((Object)String.format("Authentication service: '%s'", authenticationService.getClass().getName()));
        operationLog.info((Object)String.format("Session expiration period: %s", DurationFormatUtils.formatDurationHMS((long)this.sessionExpirationPeriodMillis)));
        try {
            authenticationService.check();
        }
        catch (EnvironmentFailureException ex) {
            if (authenticationService.isRemote()) {
                operationLog.warn((Object)"Remote authentication service check failed.", (Throwable)ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final T createAndStoreSession(String user, Principal principal, long now) {
        String sessionToken = String.valueOf(user) + '-' + tokenGenerator.getNewToken(now, 'x');
        Map<String, FullSession<T>> map = this.sessions;
        synchronized (map) {
            T session = this.sessionFactory.create(sessionToken, user, principal, this.getRemoteHost(), now, this.sessionExpirationPeriodMillis);
            FullSession<T> createdSession = new FullSession<T>(session);
            this.sessions.put(((BasicSession)createdSession.getSession()).getSessionToken(), createdSession);
            this.getSessionMonitor().logSessionMonitoringInfo();
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISessionMonitor getSessionMonitor() {
        if (this.sessionMonitor == null) {
            DefaultSessionManager defaultSessionManager = this;
            synchronized (defaultSessionManager) {
                if (this.sessionMonitor == null) {
                    this.sessionMonitor = this.createSessionMonitor();
                }
            }
        }
        return this.sessionMonitor;
    }

    private ISessionMonitor createSessionMonitor() {
        Properties properties = this.configurer == null ? new Properties() : this.configurer.getResolvedProps();
        int sessionNotifyThreshold = PropertyUtils.getInt(properties, "session-notification-threshold", 0);
        int notificationDelayPeriod = PropertyUtils.getInt(properties, "session-notification-delay-period", 1800);
        if (sessionNotifyThreshold != 0) {
            operationLog.info((Object)("Create session monitor with threshold " + sessionNotifyThreshold));
            return new SessionMonitor(sessionNotifyThreshold, notificationDelayPeriod);
        }
        operationLog.info((Object)"Create dummy session monitor");
        return new ISessionMonitor(){

            @Override
            public void logSessionMonitoringInfo() {
            }
        };
    }

    private static void checkIfNotBlank(String object, String name) throws UserFailureException {
        if (StringUtils.isBlank((String)object)) {
            throw UserFailureException.fromTemplate("No '%s' specified.", name);
        }
    }

    private boolean isSessionUnavailable(FullSession<T> session) {
        return session == null || this.doSessionExpiration(session);
    }

    private boolean doSessionExpiration(FullSession<T> session) {
        return session != null && session.hasExpired();
    }

    private void logAuthenticed(T session, long timeToLoginMillis) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)(String.valueOf(String.format(LOGIN_PREFIX_TEMPLATE, timeToLoginMillis)) + (((BasicSession)session).isAnonymous() ? "Anonymous user" : "User") + " '" + ((BasicSession)session).getUserName() + "' has been successfully authenticated from host '" + this.getRemoteHost() + "'. Session token: '" + ((BasicSession)session).getSessionToken() + "'."));
        }
        String prefix = this.prefixGenerator.createPrefix(session);
        authenticationLog.info((Object)(String.valueOf(prefix) + ": login"));
    }

    private void logFailedAuthentication(String user, long timeToLoginMillis) {
        operationLog.warn((Object)(String.valueOf(String.format(LOGIN_PREFIX_TEMPLATE, timeToLoginMillis)) + "User '" + user + "' failed to authenticate from host '" + this.getRemoteHost() + "'."));
        this.logAuthenticationFailure(user);
    }

    private void logSessionFailure(String user, RuntimeException ex, long timeToLoginMillis) {
        this.logAuthenticationFailure(user);
        operationLog.error((Object)(String.valueOf(String.format(LOGIN_PREFIX_TEMPLATE, timeToLoginMillis)) + "Error when trying to authenticate user '" + user + "'."), (Throwable)ex);
    }

    private void logAuthenticationFailure(String user) {
        String prefix = this.prefixGenerator.createPrefix(user, this.getRemoteHost());
        authenticationLog.info((Object)(String.valueOf(prefix) + ": login   ...FAILED"));
    }

    private void logSessionExpired(T session) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("%sExpiring session '%s' for user '%s' after %d minutes of inactivity.", LOGOUT_PREFIX, ((BasicSession)session).getSessionToken(), ((BasicSession)session).getUserName(), (long)this.sessionExpirationPeriodMillis / 60000L));
        }
        String prefix = this.prefixGenerator.createPrefix(session);
        authenticationLog.info((Object)(String.valueOf(prefix) + ": session_expired  [inactive " + DurationFormatUtils.formatDurationHMS((long)this.sessionExpirationPeriodMillis) + "]"));
    }

    private void logLogout(T session) {
        String prefix = this.prefixGenerator.createPrefix(session);
        authenticationLog.info((Object)(String.valueOf(prefix) + ": logout"));
        if (operationLog.isInfoEnabled()) {
            String user = ((BasicSession)session).getUserName();
            operationLog.info((Object)("LOGOUT: Session '" + ((BasicSession)session).getSessionToken() + "' of user '" + user + "' has been closed."));
        }
    }

    @Override
    public boolean isAWellFormedSessionToken(String sessionTokenOrNull) {
        if (sessionTokenOrNull == null) {
            return false;
        }
        String[] splittedToken = StringUtils.split((String)sessionTokenOrNull, (char)'-');
        if (splittedToken.length < 2) {
            return false;
        }
        String[] splittedTimeStampToken = StringUtils.split((String)splittedToken[1], (char)'x');
        if (splittedTimeStampToken.length < 2) {
            return false;
        }
        try {
            Long.parseLong(splittedTimeStampToken[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return splittedTimeStampToken[1].length() == 32;
    }

    @Override
    public T getSession(String sessionToken) throws InvalidSessionException {
        return this.getSession(sessionToken, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T tryGetSession(String sessionToken) {
        Map<String, FullSession<T>> map = this.sessions;
        synchronized (map) {
            FullSession<T> session = this.sessions.get(sessionToken);
            return session == null ? null : (T)session.getSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getSession(String sessionToken, boolean checkAndTouch) throws InvalidSessionException {
        DefaultSessionManager.checkIfNotBlank(sessionToken, "sessionToken");
        Map<String, FullSession<T>> map = this.sessions;
        synchronized (map) {
            String[] splittedToken = StringUtils.split((String)sessionToken, (char)'-');
            if (splittedToken.length < 2) {
                String msg = "Session token '" + sessionToken + "' is malformed. Please login again.";
                if (authenticationLog.isInfoEnabled()) {
                    authenticationLog.info((Object)msg);
                }
                throw new InvalidSessionException(msg);
            }
            FullSession<T> session = this.sessions.get(sessionToken);
            if (session == null) {
                String msg = "Session token '" + sessionToken + "' is invalid: user is not logged in.";
                if (operationLog.isInfoEnabled()) {
                    operationLog.info((Object)msg);
                }
                throw new InvalidSessionException(msg);
            }
            if (!sessionToken.equals(((BasicSession)session.getSession()).getSessionToken())) {
                String msg = "Session token '" + sessionToken + "' is invalid: wrong token. Please login again.";
                if (operationLog.isInfoEnabled()) {
                    operationLog.info((Object)msg);
                }
                throw new InvalidSessionException(msg);
            }
            if (checkAndTouch && this.doSessionExpiration(session)) {
                this.closeSession(session.getSession(), false);
            }
            if (checkAndTouch && this.isSessionUnavailable(session)) {
                throw new InvalidSessionException("Session no longer available. Please login again.");
            }
            if (checkAndTouch) {
                session.touch();
            }
            return session.getSession();
        }
    }

    @Override
    public String tryToOpenSession(final String user, final String password) {
        DefaultSessionManager.checkIfNotBlank(password, "password");
        return this.tryToOpenSession(user, new IPrincipalProvider(){

            @Override
            public Principal tryToGetPrincipal(String userID) {
                return DefaultSessionManager.this.tryGetAndAuthenticateUser(user, password);
            }
        });
    }

    @Override
    public String tryToOpenSession(String userID, IPrincipalProvider principalProvider) {
        DefaultSessionManager.checkIfNotBlank(userID, "user");
        long now = System.currentTimeMillis();
        try {
            String sessionToken = null;
            Principal principalOrNull = principalProvider.tryToGetPrincipal(userID);
            long timeToLogin = System.currentTimeMillis() - now;
            boolean isAuthenticated = Principal.isAuthenticated(principalOrNull);
            if (isAuthenticated) {
                try {
                    T session = this.createAndStoreSession(principalOrNull.getUserId(), principalOrNull, now);
                    sessionToken = ((BasicSession)session).getSessionToken();
                    this.logAuthenticed(session, timeToLogin);
                }
                catch (IllegalArgumentException ex) {
                    throw new EnvironmentFailureException(ex.getMessage(), ex);
                }
            } else {
                this.logFailedAuthentication(userID, timeToLogin);
            }
            return sessionToken;
        }
        catch (RuntimeException ex) {
            this.logSessionFailure(userID, ex, System.currentTimeMillis() - now);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(String sessionToken) throws InvalidSessionException {
        Map<String, FullSession<T>> map = this.sessions;
        synchronized (map) {
            T session = this.getSession(sessionToken, false);
            this.closeSession(session, true);
        }
    }

    @Override
    public void expireSession(String sessionToken) throws InvalidSessionException {
        T session = this.getSession(sessionToken, false);
        this.closeSession(session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(T session, boolean regularLogout) throws InvalidSessionException {
        Map<String, FullSession<T>> map = this.sessions;
        synchronized (map) {
            ((BasicSession)session).cleanup();
            this.sessions.remove(((BasicSession)session).getSessionToken());
            if (regularLogout) {
                this.logLogout(session);
            } else {
                this.logSessionExpired(session);
            }
        }
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHostProvider.getRemoteHost();
    }

    private Principal tryGetAndAuthenticateUser(String user, String password) {
        Principal p = this.authenticationService.tryGetAndAuthenticateUser(user, password);
        if (p == null && this.tryEmailAsUserName && user.contains("@") && this.authenticationService.supportsAuthenticatingByEmail()) {
            return this.authenticationService.tryGetAndAuthenticateUserByEmail(user, password);
        }
        return p;
    }

    protected static final class FullSession<S extends BasicSession> {
        private final S session;
        private long lastActiveTime;

        FullSession(S session) {
            assert (session != null) : "Undefined session";
            this.session = session;
            this.touch();
        }

        public S getSession() {
            return this.session;
        }

        void touch() {
            this.lastActiveTime = System.currentTimeMillis();
        }

        boolean hasExpired() {
            return System.currentTimeMillis() - this.lastActiveTime > (long)((BasicSession)this.session).getSessionExpirationTime();
        }
    }

    private static interface ISessionMonitor {
        public void logSessionMonitoringInfo();
    }

    private class SessionMonitor
    implements ISessionMonitor {
        private static final String SESSION_NOTIFY_THRESHOLD_KEY = "session-notification-threshold";
        private static final int SESSION_NOTIFY_THRESHOLD_DEFAULT = 0;
        private static final String SESSION_NOTIFY_DELAY_PERDIOD_KEY = "session-notification-delay-period";
        private static final int SESSION_NOTIFY_DELAY_PERDIOD_DEFAULT = 1800;
        final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        final long lastNotification = 0L;
        final int notificationDelayPeriod;
        final int sessionNotifyThreshold;

        public SessionMonitor(int sessionNotifyThreshold, int notificationDelayPeriodInSeconds) {
            this.notificationDelayPeriod = notificationDelayPeriodInSeconds * 1000;
            this.sessionNotifyThreshold = sessionNotifyThreshold;
            if (sessionNotifyThreshold <= 0) {
                throw new IllegalArgumentException("Sessions threshold must be a positive integer");
            }
        }

        @Override
        public void logSessionMonitoringInfo() {
            int sessionsSize = DefaultSessionManager.this.sessions.size();
            operationLog.info((Object)("Currently active sessions: " + sessionsSize));
            if (sessionsSize > this.sessionNotifyThreshold) {
                long now = System.currentTimeMillis();
                if (0L + (long)this.notificationDelayPeriod > now) {
                    return;
                }
                notifyLog.info((Object)("Number of active sessions has exceeded the threshold (" + this.sessionNotifyThreshold + ")."));
                for (FullSession fullSession : DefaultSessionManager.this.sessions.values()) {
                    Object session = fullSession.getSession();
                    ((BasicSession)session).getSessionStart();
                    ((BasicSession)session).getUserName();
                    ((BasicSession)session).getRemoteHost();
                    ((BasicSession)session).isAnonymous();
                    String message = String.format("Session %s:\n  User %s%s from %s\n  Started at %s, will expire in %d seconds.", ((BasicSession)session).getSessionToken(), ((BasicSession)session).getUserName(), ((BasicSession)session).isAnonymous() ? "(anonymous)" : "", ((BasicSession)session).getRemoteHost(), this.df.format(new Date(((BasicSession)session).getSessionStart())), ((BasicSession)session).getSessionExpirationTime());
                    notifyLog.info((Object)message);
                }
            }
        }
    }
}

