/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.recovery;

import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageRecoveryAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.recovery.IDataSetStorageRecoveryAlgorithmWithState;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import java.io.File;
import java.io.Serializable;

public class DataSetStorageStoredRecoveryAlgorithm<T extends DataSetInformation>
implements Serializable,
IDataSetStorageRecoveryAlgorithmWithState<T> {
    private static final long serialVersionUID = 1L;
    private DataSetStorageRecoveryAlgorithm<T> recoveryAlgorithm;

    public DataSetStorageStoredRecoveryAlgorithm(T dataSetInformation, DataStoreStrategyKey dataStoreStrategyKey, File incomingDataSetFile, File stagingDirectory, File preCommitDirectory, String dataStoreCode, DataSetStorageAlgorithm.DataSetStoragePaths dataSetStoragePaths) {
        this.recoveryAlgorithm = new DataSetStorageRecoveryAlgorithm<T>(dataSetInformation, dataStoreStrategyKey, incomingDataSetFile, stagingDirectory, preCommitDirectory, dataStoreCode, dataSetStoragePaths, DataSetKind.PHYSICAL);
    }

    public DataSetStorageStoredRecoveryAlgorithm(T dataSetInformation, DataStoreStrategyKey dataStoreStrategyKey, File incomingDataSetFile, File stagingDirectory, File preCommitDirectory, String dataStoreCode, DataSetKind dataSetKind) {
        this.recoveryAlgorithm = new DataSetStorageRecoveryAlgorithm<T>(dataSetInformation, dataStoreStrategyKey, incomingDataSetFile, stagingDirectory, preCommitDirectory, dataStoreCode, null, dataSetKind);
    }

    public DataSetStorageAlgorithm<T> recoverDataSetStorageAlgorithm(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState state) {
        return this.recoveryAlgorithm.recoverDataSetStorageAlgorithm(state, this);
    }

    public DataSetStorageRecoveryAlgorithm<T> getRecoveryAlgorithm() {
        return this.recoveryAlgorithm;
    }

    public String getDataSetCode() {
        return this.recoveryAlgorithm.getDataSetCode();
    }

    public T getDataSetInformation() {
        return this.recoveryAlgorithm.getDataSetInformation();
    }

    public DataStoreStrategyKey getDataStoreStrategyKey() {
        return this.recoveryAlgorithm.getDataStoreStrategyKey();
    }

    public File getIncomingDataSetFile() {
        return this.recoveryAlgorithm.getIncomingDataSetFile();
    }

    public File getStagingDirectory() {
        return this.recoveryAlgorithm.getStagingDirectory();
    }

    public File getPreCommitDirectory() {
        return this.recoveryAlgorithm.getPreCommitDirectory();
    }

    public String getDataStoreCode() {
        return this.recoveryAlgorithm.getDataStoreCode();
    }

    public DataSetStorageAlgorithm.DataSetStoragePaths getDataSetStoragePaths() {
        return this.recoveryAlgorithm.getDataSetStoragePaths();
    }

    @Override
    public DataSetStorageAlgorithm<T> createExternalDataSetStorageAlgorithm(IDataStoreStrategy dataStoreStrategy, IStorageProcessorTransactional storageProcessor, IFileOperations fileOperations, IMailClient mailClient) {
        return DataSetStorageAlgorithm.createFromStoredRecoveryAlgorithm(dataStoreStrategy, storageProcessor, fileOperations, mailClient, this);
    }
}

