/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.tar.Tar;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class TarDataSetPackager
extends AbstractDataSetPackager {
    private final Tar tar;

    public TarDataSetPackager(File tarFile, IHierarchicalContentProvider contentProvider, DataSetExistenceChecker dataSetExistenceChecker) {
        super(contentProvider, dataSetExistenceChecker);
        try {
            this.tar = new Tar(tarFile);
        }
        catch (FileNotFoundException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    @Override
    protected boolean isChecksumNeeded() {
        return false;
    }

    @Override
    public void addEntry(String entryPath, long lastModified, long size, long checksum, InputStream in) {
        TarArchiveEntry entry = new TarArchiveEntry(entryPath.replace('\\', '/'));
        entry.setSize(size);
        try {
            this.tar.add(entry, in);
        }
        catch (IOException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    @Override
    public void addDirectoryEntry(String entryPath) {
        String path = entryPath.replace('\\', '/');
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        try {
            this.tar.add(path);
        }
        catch (IOException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    @Override
    public void close() {
        try {
            this.tar.close();
        }
        catch (IOException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }
}

