/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetSearchHitGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;

public class DataSetSearchLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public DataSetSearchLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
    }

    public void openEntitySearch(DetailedSearchCriteria searchCriteria, String historyToken) throws UserFailureException {
        OpenEntitySearchGridTabAction searchAction = new OpenEntitySearchGridTabAction(searchCriteria, historyToken, this.viewContext);
        DispatcherHelper.dispatchNaviEvent(searchAction);
    }

    private static class OpenEntitySearchGridTabAction
    extends AbstractTabItemFactory {
        private final DetailedSearchCriteria searchCriteria;
        private final IViewContext<ICommonClientServiceAsync> viewContext;
        private final String historyToken;

        private OpenEntitySearchGridTabAction(DetailedSearchCriteria searchCriteria, String historyToken, IViewContext<ICommonClientServiceAsync> viewContext) {
            this.searchCriteria = searchCriteria;
            this.historyToken = historyToken;
            this.viewContext = viewContext;
        }

        private String getMessage(String key) {
            return this.viewContext.getMessage(key, new Object[0]);
        }

        private ITabItem createTab(String dictionaryMsgKey, IDisposableComponent component) {
            String title = this.getMessage(dictionaryMsgKey);
            return DefaultTabItem.create(title, component, this.viewContext);
        }

        @Override
        public ITabItem create() {
            DisposableEntityChooser<TableModelRowWithObject<AbstractExternalData>> browser = DataSetSearchHitGrid.createWithInitialSearchCriteria(this.viewContext, this.searchCriteria, false);
            return this.createTab("data_set_search", browser);
        }

        @Override
        public String getId() {
            return "openbis_data-set-search-hit-browser";
        }

        @Override
        public HelpPageIdentifier getHelpPageIdentifier() {
            return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET, HelpPageIdentifier.HelpPageAction.SEARCH);
        }

        @Override
        public String getTabTitle() {
            return this.getMessage("data_set_search");
        }

        @Override
        public String tryGetLink() {
            return this.historyToken;
        }
    }
}

