/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.EntityChooserDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesSetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MetaprojectArea;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.grid.MetaprojectGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MetaprojectChooserButton
extends Button
implements IChosenEntitiesSetter<TableModelRowWithObject<Metaproject>> {
    public static final String ID_SUFFIX = "_metaproject_chooser_button";
    private Field<?> field;
    private final List<IChosenEntitiesListener<TableModelRowWithObject<Metaproject>>> listeners = new ArrayList<IChosenEntitiesListener<TableModelRowWithObject<Metaproject>>>();

    public MetaprojectChooserButton(IViewContext<?> viewContext, String idPrefix, IChosenEntitiesProvider<String> chosenProvider) {
        this(viewContext, idPrefix, chosenProvider, true);
    }

    public MetaprojectChooserButton(final IViewContext<?> viewContext, final String idPrefix, final IChosenEntitiesProvider<String> chosenProvider, final boolean possibleToAddMetaProjects) {
        super(viewContext.getMessage("add_metaproject", new Object[0]));
        this.setId(String.valueOf(idPrefix) + ID_SUFFIX);
        this.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DisposableEntityChooser<TableModelRowWithObject<Metaproject>> chooserGrid = MetaprojectGrid.createChooser(viewContext, chosenProvider);
                if (possibleToAddMetaProjects) {
                    new EntityChooserDialog<TableModelRowWithObject<Metaproject>>(chooserGrid, MetaprojectChooserButton.this, viewContext.getMessage("choose_metaproject", new Object[0]), (IMessageProvider)viewContext, new Button(viewContext.getMessage("button_create_new_metaprojects", new Object[0]), MetaprojectChooserButton.this.getListenerForCreateMetaProjectButton(chooserGrid, viewContext, idPrefix))).show();
                } else {
                    new EntityChooserDialog<TableModelRowWithObject<Metaproject>>(chooserGrid, MetaprojectChooserButton.this, viewContext.getMessage("choose_metaproject", new Object[0]), (IMessageProvider)viewContext, new Button[0]).show();
                }
            }
        });
    }

    private SelectionListener<ButtonEvent> getListenerForCreateMetaProjectButton(final DisposableEntityChooser<TableModelRowWithObject<Metaproject>> chooserGrid, final IViewContext<?> viewContext, final String idPrefix) {
        return new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent event) {
                final MetaprojectArea area = new MetaprojectArea(viewContext, idPrefix);
                area.setAutoWidth(true);
                area.setAutoHeight(true);
                SimpleDialog simpleDialog = new SimpleDialog((Widget)area, viewContext.getMessage("topic_create_metaprojects", new Object[0]), viewContext.getMessage("button_create_metaprojects", new Object[0]), viewContext, new Button[0]);
                simpleDialog.setAutoHeight(true);
                simpleDialog.setWidth(400);
                simpleDialog.setScrollMode(Style.Scroll.NONE);
                simpleDialog.setAcceptAction(new IDelegatedAction(){

                    @Override
                    public void execute() {
                        String[] stringArray = area.tryGetMetaprojects();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            viewContext.getCommonService().registerMetaProject(name, new AsyncCallback<Void>(){

                                public void onFailure(Throwable caught) {
                                }

                                public void onSuccess(Void result) {
                                    HashSet<DatabaseModificationKind> kind = new HashSet<DatabaseModificationKind>();
                                    kind.add(new DatabaseModificationKind(DatabaseModificationKind.ObjectKind.METAPROJECT, DatabaseModificationKind.OperationKind.CREATE_OR_DELETE));
                                    chooserGrid.update(kind);
                                }
                            });
                            ++n2;
                        }
                    }
                });
                simpleDialog.show();
            }
        };
    }

    @Override
    public void setChosenEntities(List<TableModelRowWithObject<Metaproject>> entities) {
        if (entities == null) {
            return;
        }
        for (IChosenEntitiesListener<TableModelRowWithObject<Metaproject>> listener : this.listeners) {
            listener.entitiesChosen(entities);
        }
    }

    public void addChosenEntityListener(IChosenEntitiesListener<TableModelRowWithObject<Metaproject>> listener) {
        this.listeners.add(listener);
    }

    public Field<?> getField() {
        if (this.field == null) {
            this.field = new AdapterField((Widget)this);
            this.field.setLabelSeparator("");
        }
        return this.field;
    }
}

