/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.meta.MetadataRetrieve;

public class JavaWriter
extends FormatWriter {
    public JavaWriter() {
        super("Java source code", "java");
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        if (!this.isFullPlane(x, y, w, h)) {
            throw new FormatException("JavaWriter does not yet support saving image tiles.");
        }
        MetadataRetrieve meta = this.getMetadataRetrieve();
        String pixelType = meta.getPixelsType(this.series).toString();
        int type = FormatTools.pixelTypeFromString(pixelType);
        if (!DataTools.containsValue(this.getPixelTypes(), type)) {
            throw new FormatException("Unsupported image type '" + pixelType + "'.");
        }
        int bpp = FormatTools.getBytesPerPixel(type);
        boolean fp = FormatTools.isFloatingPoint(type);
        boolean little = Boolean.FALSE.equals(meta.getPixelsBinDataBigEndian(this.series, 0));
        String varName = "series" + this.series + "Plane" + no;
        Object array = DataTools.makeDataArray(buf, bpp, fp, little);
        int sizeX = (Integer)meta.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)meta.getPixelsSizeY(this.series).getValue();
        this.out.seek(this.out.length());
        if (array instanceof byte[]) {
            this.writePlane(varName, (byte[])array, w, h);
        } else if (array instanceof short[]) {
            this.writePlane(varName, (short[])array, w, h);
        } else if (array instanceof int[]) {
            this.writePlane(varName, (int[])array, w, h);
        } else if (array instanceof long[]) {
            this.writePlane(varName, (long[])array, w, h);
        } else if (array instanceof float[]) {
            this.writePlane(varName, (float[])array, w, h);
        } else if (array instanceof double[]) {
            this.writePlane(varName, (double[])array, w, h);
        }
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return new int[]{0, 1, 3, 5, 4, 6, 7};
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        if (this.out.length() == 0L) {
            this.writeHeader();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.writeFooter();
        }
        super.close();
    }

    protected void writeHeader() throws IOException {
        String className = this.currentId.substring(0, this.currentId.length() - 5);
        className = className.substring(className.lastIndexOf(File.separator) + 1);
        this.out.writeLine("//");
        this.out.writeLine("// " + className + ".java");
        this.out.writeLine("//");
        this.out.writeLine("");
        this.out.writeLine("// Generated by Bio-Formats v" + FormatTools.VERSION);
        this.out.writeLine("// Generated on " + new Date());
        this.out.writeLine("");
        this.out.writeLine("public class " + className + " {");
        this.out.writeLine("");
    }

    protected void writePlane(String varName, byte[] array, int w, int h) throws IOException {
        int i = 0;
        this.out.writeLine("  public byte[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.writeBytes("    {");
            for (int x = 0; x < w; ++x) {
                this.out.writeBytes(String.valueOf(array[i++]));
                if (x < w - 1) {
                    this.out.writeBytes(", ");
                    continue;
                }
                this.out.writeBytes("}");
            }
            if (y < h - 1) {
                this.out.writeLine(",");
                continue;
            }
            this.out.writeLine("");
        }
        this.out.writeLine("  };");
        this.out.writeLine("");
    }

    protected void writePlane(String varName, short[] array, int w, int h) throws IOException {
        int i = 0;
        this.out.writeLine("  public short[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.writeBytes("    {");
            for (int x = 0; x < w; ++x) {
                this.out.writeBytes(String.valueOf(array[i++]));
                if (x < w - 1) {
                    this.out.writeBytes(", ");
                    continue;
                }
                this.out.writeBytes("}");
            }
            if (y < h - 1) {
                this.out.writeLine(",");
                continue;
            }
            this.out.writeLine("");
        }
        this.out.writeLine("  };");
        this.out.writeLine("");
    }

    protected void writePlane(String varName, int[] array, int w, int h) throws IOException {
        int i = 0;
        this.out.writeLine("  public int[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.writeBytes("    {");
            for (int x = 0; x < w; ++x) {
                this.out.writeBytes(String.valueOf(array[i++]));
                if (x < w - 1) {
                    this.out.writeBytes(", ");
                    continue;
                }
                this.out.writeBytes("}");
            }
            if (y < h - 1) {
                this.out.writeLine(",");
                continue;
            }
            this.out.writeLine("");
        }
        this.out.writeLine("  };");
        this.out.writeLine("");
    }

    protected void writePlane(String varName, long[] array, int w, int h) throws IOException {
        int i = 0;
        this.out.writeLine("  public long[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.writeBytes("    {");
            for (int x = 0; x < w; ++x) {
                this.out.writeBytes(String.valueOf(array[i++]));
                if (x < w - 1) {
                    this.out.writeBytes(", ");
                    continue;
                }
                this.out.writeBytes("}");
            }
            if (y < h - 1) {
                this.out.writeLine(",");
                continue;
            }
            this.out.writeLine("");
        }
        this.out.writeLine("  };");
        this.out.writeLine("");
    }

    protected void writePlane(String varName, float[] array, int w, int h) throws IOException {
        int i = 0;
        this.out.writeLine("  public float[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.writeBytes("    {");
            for (int x = 0; x < w; ++x) {
                this.out.writeBytes(String.valueOf(array[i++]));
                if (x < w - 1) {
                    this.out.writeBytes(", ");
                    continue;
                }
                this.out.writeBytes("}");
            }
            if (y < h - 1) {
                this.out.writeLine(",");
                continue;
            }
            this.out.writeLine("");
        }
        this.out.writeLine("  };");
        this.out.writeLine("");
    }

    protected void writePlane(String varName, double[] array, int w, int h) throws IOException {
        int i = 0;
        this.out.writeLine("  public double[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.writeBytes("    {");
            for (int x = 0; x < w; ++x) {
                this.out.writeBytes(String.valueOf(array[i++]));
                if (x < w - 1) {
                    this.out.writeBytes(", ");
                    continue;
                }
                this.out.writeBytes("}");
            }
            if (y < h - 1) {
                this.out.writeLine(",");
                continue;
            }
            this.out.writeLine("");
        }
        this.out.writeLine("  };");
        this.out.writeLine("");
    }

    protected void writeFooter() throws IOException {
        this.out.writeLine("}");
    }
}

