/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class ClosableURLClassLoader
extends URLClassLoader {
    private String path;
    private ZipFile file;

    public ClosableURLClassLoader(String path, ClassLoader parent) throws MalformedURLException {
        super(new URL[]{new URL("file:" + path)}, parent);
        this.path = path;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            this.file = new ZipFile(this.path);
            ZipEntry entry = this.file.getEntry(name.startsWith("/") ? name.substring(1) : name);
            if (entry == null) {
                this.file.close();
                this.file = null;
                return null;
            }
            return this.file.getInputStream(entry);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.file = null;
    }
}

