/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.lemnik.eodsql.ArrayDataSetCache;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.DataSetCache;
import net.lemnik.eodsql.GeneratedKeys;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.TypeMapper;
import net.lemnik.eodsql.Update;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.Resource;
import net.lemnik.eodsql.spi.ResultSetResource;
import net.lemnik.eodsql.spi.StatementResource;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.NoDataObjectBinding;
import net.lemnik.eodsql.spi.util.Query;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QuickQueryUtil {
    private static final Map<String, Object> DEFAULT_DATASET_PARAMETERS;
    private static final Select DEFAULT_SELECT_PARAMETERS;
    private static final Update DEFAULT_UPDATE_PARAMETERS;

    private QuickQueryUtil() {
    }

    private static Class<?>[] getParameterTypes(Object[] objectArray) {
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i] == null ? null : objectArray[i].getClass();
        }
        return classArray;
    }

    private static Type wrapClassInDataSet(final Class<?> clazz) {
        return new ParameterizedType(){
            private Class[] args;
            {
                this.args = new Class[]{clazz};
            }

            public Type[] getActualTypeArguments() {
                return this.args;
            }

            public Type getRawType() {
                return DataSet.class;
            }

            public Type getOwnerType() {
                return null;
            }
        };
    }

    private static void fillStatementParameters(Query query, PreparedStatement preparedStatement, Context<?> context) throws SQLException {
        Map<Class, TypeMapper> map = QueryTool.getTypeMap();
        int n = query.getParameterCount();
        for (int i = 0; i < n; ++i) {
            Class<?> clazz = query.getParameterType(i);
            if (clazz == null) {
                preparedStatement.setNull(i + 1, preparedStatement.getParameterMetaData().getParameterType(i + 1));
                continue;
            }
            TypeMapper typeMapper = map.get(clazz);
            if (typeMapper != null) {
                typeMapper.set(preparedStatement, i + 1, query.getParameter(context, i));
                continue;
            }
            throw new InvalidQueryException("No TypeMapper found for " + clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> DataSet<T> selectDataSet(Connection connection, boolean bl, Class<T> clazz, String string, Object ... objectArray) throws SQLException, ParseException {
        DataSet dataSet = null;
        Context<Select> context = new Context<Select>(DEFAULT_SELECT_PARAMETERS, DataSet.class, objectArray);
        try {
            ResultSetWrapper resultSetWrapper = ResultSetWrapper.get(QuickQueryUtil.wrapClassInDataSet(clazz), DEFAULT_DATASET_PARAMETERS);
            Class<?>[] classArray = QuickQueryUtil.getParameterTypes(objectArray);
            context.setResource(new ConnectionResource(connection, bl));
            Query query = Query.getQuery(string, classArray);
            PreparedStatement preparedStatement = connection.prepareStatement(query.toString(), resultSetWrapper.getPreferredResultSetType(), resultSetWrapper.getPreferredResultSetConcurrency());
            QuickQueryUtil.fillStatementParameters(query, preparedStatement, context);
            context.setResource(new StatementResource(preparedStatement));
            ResultSet resultSet = preparedStatement.executeQuery();
            context.setResource(new ResultSetResource(resultSet));
            dataSet = (DataSet)resultSetWrapper.wrap(context);
        }
        finally {
            if (dataSet == null) {
                context.close();
            }
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int update(Connection connection, boolean bl, String string, Object ... objectArray) throws SQLException, ParseException {
        Context<Update> context = new Context<Update>(DEFAULT_UPDATE_PARAMETERS, Integer.class, objectArray);
        try {
            Class<?>[] classArray = QuickQueryUtil.getParameterTypes(objectArray);
            context.setResource(new ConnectionResource(connection, bl));
            Query query = Query.getQuery(string, classArray);
            PreparedStatement preparedStatement = connection.prepareStatement(query.toString());
            QuickQueryUtil.fillStatementParameters(query, preparedStatement, context);
            context.setResource(new StatementResource(preparedStatement));
            int n = preparedStatement.executeUpdate();
            return n;
        }
        finally {
            context.close();
        }
    }

    static {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("net.lemnik.eodsql.spi.util.ResultSetWrapper#bindingType", (Object)DataObjectBinding.BindingType.NORMAL_BINDING);
        hashMap.put("net.lemnik.eodsql.spi.util.DataSetWrapper#updatable", true);
        DEFAULT_DATASET_PARAMETERS = Collections.unmodifiableMap(hashMap);
        DEFAULT_SELECT_PARAMETERS = new Select(){

            @Override
            public String value() {
                return "";
            }

            @Override
            public String sql() {
                return "";
            }

            @Override
            public boolean disconnected() {
                return false;
            }

            @Override
            public boolean rubberstamp() {
                return false;
            }

            @Override
            public boolean readOnly() {
                return false;
            }

            @Override
            public Class<? extends DataSetCache> cache() {
                return ArrayDataSetCache.class;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Select.class;
            }

            @Override
            public int fetchSize() {
                return 0;
            }

            @Override
            public int into() {
                return 0;
            }

            @Override
            public Class<? extends DataObjectBinding> resultSetBinding() {
                return NoDataObjectBinding.class;
            }

            @Override
            public Class<? extends TypeMapper>[] parameterBindings() {
                return new Class[0];
            }

            @Override
            public int timeout() {
                return 0;
            }

            @Override
            public int timeoutParameterIndex() {
                return 0;
            }
        };
        DEFAULT_UPDATE_PARAMETERS = new Update(){

            @Override
            public boolean batchUpdate() {
                return false;
            }

            @Override
            public GeneratedKeys keys() {
                return GeneratedKeys.NO_KEYS_RETURNED;
            }

            @Override
            public Class<? extends TypeMapper>[] parameterBindings() {
                return new Class[0];
            }

            @Override
            public String sql() {
                return "";
            }

            @Override
            public String value() {
                return "";
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Update.class;
            }

            @Override
            public int timeout() {
                return 0;
            }

            @Override
            public int timeoutParameterIndex() {
                return 0;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionResource
    implements Resource<Connection> {
        private Connection connection;
        private boolean close = true;

        public ConnectionResource(Connection connection, boolean bl) {
            this.connection = connection;
            this.close = bl;
        }

        @Override
        public Connection get() {
            return this.connection;
        }

        @Override
        public boolean isClosed() {
            return this.connection == null;
        }

        @Override
        public void close() throws SQLException {
            if (this.close) {
                this.connection.close();
            }
            this.connection = null;
        }

        @Override
        public Class<Connection> getResourceType() {
            return Connection.class;
        }
    }
}

