/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.spi.util.AbstractResultSetWrapper;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.DataSetWrapper;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionWrapperFactory
implements ResultSetWrapper.Factory {
    CollectionWrapperFactory() {
    }

    private boolean isCollectionConstructable(Class<?> clazz) {
        if (clazz.equals(List.class) || clazz.equals(Collection.class) || clazz.equals(Set.class) || clazz.equals(SortedSet.class)) {
            return true;
        }
        if (!clazz.isInterface()) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length != 0 && (classArray.length != 1 || !classArray[0].equals(Collection.class))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTypeConstructable(Type type, Map<String, Object> map) throws InvalidQueryException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                if (Collection.class.isAssignableFrom(clazz)) {
                    Type[] typeArray = parameterizedType.getActualTypeArguments();
                    if (typeArray.length != 1) {
                        throw new InvalidQueryException("A Collection needs to have exactly one type parameter.");
                    }
                    if (typeArray[0] instanceof Class) {
                        Class clazz2 = (Class)typeArray[0];
                        if (SortedSet.class.isAssignableFrom(clazz) && !Comparable.class.isAssignableFrom(clazz2)) {
                            throw new InvalidDataTypeException("DataType " + clazz2.getName() + " cannot be returned in a " + clazz.getName() + " because" + " it does not implement Comparable.", clazz2);
                        }
                        return this.isCollectionConstructable(clazz);
                    }
                    if (ResultSetWrapper.isStringObjectMap(typeArray[0])) {
                        return true;
                    }
                    throw new InvalidQueryException("A Collection's generic argument must be a concrete class type.");
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public ResultSetWrapper create(Type type, Map<String, Object> map) {
        DataObjectBinding dataObjectBinding;
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Class clazz = (Class)parameterizedType.getRawType();
        DataObjectBinding.BindingType bindingType = map.containsKey("net.lemnik.eodsql.spi.util.ResultSetWrapper#bindingType") ? (DataObjectBinding.BindingType)((Object)map.get("net.lemnik.eodsql.spi.util.ResultSetWrapper#bindingType")) : DataObjectBinding.BindingType.NORMAL_BINDING;
        Class<?> clazz2 = DataSetWrapper.toClass(parameterizedType.getActualTypeArguments()[0]);
        if (map.containsKey("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding")) {
            DataObjectBinding dataObjectBinding2 = (DataObjectBinding)map.get("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding");
            dataObjectBinding2.setObjectType(clazz2);
            dataObjectBinding = dataObjectBinding2;
        } else {
            dataObjectBinding = DataObjectBinding.getDataObjectBinding(clazz2, bindingType);
        }
        if (clazz.equals(Collection.class) || clazz.equals(List.class)) {
            return new ListWrapper(dataObjectBinding);
        }
        if (clazz.equals(Set.class)) {
            return new SetWrapper(dataObjectBinding);
        }
        if (clazz.equals(SortedSet.class)) {
            return new SortedSetWrapper(dataObjectBinding);
        }
        try {
            clazz.getConstructor(Collection.class);
            return new CollectionConstructorWrapper(dataObjectBinding, clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return new CollectionDefaultWrapper(dataObjectBinding, clazz);
        }
        catch (SecurityException securityException) {
            throw new EoDException(securityException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetCollection<E>
    extends AbstractCollection<E> {
        private final ResultSet results;
        private final DataObjectBinding<E> binding;
        private Integer size = null;

        ResultSetCollection(ResultSet resultSet, DataObjectBinding<E> dataObjectBinding) {
            this.results = resultSet;
            this.binding = dataObjectBinding;
        }

        @Override
        public Iterator<E> iterator() {
            try {
                if (!this.results.isBeforeFirst() && this.supportsScrolling()) {
                    this.results.beforeFirst();
                }
            }
            catch (SQLException sQLException) {
                throw new EoDException(sQLException);
            }
            return new Iterator<E>(){
                E next = null;
                boolean finished = false;
                boolean resultAvailable = false;

                @Override
                public boolean hasNext() {
                    if (!this.finished && !this.resultAvailable) {
                        try {
                            if (ResultSetCollection.this.results.next()) {
                                this.next = ResultSetCollection.this.binding.unmarshall(ResultSetCollection.this.results);
                                this.resultAvailable = true;
                            } else {
                                this.finished = true;
                            }
                        }
                        catch (SQLException sQLException) {
                            throw new EoDException(sQLException);
                        }
                    }
                    return !this.finished;
                }

                @Override
                public E next() {
                    if (this.hasNext()) {
                        Object e = this.next;
                        this.resultAvailable = false;
                        return e;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            if (this.size == null) {
                try {
                    this.size = this.results.last() ? this.results.getRow() : Integer.valueOf(0).intValue();
                }
                catch (SQLException sQLException) {
                    throw new EoDException(sQLException);
                }
            }
            return this.size != null ? this.size : 0;
        }

        boolean supportsScrolling() throws SQLException {
            return this.results.getType() != 1003;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionDefaultWrapper
    extends UnknownCollectionWrapper {
        public CollectionDefaultWrapper(DataObjectBinding<Object> dataObjectBinding, Class<? extends Collection> clazz) {
            super(dataObjectBinding, clazz);
        }

        @Override
        protected Collection newCollectionInstance(ResultSetCollection<?> resultSetCollection) throws SQLException {
            try {
                Collection collection = (Collection)this.collectionType.newInstance();
                if (resultSetCollection.supportsScrolling()) {
                    collection.addAll(resultSetCollection);
                } else {
                    for (Object obj : resultSetCollection) {
                        collection.add(obj);
                    }
                }
                return collection;
            }
            catch (InstantiationException instantiationException) {
                throw new EoDException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EoDException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EoDException(illegalArgumentException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionConstructorWrapper
    extends UnknownCollectionWrapper {
        private final Constructor<? extends Collection> constructor;

        public CollectionConstructorWrapper(DataObjectBinding<Object> dataObjectBinding, Class<? extends Collection> clazz) {
            super(dataObjectBinding, clazz);
            try {
                this.constructor = clazz.getConstructor(Collection.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new EoDException(noSuchMethodException);
            }
            catch (SecurityException securityException) {
                throw new EoDException(securityException);
            }
        }

        @Override
        protected Collection newCollectionInstance(ResultSetCollection<?> resultSetCollection) throws SQLException {
            try {
                if (resultSetCollection.supportsScrolling()) {
                    return this.constructor.newInstance(resultSetCollection);
                }
                Collection collection = (Collection)this.collectionType.newInstance();
                for (Object obj : resultSetCollection) {
                    collection.add(obj);
                }
                return collection;
            }
            catch (InstantiationException instantiationException) {
                throw new EoDException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EoDException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EoDException(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new EoDException(invocationTargetException.getTargetException());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class UnknownCollectionWrapper
    extends AbstractCollectionWrapper<Collection> {
        protected final Class<? extends Collection> collectionType;

        public UnknownCollectionWrapper(DataObjectBinding<Object> dataObjectBinding, Class<? extends Collection> clazz) {
            super(dataObjectBinding);
            this.collectionType = clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortedSetWrapper
    extends AbstractCollectionWrapper<SortedSet> {
        public SortedSetWrapper(DataObjectBinding<Object> dataObjectBinding) {
            super(dataObjectBinding);
        }

        @Override
        protected SortedSet newCollectionInstance(ResultSetCollection<?> resultSetCollection) throws SQLException {
            if (resultSetCollection.supportsScrolling()) {
                return new TreeSet(resultSetCollection);
            }
            TreeSet treeSet = new TreeSet();
            for (Object obj : resultSetCollection) {
                treeSet.add(obj);
            }
            return treeSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetWrapper
    extends AbstractCollectionWrapper<Set> {
        public SetWrapper(DataObjectBinding<Object> dataObjectBinding) {
            super(dataObjectBinding);
        }

        @Override
        protected Set newCollectionInstance(ResultSetCollection<?> resultSetCollection) throws SQLException {
            if (resultSetCollection.supportsScrolling()) {
                return new HashSet(resultSetCollection);
            }
            HashSet hashSet = new HashSet();
            for (Object obj : resultSetCollection) {
                hashSet.add(obj);
            }
            return hashSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListWrapper
    extends AbstractCollectionWrapper<List> {
        public ListWrapper(DataObjectBinding<Object> dataObjectBinding) {
            super(dataObjectBinding);
        }

        @Override
        protected List newCollectionInstance(ResultSetCollection<?> resultSetCollection) throws SQLException {
            if (resultSetCollection.supportsScrolling()) {
                return new ArrayList(resultSetCollection);
            }
            ArrayList arrayList = new ArrayList();
            for (Object obj : resultSetCollection) {
                arrayList.add(obj);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractCollectionWrapper<T extends Collection>
    extends AbstractResultSetWrapper<T, Object> {
        public AbstractCollectionWrapper(DataObjectBinding<Object> dataObjectBinding) {
            super(dataObjectBinding);
        }

        protected abstract T newCollectionInstance(ResultSetCollection<?> var1) throws SQLException;

        @Override
        protected T wrap(ResultSet resultSet) throws SQLException {
            return this.newCollectionInstance(new ResultSetCollection(resultSet, this.binding));
        }
    }
}

