/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import thredds.datatype.DateRange;
import thredds.datatype.DateType;
import thredds.wcs.GetCoverageRequest;
import thredds.wcs.SectionType;
import thredds.wcs.XMLwriter;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.grid.NetcdfCFWriter;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.DiskCache2;

public class WcsDataset {
    private static DiskCache2 diskCache = null;
    private String serverURL = "http://localhost:8080/thredds/wcs?";
    private ucar.nc2.dt.GridDataset gridDataset;
    private String datasetPath;
    private boolean isRemote;
    private XMLOutputter fmt;
    private boolean showDoc = false;
    private boolean debug = false;

    public static void setDiskCache(DiskCache2 _diskCache) {
        diskCache = _diskCache;
    }

    private static DiskCache2 getDiskCache() {
        if (diskCache == null) {
            diskCache = new DiskCache2("/wcsCache/", true, -1, -1);
        }
        return diskCache;
    }

    public WcsDataset(ucar.nc2.dt.GridDataset gridDataset, String datasetPath, boolean isRemote) {
        this.gridDataset = gridDataset;
        this.datasetPath = datasetPath;
        this.isRemote = isRemote;
        this.fmt = new XMLOutputter(Format.getPrettyFormat());
    }

    public void close() throws IOException {
        if (null != this.gridDataset) {
            this.gridDataset.close();
        }
    }

    public void setServerBase(String serverBase) {
        this.serverURL = serverBase + "?";
        if (this.isRemote) {
            this.serverURL = this.serverURL + "dataset=" + this.datasetPath + "&";
        }
    }

    public String getCapabilities() throws IOException {
        XMLwriter writer = new XMLwriter();
        return this.fmt.outputString(writer.makeCapabilities(this.serverURL, this.gridDataset, null));
    }

    public int getCapabilities(OutputStream out, SectionType section) throws IOException {
        XMLwriter writer = new XMLwriter();
        Document doc = writer.makeCapabilities(this.serverURL, this.gridDataset, section);
        String result = this.fmt.outputString(doc);
        out.write(result.getBytes());
        if (this.showDoc) {
            System.out.println(result);
        }
        return result.length();
    }

    public boolean hasCoverage(String coverageName) {
        return this.gridDataset.findGridDatatype(coverageName) != null;
    }

    public String describeCoverage() throws IOException {
        XMLwriter writer = new XMLwriter();
        return this.fmt.outputString(writer.makeDescribeCoverage(this.gridDataset, null));
    }

    public String describeCoverage(String gridName) throws IOException {
        String[] coverageNames = new String[]{gridName};
        XMLwriter writer = new XMLwriter();
        return this.fmt.outputString(writer.makeDescribeCoverage(this.gridDataset, coverageNames));
    }

    public int describeCoverage(OutputStream out, String[] coverageNames) throws IOException {
        XMLwriter writer = new XMLwriter();
        Document doc = writer.makeDescribeCoverage(this.gridDataset, coverageNames);
        String result = this.fmt.outputString(doc);
        out.write(result.getBytes());
        if (this.showDoc) {
            System.out.println(result);
        }
        return result.length();
    }

    public String checkCoverageParameters(GetCoverageRequest req) throws IOException {
        String vname = req.getCoverage();
        GridDatatype geogrid = this.gridDataset.findGridDatatype(vname);
        GridCoordSystem gcs = geogrid.getCoordinateSystem();
        CoordinateAxis1D vaxis = gcs.getVerticalAxis();
        int z = 0;
        int t = 0;
        String vertical = req.getVertical();
        if (vertical != null && (z = vaxis.getIndex(vertical)) < 0) {
            return "Level= " + vertical;
        }
        String time = req.getTime();
        if (time != null && (t = this.findTimeIndex(gcs, time)) < 0) {
            return "Time= " + time;
        }
        return null;
    }

    public File getCoverage(GetCoverageRequest req) throws IOException, InvalidRangeException {
        String vertical;
        String vname = req.getCoverage();
        GridDatatype geogrid = this.gridDataset.findGridDatatype(vname);
        GridCoordSystem gcs = geogrid.getCoordinateSystem();
        Range t_range = null;
        Range z_range = null;
        Range y_range = null;
        Range x_range = null;
        DateRange dateRange = null;
        String time = req.getTime();
        if (time != null) {
            int t = this.findTimeIndex(gcs, time);
            t_range = new Range(t, t);
            DateType date = null;
            try {
                date = new DateType(time, null, null);
            }
            catch (ParseException e) {
                throw new InvalidRangeException("Invalid time request <" + time + ">: " + e.getMessage());
            }
            dateRange = new DateRange(date, date, null, null);
        }
        if ((vertical = req.getVertical()) != null) {
            CoordinateAxis1D vaxis = gcs.getVerticalAxis();
            int z = vaxis.getIndex(vertical);
            z_range = new Range(z, z);
        }
        if (null != req.getBoundingBox()) {
            List<Range> ranges = gcs.getRangesFromLatLonRect(req.getBoundingBox());
            y_range = ranges.get(0);
            x_range = ranges.get(1);
        }
        if (this.debug) {
            System.out.println(" bb=" + req.getBoundingBox());
            System.out.println(" y_range=" + y_range);
            System.out.println(" x_range=" + x_range);
        }
        GridDatatype subset = geogrid.makeSubset(null, null, t_range, z_range, y_range, x_range);
        Array data = subset.readDataSlice(0, 0, -1, -1);
        if (req.getFormat() == GetCoverageRequest.Format.GeoTIFF || req.getFormat() == GetCoverageRequest.Format.GeoTIFFfloat) {
            File tifFile = WcsDataset.getDiskCache().getCacheFile(this.datasetPath + "-" + vname + ".tif");
            if (this.debug) {
                System.out.println(" tifFile=" + tifFile.getPath());
            }
            GeotiffWriter writer = new GeotiffWriter(tifFile.getPath());
            writer.writeGrid(this.gridDataset, subset, data, req.getFormat() == GetCoverageRequest.Format.GeoTIFF);
            writer.close();
            return tifFile;
        }
        if (req.getFormat() == GetCoverageRequest.Format.NetCDF3) {
            File ncFile = WcsDataset.getDiskCache().getCacheFile(this.datasetPath + "-" + vname + ".nc");
            if (this.debug) {
                System.out.println(" ncFile=" + ncFile.getPath());
            }
            NetcdfCFWriter writer = new NetcdfCFWriter();
            writer.makeFile(ncFile.getPath(), this.gridDataset, Collections.singletonList(req.getCoverage()), req.getBoundingBox(), dateRange, true, 1, 1, 1);
            return ncFile;
        }
        return null;
    }

    private int findTimeIndex(GridCoordSystem gcs, String timeName) {
        CoordinateAxis1DTime taxis = gcs.getTimeAxis1D();
        Date[] dates = taxis.getTimeDates();
        DateFormatter formatter = new DateFormatter();
        for (int i = 0; i < dates.length; ++i) {
            String name = formatter.toDateTimeStringISO(dates[i]);
            if (!name.equals(timeName)) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] args) throws IOException {
        String name = "C:/data/grib2/ndfd.wmo";
        GridDataset gd = GridDataset.open(name);
        WcsDataset wcs = new WcsDataset(gd, "ndfd.wmo", false);
        System.out.println(wcs.getCapabilities());
        System.out.println(wcs.describeCoverage());
    }
}

