/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.N3header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class N3channelWriter {
    private static int buffer_size = 1000000;
    private NetcdfFile ncfile;
    private List<Vinfo> vinfoList = new ArrayList<Vinfo>();
    private boolean debugPos = false;
    private boolean debugWriteData = false;
    private int dataStart;
    private int dataOffset = 0;
    private ByteBuffer padddingBB;

    public N3channelWriter(NetcdfFile ncfile) {
        this.ncfile = ncfile;
    }

    public void writeHeader(DataOutputStream stream) throws IOException {
        this.ncfile.finish();
        stream.write(N3header.MAGIC);
        int count = N3header.MAGIC.length;
        Dimension udim = this.ncfile.getUnlimitedDimension();
        int numrec = udim == null ? 0 : udim.getLength();
        stream.writeInt(numrec);
        count += 4;
        List<Dimension> dims = this.ncfile.getDimensions();
        int numdims = dims.size();
        if (numdims == 0) {
            stream.writeInt(0);
            stream.writeInt(0);
        } else {
            stream.writeInt(10);
            stream.writeInt(numdims);
        }
        count += 8;
        for (int i = 0; i < numdims; ++i) {
            Dimension dim = dims.get(i);
            count += this.writeString(stream, dim.getName());
            stream.writeInt(dim.isUnlimited() ? 0 : dim.getLength());
            count += 4;
        }
        count += this.writeAtts(stream, this.ncfile.getGlobalAttributes());
        List<Variable> vars = this.ncfile.getVariables();
        int nvars = vars.size();
        if (nvars == 0) {
            stream.writeInt(0);
            stream.writeInt(0);
        } else {
            stream.writeInt(11);
            stream.writeInt(nvars);
        }
        count += 8;
        for (int i = 0; i < nvars; ++i) {
            Variable var = vars.get(i);
            if (var instanceof Structure) continue;
            Vinfo vinfo = this.writeVar(null, var, 0);
            count += vinfo.hsize;
        }
        int offset = this.dataStart = count;
        for (int i = 0; i < nvars; ++i) {
            Variable var = vars.get(i);
            if (var.isUnlimited()) continue;
            Vinfo vinfo = this.writeVar(stream, var, offset);
            if (this.debugPos) {
                System.out.println(var.getName() + " begin at = " + offset + " end=" + (offset + vinfo.vsize));
            }
            offset += vinfo.vsize;
            this.vinfoList.add(vinfo);
        }
        int recStart = offset;
        int recsize = 0;
        for (int i = 0; i < nvars; ++i) {
            Variable var = vars.get(i);
            if (!var.isUnlimited() || var instanceof Structure) continue;
            Vinfo vinfo = this.writeVar(stream, var, offset);
            if (this.debugPos) {
                System.out.println(var.getName() + "(record) begin at = " + offset + " end=" + (offset + vinfo.vsize) + " size=" + vinfo.vsize);
            }
            offset += vinfo.vsize;
            recsize += vinfo.vsize;
            this.vinfoList.add(vinfo);
        }
        if (this.debugPos) {
            System.out.println("recsize = " + recsize);
        }
    }

    private Vinfo writeVar(DataOutputStream stream, Variable var, int offset) throws IOException {
        int count = 0;
        count += this.writeString(stream, var.getName());
        int vsize = var.getDataType().getSize();
        List<Dimension> dims = var.getDimensions();
        if (null != stream) {
            stream.writeInt(dims.size());
        }
        count += 4;
        for (Dimension dim : dims) {
            int dimIndex = this.findDimensionIndex(dim);
            if (null != stream) {
                stream.writeInt(dimIndex);
            }
            count += 4;
            if (dim.isUnlimited()) continue;
            vsize *= dim.getLength();
        }
        vsize += N3header.padding(vsize);
        count += this.writeAtts(stream, var.getAttributes());
        int type = N3header.getType(var.getDataType());
        if (null != stream) {
            stream.writeInt(type);
            stream.writeInt(vsize);
            stream.writeInt(offset);
        }
        return new Vinfo(var, count += 12, vsize, var.isUnlimited());
    }

    private int writeAtts(DataOutputStream stream, List<Attribute> atts) throws IOException {
        int natts = atts.size();
        if (null != stream) {
            if (natts == 0) {
                stream.writeInt(0);
                stream.writeInt(0);
            } else {
                stream.writeInt(12);
                stream.writeInt(natts);
            }
        }
        int count = 8;
        for (int i = 0; i < natts; ++i) {
            Attribute att = atts.get(i);
            count += this.writeString(stream, att.getName());
            int type = N3header.getType(att.getDataType());
            if (null != stream) {
                stream.writeInt(type);
            }
            count += 4;
            if (type == 2) {
                count += this.writeStringValues(stream, att);
                continue;
            }
            int nelems = att.getLength();
            if (null != stream) {
                stream.writeInt(nelems);
            }
            count += 4;
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.writeAttributeValue(stream, att.getNumericValue(j));
            }
            count += nbytes;
            count += this.pad(stream, nbytes, (byte)0);
        }
        return count;
    }

    private int writeStringValues(DataOutputStream stream, Attribute att) throws IOException {
        int n = att.getLength();
        if (n == 1) {
            return this.writeString(stream, att.getStringValue());
        }
        StringBuffer values = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            values.append(att.getStringValue(i));
        }
        return this.writeString(stream, values.toString());
    }

    private int writeAttributeValue(DataOutputStream stream, Number numValue) throws IOException {
        if (numValue instanceof Byte) {
            if (null != stream) {
                stream.write(numValue.byteValue());
            }
            return 1;
        }
        if (numValue instanceof Short) {
            if (null != stream) {
                stream.writeShort(numValue.shortValue());
            }
            return 2;
        }
        if (numValue instanceof Integer) {
            if (null != stream) {
                stream.writeInt(numValue.intValue());
            }
            return 4;
        }
        if (numValue instanceof Float) {
            if (null != stream) {
                stream.writeFloat(numValue.floatValue());
            }
            return 4;
        }
        if (numValue instanceof Double) {
            if (null != stream) {
                stream.writeDouble(numValue.doubleValue());
            }
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private int writeString(DataOutputStream stream, String s) throws IOException {
        byte[] b = s.getBytes();
        if (null != stream) {
            stream.writeInt(b.length);
            stream.write(b);
        }
        int n = this.pad(stream, b.length, (byte)0);
        return n + 4 + b.length;
    }

    private int findDimensionIndex(Dimension wantDim) {
        List<Dimension> dims = this.ncfile.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (!dim.equals(wantDim)) continue;
            return i;
        }
        throw new IllegalStateException("unknown Dimension == " + wantDim);
    }

    private int pad(DataOutputStream stream, int nbytes, byte fill) throws IOException {
        int pad = N3header.padding(nbytes);
        if (null != stream) {
            for (int i = 0; i < pad; ++i) {
                stream.write(fill);
            }
        }
        return pad;
    }

    public void writeData(WritableByteChannel channel) throws IOException, InvalidRangeException {
        for (Vinfo vinfo : this.vinfoList) {
            if (vinfo.isRecord) continue;
            Variable v = vinfo.v;
            this.ncfile.readData(v, v.getShapeAsSection(), channel);
            this.pad(channel, vinfo.vsize);
        }
        boolean useRecordDimension = this.ncfile.hasUnlimitedDimension();
        if (useRecordDimension) {
            this.ncfile.sendIospMessage("AddRecordStructure");
            Structure recordVar = (Structure)this.ncfile.findVariable("record");
            Section section = new Section();
            section.appendRange(null);
            long total = 0L;
            int nrecs = (int)recordVar.getSize();
            int sdataSize = recordVar.getElementSize();
            int nr = Math.max(buffer_size / sdataSize, 1);
            for (int count = 0; count < nrecs; count += nr) {
                section.setRange(0, new Range(count, count + nr - 1));
                try {
                    total += this.ncfile.readData(recordVar, section, channel);
                    continue;
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                    break;
                }
            }
            System.out.println("write record var; total = " + (total /= 1000000L) + " Mbytes # recs=" + nrecs + " nr= " + nr);
            this.ncfile.sendIospMessage("RemoveRecordStructure");
            this.ncfile.finish();
        }
    }

    private int pad(WritableByteChannel channel, int nbytes) throws IOException {
        int pad = N3header.padding(nbytes);
        if (null != channel && pad > 0) {
            if (this.padddingBB == null) {
                this.padddingBB = ByteBuffer.allocate(4);
            }
            this.padddingBB.position(0);
            this.padddingBB.limit(pad);
            channel.write(this.padddingBB);
        }
        return pad;
    }

    public static void writeFromFile(NetcdfFile fileIn, String fileOutName) throws IOException, InvalidRangeException {
        FileOutputStream stream = new FileOutputStream(fileOutName);
        FileChannel channel = stream.getChannel();
        DataOutputStream dout = new DataOutputStream(Channels.newOutputStream(channel));
        N3channelWriter writer = new N3channelWriter(fileIn);
        writer.writeHeader(dout);
        writer.writeData(channel);
        channel.close();
    }

    static class Vinfo {
        Variable v;
        int hsize;
        int vsize;
        int pad;
        boolean isRecord;

        Vinfo(Variable v, int hsize, int vsize, boolean isRecord) {
            this.v = v;
            this.hsize = hsize;
            this.vsize = vsize;
            this.isRecord = isRecord;
        }
    }
}

