/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.AbstractPluginTaskFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PluginTaskProvider<P> {
    private final TableMap<String, AbstractPluginTaskFactory<P>> factories;

    public PluginTaskProvider(AbstractPluginTaskFactory<P>[] factories) {
        this.factories = new TableMap(Arrays.asList(factories), new IKeyExtractor<String, AbstractPluginTaskFactory<P>>(){

            @Override
            public String getKey(AbstractPluginTaskFactory<P> factory) {
                return factory.getPluginDescription().getKey();
            }
        });
    }

    public P getPluginInstance(String pluginKey) {
        return this.getFactory(pluginKey).getPluginInstance();
    }

    public DatastoreServiceDescription getPluginDescription(String pluginKey) {
        return this.getFactory(pluginKey).getPluginDescription();
    }

    public List<DatastoreServiceDescription> getPluginDescriptions() {
        ArrayList<DatastoreServiceDescription> descriptions = new ArrayList<DatastoreServiceDescription>();
        for (AbstractPluginTaskFactory<P> factory : this.factories.values()) {
            descriptions.add(factory.getPluginDescription());
        }
        return descriptions;
    }

    public void check(boolean checkIfSerializable) {
        for (AbstractPluginTaskFactory<P> factory : this.factories.values()) {
            factory.check(checkIfSerializable);
        }
    }

    public void logConfigurations() {
        for (AbstractPluginTaskFactory<P> factory : this.factories.values()) {
            factory.logConfiguration();
        }
    }

    private AbstractPluginTaskFactory<P> getFactory(String pluginKey) {
        AbstractPluginTaskFactory<P> factory = this.factories.tryGet(pluginKey);
        if (factory == null) {
            throw new IllegalArgumentException("No plugin registered for key '" + pluginKey + "'.");
        }
        return factory;
    }
}

