/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOriginalDataProviderWithoutHeaders<T>
implements IOriginalDataProvider<T> {
    private static final List<TableModelColumnHeader> NO_HEADERS = new ArrayList<TableModelColumnHeader>();
    private List<T> originalData;

    @Override
    public List<TableModelColumnHeader> getHeaders() {
        return NO_HEADERS;
    }

    @Override
    public List<T> getOriginalData(int maxSize) throws UserFailureException {
        List<T> fullList = this.getOriginalData();
        return fullList.subList(0, Math.min(fullList.size(), maxSize));
    }

    private List<T> getOriginalData() throws UserFailureException {
        if (this.originalData == null) {
            this.originalData = this.getFullOriginalData();
        }
        return this.originalData;
    }

    public abstract List<T> getFullOriginalData();
}

