/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.api.v1;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.api.v1.ExperimentToDataSetRelatedEntitiesTranslator;
import ch.systemsx.cisd.openbis.generic.server.api.v1.GeneralInformationServiceLogger;
import ch.systemsx.cisd.openbis.generic.server.api.v1.SampleToDataSetRelatedEntitiesTranslator;
import ch.systemsx.cisd.openbis.generic.server.api.v1.SearchCriteriaToDetailedSearchCriteriaTranslator;
import ch.systemsx.cisd.openbis.generic.server.api.v1.sort.SampleSearchResultSorter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentListPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleListPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SamplePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DataSetByExperimentIdentifierValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IProjectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.DataSetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister.SampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.search.SampleSearchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDatabaseInstanceDAO;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.Translator;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataStoreURLForDataSets;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Role;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchableEntityKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SpaceWithProjectsAndRoleAssignments;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.IProjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.ISampleId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelatedEntities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MetaprojectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="general-information-api-server-v1")
public class GeneralInformationService
extends AbstractServer<IGeneralInformationService>
implements IGeneralInformationService {
    public static final int MINOR_VERSION = 25;
    @Resource(name="common-server")
    private ICommonServer commonServer;
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory boFactory;
    @Resource(name="managed-property-evaluator-factory")
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public GeneralInformationService() {
    }

    GeneralInformationService(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, ICommonBusinessObjectFactory boFactory, IPropertiesBatchManager propertiesBatchManager, ICommonServer commonServer) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.boFactory = boFactory;
        this.commonServer = commonServer;
    }

    @Override
    public IGeneralInformationService createLogger(IInvocationLoggerContext context) {
        return new GeneralInformationServiceLogger(this.sessionManager, context);
    }

    @Override
    @Transactional
    public String tryToAuthenticateForAllServices(String userID, String userPassword) {
        SessionContextDTO session = this.tryAuthenticate(userID, userPassword);
        return session == null ? null : session.getSessionToken();
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isSessionActive(String sessionToken) {
        return this.tryGetSession(sessionToken) != null;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public Map<String, Set<Role>> listNamedRoleSets(String sessionToken) {
        RoleWithHierarchy[] values;
        this.checkSession(sessionToken);
        LinkedHashMap<String, Set<Role>> namedRoleSets = new LinkedHashMap<String, Set<Role>>();
        RoleWithHierarchy[] roleWithHierarchyArray = values = RoleWithHierarchy.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            RoleWithHierarchy roleSet = roleWithHierarchyArray[n2];
            Set<RoleWithHierarchy> roles = roleSet.getRoles();
            HashSet<Role> translatedRoles = new HashSet<Role>();
            for (RoleWithHierarchy role : roles) {
                translatedRoles.add(Translator.translate(role));
            }
            namedRoleSets.put(roleSet.name(), translatedRoles);
            ++n2;
        }
        return namedRoleSets;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SimpleSpaceValidator.class)
    public List<SpaceWithProjectsAndRoleAssignments> listSpacesWithProjectsAndRoleAssignments(String sessionToken, String databaseInstanceCodeOrNull) {
        this.checkSession(sessionToken);
        Map<String, List<RoleAssignmentPE>> roleAssignmentsPerSpace = this.getRoleAssignmentsPerSpace();
        List<RoleAssignmentPE> instanceRoleAssignments = roleAssignmentsPerSpace.get(null);
        List<SpacePE> spaces = this.listSpaces(databaseInstanceCodeOrNull);
        ArrayList<SpaceWithProjectsAndRoleAssignments> result = new ArrayList<SpaceWithProjectsAndRoleAssignments>();
        for (SpacePE space : spaces) {
            SpaceWithProjectsAndRoleAssignments fullSpace = new SpaceWithProjectsAndRoleAssignments(space.getCode());
            this.addProjectsTo(fullSpace, space);
            this.addRoles(fullSpace, instanceRoleAssignments);
            List<RoleAssignmentPE> list = roleAssignmentsPerSpace.get(space.getCode());
            if (list != null) {
                this.addRoles(fullSpace, list);
            }
            result.add(fullSpace);
        }
        return result;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 25;
    }

    private Map<String, List<RoleAssignmentPE>> getRoleAssignmentsPerSpace() {
        List<RoleAssignmentPE> roleAssignments = this.getDAOFactory().getRoleAssignmentDAO().listRoleAssignments();
        HashMap<String, List<RoleAssignmentPE>> roleAssignmentsPerSpace = new HashMap<String, List<RoleAssignmentPE>>();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            SpacePE space = roleAssignment.getSpace();
            String spaceCode = space == null ? null : space.getCode();
            ArrayList<RoleAssignmentPE> list = (ArrayList<RoleAssignmentPE>)roleAssignmentsPerSpace.get(spaceCode);
            if (list == null) {
                list = new ArrayList<RoleAssignmentPE>();
                roleAssignmentsPerSpace.put(spaceCode, list);
            }
            list.add(roleAssignment);
        }
        return roleAssignmentsPerSpace;
    }

    private List<SpacePE> listSpaces(String databaseInstanceCodeOrNull) {
        IDAOFactory daoFactory = this.getDAOFactory();
        DatabaseInstancePE databaseInstance = daoFactory.getHomeDatabaseInstance();
        if (databaseInstanceCodeOrNull != null) {
            IDatabaseInstanceDAO databaseInstanceDAO = daoFactory.getDatabaseInstanceDAO();
            databaseInstance = databaseInstanceDAO.tryFindDatabaseInstanceByCode(databaseInstanceCodeOrNull);
        }
        return daoFactory.getSpaceDAO().listSpaces(databaseInstance);
    }

    private void addProjectsTo(SpaceWithProjectsAndRoleAssignments fullSpace, SpacePE space) {
        List<ProjectPE> projects = this.getDAOFactory().getProjectDAO().listProjects(space);
        for (ProjectPE project : projects) {
            fullSpace.add(new Project(project.getId(), project.getPermId(), fullSpace.getCode(), project.getCode(), project.getDescription()));
        }
    }

    private void addRoles(SpaceWithProjectsAndRoleAssignments fullSpace, List<RoleAssignmentPE> list) {
        for (RoleAssignmentPE roleAssignment : list) {
            Role role = Translator.translate(roleAssignment.getRole(), roleAssignment.getSpace() != null);
            AuthorizationGroupPE authorizationGroup = roleAssignment.getAuthorizationGroup();
            Set<PersonPE> persons = authorizationGroup != null ? authorizationGroup.getPersons() : Collections.singleton(roleAssignment.getPerson());
            for (PersonPE person : persons) {
                fullSpace.add(person.getUserId(), role);
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleByIdentiferValidator.class)
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> searchForSamples(String sessionToken, SearchCriteria searchCriteria) {
        return this.searchForSamples(sessionToken, searchCriteria, EnumSet.of(SampleFetchOption.PROPERTIES));
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleByIdentiferValidator.class)
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> searchForSamples(String sessionToken, SearchCriteria searchCriteria, EnumSet<SampleFetchOption> fetchOptions) {
        Session session = this.getSession(sessionToken);
        PersonPE user = session.tryGetPerson();
        return this.searchForSamples(session, session.getUserName(), user, searchCriteria, fetchOptions);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> searchForSamplesOnBehalfOfUser(String sessionToken, SearchCriteria searchCriteria, EnumSet<SampleFetchOption> fetchOptions, String userId) {
        Session session = this.getSession(sessionToken);
        PersonPE user = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        return this.searchForSamples(session, userId, user, searchCriteria, fetchOptions);
    }

    private List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> searchForSamples(Session session, String userId, PersonPE user, SearchCriteria searchCriteria, EnumSet<SampleFetchOption> fetchOptions) {
        EnumSet<SampleFetchOption> sampleFetchOptions = fetchOptions != null ? fetchOptions : EnumSet.noneOf(SampleFetchOption.class);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.SAMPLE, searchCriteria);
        ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister sampleLister = this.boFactory.createSampleLister(session, user.getId());
        Collection<Long> sampleIDs = new SampleSearchManager(this.getDAOFactory().getHibernateSearchDAO(), sampleLister).searchForSampleIDs(userId, detailedSearchCriteria);
        SampleByIdentiferValidator filter = new SampleByIdentiferValidator();
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> results = this.createSampleLister(user).getSamples(sampleIDs, sampleFetchOptions, filter);
        return new SampleSearchResultSorter().sort(results, detailedSearchCriteria);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> filterSamplesVisibleToUser(String sessionToken, List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> allSamples, String userId) {
        this.checkSession(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample>(allSamples.size());
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample sample : allSamples) {
            if (!validator.doValidation(person, sample)) continue;
            samples.add(sample);
        }
        return samples;
    }

    protected ISampleLister createSampleLister(PersonPE person) {
        return new SampleLister(this.getDAOFactory(), person);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleByIdentiferValidator.class)
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> listSamplesForExperiment(String sessionToken, @AuthorizationGuard(guardClass=ExperimentAugmentedCodePredicate.class) String experimentIdentifierString) {
        this.checkSession(sessionToken);
        ExperimentIdentifier experimentId = new ExperimentIdentifierFactory(experimentIdentifierString).createIdentifier();
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment privateExperiment = this.commonServer.getExperimentInfo(sessionToken, experimentId);
        ListSampleCriteria listSampleCriteria = ListSampleCriteria.createForExperiment(new TechId(privateExperiment.getId()));
        List<Sample> privateSamples = this.commonServer.listSamples(sessionToken, listSampleCriteria);
        return Translator.translateSamples(privateSamples);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> listSamplesForExperimentOnBehalfOfUser(String sessionToken, @AuthorizationGuard(guardClass=ExperimentAugmentedCodePredicate.class) String experimentIdentifierString, String userId) {
        this.checkSession(sessionToken);
        ExperimentIdentifier experimentId = new ExperimentIdentifierFactory(experimentIdentifierString).createIdentifier();
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment privateExperiment = this.commonServer.getExperimentInfo(sessionToken, experimentId);
        ListSampleCriteria listSampleCriteria = ListSampleCriteria.createForExperiment(new TechId(privateExperiment.getId()));
        List<Sample> privateSamples = this.commonServer.listSamplesOnBehalfOfUser(sessionToken, listSampleCriteria, userId);
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> unfilteredSamples = Translator.translateSamples(privateSamples);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample>(unfilteredSamples.size());
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample sample : unfilteredSamples) {
            if (!validator.doValidation(person, sample)) continue;
            samples.add(sample);
        }
        return samples;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentIdentifierValidator.class)
    public List<DataSet> listDataSets(String sessionToken, @AuthorizationGuard(guardClass=SampleListPredicate.class) List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples) {
        return this.listDataSets(sessionToken, samples, EnumSet.noneOf(DataSet.Connections.class));
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> listExperiments(String sessionToken, @AuthorizationGuard(guardClass=ProjectPredicate.class) List<Project> projects, String experimentTypeString) {
        return this.listExperiments(sessionToken, projects, experimentTypeString, false, false);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> listExperimentsHavingDataSets(String sessionToken, @AuthorizationGuard(guardClass=ProjectPredicate.class) List<Project> projects, String experimentTypeString) {
        return this.listExperiments(sessionToken, projects, experimentTypeString, false, true);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> listExperimentsHavingSamples(String sessionToken, @AuthorizationGuard(guardClass=ProjectPredicate.class) List<Project> projects, String experimentTypeString) {
        return this.listExperiments(sessionToken, projects, experimentTypeString, true, false);
    }

    private List<Experiment> listExperiments(String sessionToken, List<Project> projects, String experimentTypeString, boolean onlyHavingSamples, boolean onlyHavingDataSets) {
        this.checkSession(sessionToken);
        ExperimentType experimentType = null;
        if (experimentTypeString == null || "(all)".equals(experimentTypeString)) {
            experimentType = new ExperimentType();
            experimentType.setCode("(all)");
        } else {
            experimentType = this.tryFindExperimentType(sessionToken, experimentTypeString);
            if (experimentType == null) {
                throw new UserFailureException("Unknown experiment type : " + experimentTypeString);
            }
        }
        LinkedList<ProjectIdentifier> projectIdentifiers = new LinkedList<ProjectIdentifier>();
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        for (Project project : projects) {
            ProjectIdentifier projectIdentifier = new ProjectIdentifier(project.getSpaceCode(), project.getCode());
            projectIdentifiers.add(projectIdentifier);
        }
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment> basicExperiments = onlyHavingSamples ? this.commonServer.listExperimentsHavingSamples(sessionToken, experimentType, projectIdentifiers) : (onlyHavingDataSets ? this.commonServer.listExperimentsHavingDataSets(sessionToken, experimentType, projectIdentifiers) : this.commonServer.listExperiments(sessionToken, experimentType, projectIdentifiers));
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment basicExperiment : basicExperiments) {
            experiments.add(Translator.translate(basicExperiment));
        }
        return experiments;
    }

    private ExperimentType tryFindExperimentType(String sessionToken, String experimentTypeString) {
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        for (ExperimentType anExperimentType : experimentTypes) {
            if (!anExperimentType.getCode().equals(experimentTypeString)) continue;
            return anExperimentType;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<Experiment> filterExperimentsVisibleToUser(String sessionToken, List<Experiment> allExperiments, String userId) {
        this.checkSession(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        ExperimentByIdentiferValidator validator = new ExperimentByIdentiferValidator();
        ArrayList<Experiment> experiments = new ArrayList<Experiment>(allExperiments.size());
        for (Experiment experiment : allExperiments) {
            if (!validator.doValidation(person, experiment)) continue;
            experiments.add(experiment);
        }
        return experiments;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentIdentifierValidator.class)
    public List<DataSet> listDataSetsForSample(String sessionToken, @AuthorizationGuard(guardClass=SamplePredicate.class) ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample sample, boolean areOnlyDirectlyConnectedIncluded) {
        this.checkSession(sessionToken);
        List<AbstractExternalData> externalData = this.commonServer.listSampleExternalData(sessionToken, new TechId(sample.getId()), areOnlyDirectlyConnectedIncluded);
        return Translator.translate(externalData, EnumSet.noneOf(DataSet.Connections.class));
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DataStore> listDataStores(String sessionToken) {
        return Translator.translateDataStores(this.commonServer.listDataStores(sessionToken));
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public String getDefaultPutDataStoreBaseURL(String sessionToken) {
        return this.commonServer.getDefaultPutDataStoreBaseURL(sessionToken);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public String tryGetDataStoreBaseURL(String sessionToken, String dataSetCode) {
        Session session = this.getSession(sessionToken);
        DataSetLister lister = new DataSetLister(this.getDAOFactory(), session.tryGetPerson());
        List<DataStoreURLForDataSets> dataStores = lister.getDataStoreDownloadURLs(Collections.singletonList(dataSetCode));
        if (dataStores.isEmpty()) {
            return null;
        }
        return dataStores.get(0).getDataStoreURL();
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<DataStoreURLForDataSets> getDataStoreBaseURLs(String sessionToken, List<String> dataSetCodes) {
        Session session = this.getSession(sessionToken);
        DataSetLister lister = new DataSetLister(this.getDAOFactory(), session.tryGetPerson());
        return lister.getDataStoreDownloadURLs(dataSetCodes);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType> listDataSetTypes(String sessionToken) {
        List<DataSetType> privateDataSetTypes = this.commonServer.listDataSetTypes(sessionToken);
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = this.getVocabularyTermsMap(sessionToken);
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType> dataSetTypes = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType>();
        for (DataSetType privateDataSetType : privateDataSetTypes) {
            dataSetTypes.add(Translator.translate(privateDataSetType, vocabTerms));
        }
        return dataSetTypes;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<SampleType> listSampleTypes(String sessionToken) {
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> sampleTypes = this.commonServer.listSampleTypes(sessionToken);
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = this.getVocabularyTermsMap(sessionToken);
        ArrayList<SampleType> result = new ArrayList<SampleType>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType sampleType : sampleTypes) {
            result.add(Translator.translate(sampleType, vocabTerms));
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ExperimentType> listExperimentTypes(String sessionToken) {
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = this.getVocabularyTermsMap(sessionToken);
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ExperimentType> result = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ExperimentType>();
        for (ExperimentType experimentType : experimentTypes) {
            result.add(Translator.translate(experimentType, vocabTerms));
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> getVocabularyTermsMap(String sessionToken) {
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = new HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>>();
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary> privateVocabularies = this.commonServer.listVocabularies(sessionToken, true, false);
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary privateVocabulary : privateVocabularies) {
            vocabTerms.put(privateVocabulary, Translator.translatePropertyTypeTerms(privateVocabulary.getTerms()));
        }
        return vocabTerms;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Vocabulary> listVocabularies(String sessionToken) {
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary> privateVocabularies = this.commonServer.listVocabularies(sessionToken, true, false);
        ArrayList<Vocabulary> result = new ArrayList<Vocabulary>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary privateVocabulary : privateVocabularies) {
            result.add(Translator.translate(privateVocabulary));
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentIdentifierValidator.class)
    public List<DataSet> listDataSets(String sessionToken, @AuthorizationGuard(guardClass=SampleListPredicate.class) List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples, EnumSet<DataSet.Connections> connections) {
        this.checkSession(sessionToken);
        EnumSet<DataSet.Connections> connectionsToGet = connections != null ? connections : EnumSet.noneOf(DataSet.Connections.class);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> sampleTypes = this.commonServer.listSampleTypes(sessionToken);
        SampleToDataSetRelatedEntitiesTranslator translator = new SampleToDataSetRelatedEntitiesTranslator(sampleTypes, samples);
        DataSetRelatedEntities dsre = translator.convertToDataSetRelatedEntities();
        List<AbstractExternalData> dataSets = this.commonServer.listRelatedDataSets(sessionToken, dsre, true);
        return Translator.translate(dataSets, connectionsToGet);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<DataSet> listDataSetsOnBehalfOfUser(String sessionToken, List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples, EnumSet<DataSet.Connections> connections, String userId) {
        this.checkSession(sessionToken);
        EnumSet<DataSet.Connections> connectionsToGet = connections != null ? connections : EnumSet.noneOf(DataSet.Connections.class);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> sampleTypes = this.commonServer.listSampleTypes(sessionToken);
        SampleToDataSetRelatedEntitiesTranslator translator = new SampleToDataSetRelatedEntitiesTranslator(sampleTypes, samples);
        DataSetRelatedEntities dsre = translator.convertToDataSetRelatedEntities();
        List<AbstractExternalData> dataSets = this.commonServer.listRelatedDataSetsOnBehalfOfUser(sessionToken, dsre, true, userId);
        List<DataSet> unfilteredDatasets = Translator.translate(dataSets, connectionsToGet);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        DataSetByExperimentIdentifierValidator validator = new DataSetByExperimentIdentifierValidator();
        ArrayList<DataSet> datasets = new ArrayList<DataSet>(unfilteredDatasets.size());
        for (DataSet dataset : unfilteredDatasets) {
            if (!validator.doValidation(person, dataset)) continue;
            datasets.add(dataset);
        }
        return datasets;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentIdentifierValidator.class)
    public List<DataSet> listDataSetsForExperiments(String sessionToken, @AuthorizationGuard(guardClass=ExperimentListPredicate.class) List<Experiment> experiments, EnumSet<DataSet.Connections> connections) {
        this.checkSession(sessionToken);
        EnumSet<DataSet.Connections> connectionsToGet = connections != null ? connections : EnumSet.noneOf(DataSet.Connections.class);
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        ExperimentToDataSetRelatedEntitiesTranslator translator = new ExperimentToDataSetRelatedEntitiesTranslator(experimentTypes, experiments);
        DataSetRelatedEntities dsre = translator.convertToDataSetRelatedEntities();
        List<AbstractExternalData> dataSets = this.commonServer.listRelatedDataSets(sessionToken, dsre, true);
        return Translator.translate(dataSets, connectionsToGet);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<DataSet> listDataSetsForExperimentsOnBehalfOfUser(String sessionToken, List<Experiment> experiments, EnumSet<DataSet.Connections> connections, String userId) {
        this.checkSession(sessionToken);
        EnumSet<DataSet.Connections> connectionsToGet = connections != null ? connections : EnumSet.noneOf(DataSet.Connections.class);
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        ExperimentToDataSetRelatedEntitiesTranslator translator = new ExperimentToDataSetRelatedEntitiesTranslator(experimentTypes, experiments);
        DataSetRelatedEntities dsre = translator.convertToDataSetRelatedEntities();
        List<AbstractExternalData> dataSets = this.commonServer.listRelatedDataSetsOnBehalfOfUser(sessionToken, dsre, true, userId);
        List<DataSet> unfilteredDatasets = Translator.translate(dataSets, connectionsToGet);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        DataSetByExperimentIdentifierValidator validator = new DataSetByExperimentIdentifierValidator();
        ArrayList<DataSet> datasets = new ArrayList<DataSet>(unfilteredDatasets.size());
        for (DataSet dataset : unfilteredDatasets) {
            if (!validator.doValidation(person, dataset)) continue;
            datasets.add(dataset);
        }
        return datasets;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentIdentifierValidator.class)
    public List<DataSet> getDataSetMetaData(String sessionToken, List<String> dataSetCodes) {
        Session session = this.getSession(sessionToken);
        IDataDAO dataDAO = this.getDAOFactory().getDataDAO();
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        EnumSet<DataSet.Connections> connections = EnumSet.of(DataSet.Connections.PARENTS, DataSet.Connections.CHILDREN);
        for (String dataSetCode : dataSetCodes) {
            DataPE dataPE = dataDAO.tryToFindDataSetByCode(dataSetCode);
            if (dataPE == null) {
                throw new UserFailureException("Unknown data set " + dataSetCode);
            }
            HibernateUtils.initialize(dataPE.getChildRelationships());
            HibernateUtils.initialize(dataPE.getProperties());
            Collection<MetaprojectPE> metaprojects = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), dataPE);
            AbstractExternalData ds = DataSetTranslator.translate(dataPE, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojects), this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]);
            result.add(Translator.translate(ds, connections));
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentIdentifierValidator.class)
    public List<DataSet> getDataSetMetaData(String sessionToken, List<String> dataSetCodes, EnumSet<DataSetFetchOption> fetchOptions) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("SessionToken was null");
        }
        if (dataSetCodes == null) {
            throw new IllegalArgumentException("DataSetCodes were null");
        }
        if (fetchOptions == null) {
            throw new IllegalArgumentException("FetchOptions were null");
        }
        DataSetFetchOptions dataSetFetchOptions = new DataSetFetchOptions();
        for (DataSetFetchOption option : fetchOptions) {
            dataSetFetchOptions.addOption(option);
        }
        if (dataSetFetchOptions.isSubsetOf(new DataSetFetchOption[]{DataSetFetchOption.BASIC, DataSetFetchOption.PARENTS, DataSetFetchOption.CHILDREN})) {
            Session session = this.getSession(sessionToken);
            DataSetLister lister = new DataSetLister(this.getDAOFactory(), session.tryGetPerson());
            return lister.getDataSetMetaData(dataSetCodes, dataSetFetchOptions);
        }
        List<DataSet> dataSetList = this.getDataSetMetaData(sessionToken, dataSetCodes);
        if (dataSetList != null) {
            for (DataSet dataSet : dataSetList) {
                if (dataSet == null) continue;
                dataSet.setFetchOptions(new DataSetFetchOptions(DataSetFetchOption.values()));
            }
        }
        return dataSetList;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentIdentifierValidator.class)
    public List<DataSet> searchForDataSets(String sessionToken, SearchCriteria searchCriteria) {
        this.checkSession(sessionToken);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.DATA_SET, searchCriteria);
        List<AbstractExternalData> privateDataSets = this.commonServer.searchForDataSets(sessionToken, detailedSearchCriteria);
        return Translator.translate(privateDataSets, EnumSet.noneOf(DataSet.Connections.class));
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<DataSet> searchForDataSetsOnBehalfOfUser(String sessionToken, SearchCriteria searchCriteria, String userId) {
        this.checkSession(sessionToken);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.DATA_SET, searchCriteria);
        List<AbstractExternalData> privateDataSets = this.commonServer.searchForDataSetsOnBehalfOfUser(sessionToken, detailedSearchCriteria, userId);
        return Translator.translate(privateDataSets, EnumSet.noneOf(DataSet.Connections.class));
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<DataSet> filterDataSetsVisibleToUser(String sessionToken, List<DataSet> allDataSets, String userId) {
        this.checkSession(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        DataSetByExperimentIdentifierValidator experimentIdentifierValidator = new DataSetByExperimentIdentifierValidator();
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(allDataSets.size());
        for (DataSet dataSet : allDataSets) {
            if (!experimentIdentifierValidator.doValidation(person, dataSet)) continue;
            dataSets.add(dataSet);
        }
        return dataSets;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> listExperiments(String sessionToken, @AuthorizationGuard(guardClass=ExperimentAugmentedCodePredicate.class) List<String> experimentIdentifiers) {
        this.checkSession(sessionToken);
        List<ExperimentIdentifier> parsedIdentifiers = ExperimentIdentifierFactory.parse(experimentIdentifiers);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment> experiments = this.commonServer.listExperiments(sessionToken, parsedIdentifiers);
        return Translator.translateExperiments(experiments);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> searchForExperiments(String sessionToken, SearchCriteria searchCriteria) {
        this.checkSession(sessionToken);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.EXPERIMENT, searchCriteria);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment> experiments = this.commonServer.searchForExperiments(sessionToken, detailedSearchCriteria);
        return Translator.translateExperiments(experiments);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ProjectByIdentiferValidator.class)
    public List<Project> listProjects(String sessionToken) {
        this.checkSession(sessionToken);
        return Translator.translateProjects(this.commonServer.listProjects(sessionToken));
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<Project> listProjectsOnBehalfOfUser(String sessionToken, String userId) {
        List<Project> unfilteredProjects = this.listProjects(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        ProjectByIdentiferValidator validator = new ProjectByIdentiferValidator();
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Project project : unfilteredProjects) {
            if (!validator.doValidation(person, project)) continue;
            projects.add(project);
        }
        return projects;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> getMaterialByCodes(String sessionToken, List<MaterialIdentifier> materialIdentifier) {
        Collection materialCodes = CollectionUtils.collect(materialIdentifier, (Transformer)new Transformer<MaterialIdentifier, ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier>(){

            public ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier transform(MaterialIdentifier arg0) {
                return new ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier(arg0.getMaterialCode(), arg0.getMaterialTypeIdentifier().getMaterialTypeCode());
            }
        });
        ListMaterialCriteria criteria = ListMaterialCriteria.createFromMaterialIdentifiers(materialCodes);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material> materials = this.commonServer.listMaterials(sessionToken, criteria, true);
        return Translator.translateMaterials(materials);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> searchForMaterials(String sessionToken, SearchCriteria searchCriteria) {
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.MATERIAL, searchCriteria);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material> materials = this.commonServer.searchForMaterials(sessionToken, detailedSearchCriteria);
        return Translator.translateMaterials(materials);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Metaproject> listMetaprojects(String sessionToken) {
        return this.commonServer.listMetaprojects(sessionToken);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<Metaproject> listMetaprojectsOnBehalfOfUser(String sessionToken, String userId) {
        return this.commonServer.listMetaprojectsOnBehalfOfUser(sessionToken, userId);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments getMetaproject(String sessionToken, IMetaprojectId metaprojectId) {
        MetaprojectAssignments assignments = this.commonServer.getMetaprojectAssignments(sessionToken, metaprojectId);
        return this.translate(assignments);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments getMetaprojectOnBehalfOfUser(String sessionToken, IMetaprojectId metaprojectId, String userId) {
        MetaprojectAssignments assignments = this.commonServer.getMetaprojectAssignmentsOnBehalfOfUser(sessionToken, metaprojectId, userId);
        return this.translate(assignments);
    }

    private ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments translate(MetaprojectAssignments assignments) {
        ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments result = new ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments();
        result.setMetaproject(assignments.getMetaproject());
        result.setExperiments(Translator.translateExperiments(assignments.getExperiments()));
        result.setSamples(Translator.translateSamples(assignments.getSamples()));
        result.setDataSets(Translator.translate(assignments.getDataSets(), EnumSet.noneOf(DataSet.Connections.class)));
        result.setMaterials(Translator.translateMaterials(assignments.getMaterials()));
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listAttachmentsForProject(String sessionToken, @AuthorizationGuard(guardClass=ProjectIdPredicate.class) IProjectId projectId, boolean allVersions) {
        Session session = this.getSession(sessionToken);
        IProjectBO projectBO = this.boFactory.createProjectBO(session);
        ProjectPE project = projectBO.tryFindByProjectId(projectId);
        if (project == null) {
            throw new UserFailureException("No project found for id '" + projectId + "'.");
        }
        return this.listAttachments(sessionToken, projectId, project, allVersions);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listAttachmentsForExperiment(String sessionToken, @AuthorizationGuard(guardClass=ExperimentIdPredicate.class) IExperimentId experimentId, boolean allVersions) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        ExperimentPE experiment = experimentBO.tryFindByExperimentId(experimentId);
        if (experiment == null) {
            throw new UserFailureException("No experiment found for id '" + experimentId + "'.");
        }
        return this.listAttachments(sessionToken, experimentId, experiment, allVersions);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listAttachmentsForSample(String sessionToken, @AuthorizationGuard(guardClass=SampleIdPredicate.class) ISampleId sampleId, boolean allVersions) {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        SamplePE sample = sampleBO.tryFindBySampleId(sampleId);
        if (sample == null) {
            throw new UserFailureException("No sample found for id '" + sampleId + "'.");
        }
        return this.listAttachments(sessionToken, sampleId, sample, allVersions);
    }

    private List<Attachment> listAttachments(String sessionToken, IObjectId objectId, AttachmentHolderPE attachmentHolder, boolean allVersions) {
        List<AttachmentPE> attachments = this.getDAOFactory().getAttachmentDAO().listAttachments(attachmentHolder);
        return Translator.translateAttachments(sessionToken, objectId, attachmentHolder, attachments, allVersions);
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public final Map<String, String> getUserDisplaySettings(String sessionToken) {
        String spaceCode = null;
        String projectCode = null;
        PersonPE person = this.getAuthSession(sessionToken).tryGetPerson();
        if (person != null && person.getHomeSpace() != null) {
            spaceCode = person.getHomeSpace().getCode();
        }
        if (person != null && person.getDisplaySettings() != null) {
            projectCode = person.getDisplaySettings().getDefaultProject();
        }
        HashMap<String, String> userSettings = new HashMap<String, String>();
        if (spaceCode != null) {
            userSettings.put("spaceCode", spaceCode);
        }
        if (projectCode != null) {
            userSettings.put("projectCode", projectCode);
        }
        return userSettings;
    }
}

