/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.dataset.IDataSetId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.material.IMaterialId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.ISampleId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonObject(value="MetaprojectAssignmentsIds")
public class MetaprojectAssignmentsIds
implements Serializable {
    private static final long serialVersionUID = 35L;
    private List<IExperimentId> experiments = new ArrayList<IExperimentId>();
    private List<ISampleId> samples = new ArrayList<ISampleId>();
    private List<IDataSetId> dataSets = new ArrayList<IDataSetId>();
    private List<IMaterialId> materials = new ArrayList<IMaterialId>();

    public void addExperiment(IExperimentId experimentId) {
        if (experimentId == null) {
            throw new IllegalArgumentException("Experiment id cannot be null");
        }
        this.experiments.add(experimentId);
    }

    public void addSample(ISampleId sampleId) {
        if (sampleId == null) {
            throw new IllegalArgumentException("Sample id cannot be null");
        }
        this.samples.add(sampleId);
    }

    public void addDataSet(IDataSetId dataSetId) {
        if (dataSetId == null) {
            throw new IllegalArgumentException("Data set id cannot be null");
        }
        this.dataSets.add(dataSetId);
    }

    public void addMaterial(IMaterialId materialId) {
        if (materialId == null) {
            throw new IllegalArgumentException("Material id cannot be null");
        }
        this.materials.add(materialId);
    }

    public List<IExperimentId> getExperiments() {
        return this.experiments;
    }

    public List<ISampleId> getSamples() {
        return this.samples;
    }

    public List<IDataSetId> getDataSets() {
        return this.dataSets;
    }

    public List<IMaterialId> getMaterials() {
        return this.materials;
    }

    private void setExperiments(List<IExperimentId> experiments) {
        this.experiments = experiments == null ? Collections.emptyList() : experiments;
    }

    private void setSamples(List<ISampleId> samples) {
        this.samples = samples == null ? Collections.emptyList() : samples;
    }

    private void setDataSets(List<IDataSetId> dataSets) {
        this.dataSets = dataSets == null ? Collections.emptyList() : dataSets;
    }

    private void setMaterials(List<IMaterialId> materials) {
        this.materials = materials == null ? Collections.emptyList() : materials;
    }
}

