/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractDeletedEntityPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.search.annotations.DocumentId;

@Entity
@Table(name="data_deleted")
@Inheritance(strategy=InheritanceType.JOINED)
public class DeletedDataPE
extends AbstractDeletedEntityPE {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private Long experimentId;
    private Long sampleId;
    private DataStorePE dataStore;
    private DataSetTypePE dataSetType;

    @Override
    @Id
    @SequenceGenerator(name="DATA_ID_SEQ", sequenceName="DATA_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_ID_SEQ")
    @DocumentId(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Transient
    public String getPermId() {
        return this.getCode();
    }

    @Column(name="expe_id", nullable=false, insertable=false, updatable=false)
    public Long getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(Long experimentId) {
        this.experimentId = experimentId;
    }

    @Column(name="samp_id", nullable=false, insertable=false, updatable=false)
    public Long getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(Long experimentId) {
        this.sampleId = experimentId;
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeletedDataPE)) {
            return false;
        }
        DeletedDataPE that = (DeletedDataPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    @Override
    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("deletion", (Object)this.getDeletion());
        return builder.toString();
    }

    @Transient
    public boolean isAvailable() {
        return false;
    }

    @Transient
    public boolean isDeletable() {
        return true;
    }

    @Transient
    public DeletedExternalDataPE tryAsExternalData() {
        return this instanceof DeletedExternalDataPE ? (DeletedExternalDataPE)this : null;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Data store can not be null.")
    @JoinColumn(name="dast_id", updatable=false)
    public DataStorePE getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(DataStorePE dataStorePE) {
        this.dataStore = dataStorePE;
    }

    @Override
    @Transient
    public String getIdentifier() {
        return this.getCode();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Data set type can not be null.")
    @JoinColumn(name="dsty_id")
    public DataSetTypePE getDataSetType() {
        return this.dataSetType;
    }

    public void setDataSetType(DataSetTypePE dataSetType) {
        this.dataSetType = dataSetType;
    }

    @Override
    @Transient
    public EntityTypePE getEntityType() {
        return this.getDataSetType();
    }

    @Override
    @Transient
    public EntityKind getEntityKind() {
        return EntityKind.DATA_SET;
    }
}

