/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelationshipRole;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;

public class DataSetRelationshipBrowser
extends AbstractExternalDataGrid {
    private static final String PREFIX = "data-set-relationships-section_";
    public static final String ID_PREFIX = "openbis_data-set-relationships-section_";
    private final TechId datasetId;
    private final DataSetRelationshipRole role;

    public static IDisposableComponent create(IViewContext<?> viewContext, TechId datasetId, final DataSetRelationshipRole role, final DataSetType datasetType) {
        IViewContext<ICommonClientServiceAsync> commonViewContext = viewContext.getCommonViewContext();
        DataSetRelationshipBrowser browser = new DataSetRelationshipBrowser(commonViewContext, datasetId, role){

            @Override
            public String getGridDisplayTypeID() {
                return String.valueOf(super.getGridDisplayTypeID()) + "-" + datasetType.getCode() + "-" + role;
            }
        };
        return browser.asDisposableWithoutToolbar();
    }

    private DataSetRelationshipBrowser(IViewContext<ICommonClientServiceAsync> viewContext, TechId datasetId, DataSetRelationshipRole role) {
        super(viewContext, DataSetRelationshipBrowser.createBrowserId(datasetId, role), DataSetRelationshipBrowser.createGridId(datasetId, role), DisplayTypeIDGenerator.DATA_SET_DETAILS_GRID);
        this.datasetId = datasetId;
        this.role = role;
    }

    public static final String createGridId(TechId datasetId, DataSetRelationshipRole role) {
        return String.valueOf(DataSetRelationshipBrowser.createBrowserId(datasetId, role)) + "-grid";
    }

    public static final String createBrowserId(TechId datasetId, DataSetRelationshipRole role) {
        return ID_PREFIX + datasetId + "-" + role;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<AbstractExternalData>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listDataSetRelationships(this.datasetId, this.role, resultSetConfig, callback);
    }

    /* synthetic */ DataSetRelationshipBrowser(IViewContext iViewContext, TechId techId, DataSetRelationshipRole dataSetRelationshipRole, DataSetRelationshipBrowser dataSetRelationshipBrowser) {
        this((IViewContext<ICommonClientServiceAsync>)iViewContext, techId, dataSetRelationshipRole);
    }
}

