/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ColumnIDUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;

public class ExperimentAnalysisSummaryGrid
extends TypedTableGrid<MaterialFeatureVectorSummary>
implements AnalysisProcedureChooser.IAnalysisProcedureSelectionListener {
    private static final String PREFIX = "openbis_experiment-feature-vector-summary";
    private static final String BROWSER_ID = "openbis_experiment-feature-vector-summary_main";
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final IEntityInformationHolderWithIdentifier experiment;
    private final boolean restrictGlobalScopeLinkToProject;
    private WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;

    public static IDisposableComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithIdentifier experiment, boolean restrictGlobalScopeLinkToProject, WellSearchCriteria.AnalysisProcedureCriteria initialAnalysisProcedureOrNull) {
        return new ExperimentAnalysisSummaryGrid(viewContext, experiment, restrictGlobalScopeLinkToProject, initialAnalysisProcedureOrNull).asDisposableWithoutToolbar();
    }

    private ICellListenerAndLinkGenerator<MaterialFeatureVectorSummary> createMaterialReplicaSummaryLinkGenerator() {
        return new ICellListenerAndLinkGenerator<MaterialFeatureVectorSummary>(){

            @Override
            public void handle(TableModelRowWithObject<MaterialFeatureVectorSummary> rowItem, boolean specialKeyPressed) {
                IEntityInformationHolderWithPermId material = (IEntityInformationHolderWithPermId)rowItem.getObjectOrNull().getMaterial();
                ExperimentAnalysisSummaryGrid.this.openMaterialDetailViewer(material);
            }

            @Override
            public String tryGetLink(MaterialFeatureVectorSummary entity, ISerializableComparable comparableValue) {
                IEntityInformationHolder material = (IEntityInformationHolder)entity.getMaterial();
                return ScreeningLinkExtractor.createMaterialDetailsLink(material, ExperimentAnalysisSummaryGrid.this.getExperimentAsSearchCriteria());
            }
        };
    }

    private void openMaterialDetailViewer(IEntityInformationHolderWithPermId material) {
        assert (this.analysisProcedureCriteria != null) : "analysisProcedureCriteria is not set yet, it should not happen because this field is set before the grid refreshes";
        ClientPluginFactory.openImagingMaterialViewer(material, this.getExperimentAsSearchCriteria(), this.analysisProcedureCriteria, false, this.screeningViewContext);
    }

    private WellSearchCriteria.ExperimentSearchCriteria getExperimentAsSearchCriteria() {
        return WellSearchCriteria.ExperimentSearchCriteria.createExperiment(this.experiment, this.restrictGlobalScopeLinkToProject);
    }

    ExperimentAnalysisSummaryGrid(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithIdentifier experiment, boolean restrictGlobalScopeLinkToProject, WellSearchCriteria.AnalysisProcedureCriteria initialAnalysisProcedureOrNull) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, initialAnalysisProcedureOrNull != null, DisplayTypeIDGenerator.EXPERIMENT_FEATURE_VECTOR_SUMMARY_SECTION);
        this.screeningViewContext = viewContext;
        this.experiment = experiment;
        this.restrictGlobalScopeLinkToProject = restrictGlobalScopeLinkToProject;
        this.analysisProcedureCriteria = initialAnalysisProcedureOrNull;
        ICellListenerAndLinkGenerator<MaterialFeatureVectorSummary> linkGenerator = this.createMaterialReplicaSummaryLinkGenerator();
        this.registerListenerAndLinkGenerator("id", linkGenerator);
        String detailsLinkPropertyTypeName = this.screeningViewContext.getPropertyOrNull("material-details-property-type");
        if (detailsLinkPropertyTypeName != null) {
            String detailsLinkPropertyColumnId = ColumnIDUtils.getColumnIdForProperty("MATERIAL_PROP-", detailsLinkPropertyTypeName);
            this.registerListenerAndLinkGenerator(detailsLinkPropertyColumnId, linkGenerator);
        }
        this.setBorders(true);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<MaterialFeatureVectorSummary>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<MaterialFeatureVectorSummary>> callback) {
        this.screeningViewContext.getService().listExperimentFeatureVectorSummary(resultSetConfig, new TechId(this.experiment), this.analysisProcedureCriteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<MaterialFeatureVectorSummary>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.screeningViewContext.getService().prepareExportFeatureVectorSummary(exportCriteria, callback);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        String id = columnID;
        if (columnID.startsWith("RANK")) {
            id = "RANK";
        }
        return String.valueOf("EXPERIMENT_FEATURE_VECTOR_SUMMARY_SECTION".toLowerCase()) + "_" + id.toUpperCase();
    }

    public void dispose() {
        this.asDisposableWithoutToolbar().dispose();
    }

    @Override
    public void analysisProcedureSelected(WellSearchCriteria.AnalysisProcedureCriteria selectedProcedureCriteria) {
        this.analysisProcedureCriteria = selectedProcedureCriteria;
        this.refresh(true);
    }
}

