/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class WellData {
    private final WellLocation wellLocation;
    private final Experiment experiment;
    private WellMetadata wellMetadataOrNull;
    private boolean fullyLoaded = false;
    private Map<String, FeatureValue> featureValuesMap = new LinkedHashMap<String, FeatureValue>();

    public WellData(WellLocation wellLocation, Experiment experiment) {
        this.wellLocation = wellLocation;
        this.experiment = experiment;
    }

    public void addFeatureValue(String featureName, FeatureValue value) {
        this.featureValuesMap.put(featureName, value);
    }

    public void setAllFeatureValues(Map<String, FeatureValue> values) {
        this.resetFeatureValues();
        for (Map.Entry<String, FeatureValue> entry : values.entrySet()) {
            this.addFeatureValue(entry.getKey(), entry.getValue());
        }
        this.fullyLoaded = true;
    }

    public void resetFeatureValues() {
        this.featureValuesMap.clear();
        this.fullyLoaded = false;
    }

    public FeatureValue tryGetFeatureValue(String featureLabel) {
        return this.featureValuesMap.get(featureLabel);
    }

    public Set<String> getFeatureLabels() {
        return this.featureValuesMap.keySet();
    }

    public void setMetadata(WellMetadata well) {
        this.wellMetadataOrNull = well;
    }

    public WellMetadata tryGetMetadata() {
        return this.wellMetadataOrNull;
    }

    public WellLocation getWellLocation() {
        return this.wellLocation;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }
}

