/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngjException;

public class ImageInfo {
    private static final int MAX_COLS_ROWS_VAL = 400000;
    public final int cols;
    public final int rows;
    public final int bitDepth;
    public final int channels;
    public final boolean alpha;
    public final boolean greyscale;
    public final boolean indexed;
    public final boolean packed;
    final int bitspPixel;
    final int bytesPixel;
    final int bytesPerRow;
    public final int samplesPerRow;
    final int samplesPerRowP;

    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha) {
        this(cols, rows, bitdepth, alpha, false, false);
    }

    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha, boolean grayscale, boolean indexed) {
        this.cols = cols;
        this.rows = rows;
        this.alpha = alpha;
        this.indexed = indexed;
        this.greyscale = grayscale;
        if (this.greyscale && indexed) {
            throw new PngjException("palette and greyscale are exclusive");
        }
        this.channels = grayscale || indexed ? (alpha ? 2 : 1) : (alpha ? 4 : 3);
        this.bitDepth = bitdepth;
        this.packed = bitdepth < 8;
        this.bitspPixel = this.channels * this.bitDepth;
        this.bytesPixel = (this.bitspPixel + 7) / 8;
        this.bytesPerRow = (this.bitspPixel * cols + 7) / 8;
        this.samplesPerRow = this.channels * this.cols;
        this.samplesPerRowP = this.packed ? this.bytesPerRow : this.samplesPerRow;
        switch (this.bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                if (this.indexed || this.greyscale) break;
                throw new PngjException("only indexed or grayscale can have bitdepth=" + this.bitDepth);
            }
            case 8: {
                break;
            }
            case 16: {
                if (!this.indexed) break;
                throw new PngjException("indexed can't have bitdepth=" + this.bitDepth);
            }
            default: {
                throw new PngjException("invalid bitdepth=" + this.bitDepth);
            }
        }
        if (cols < 1 || cols > 400000) {
            throw new PngjException("invalid cols=" + cols + " ???");
        }
        if (rows < 1 || rows > 400000) {
            throw new PngjException("invalid rows=" + rows + " ???");
        }
    }

    public String toString() {
        return "ImageInfo [cols=" + this.cols + ", rows=" + this.rows + ", bitDepth=" + this.bitDepth + ", channels=" + this.channels + ", bitspPixel=" + this.bitspPixel + ", bytesPixel=" + this.bytesPixel + ", bytesPerRow=" + this.bytesPerRow + ", samplesPerRow=" + this.samplesPerRow + ", samplesPerRowP=" + this.samplesPerRowP + ", alpha=" + this.alpha + ", greyscale=" + this.greyscale + ", indexed=" + this.indexed + ", packed=" + this.packed + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alpha ? 1231 : 1237);
        result = 31 * result + this.bitDepth;
        result = 31 * result + this.bitspPixel;
        result = 31 * result + this.bytesPerRow;
        result = 31 * result + this.bytesPixel;
        result = 31 * result + this.channels;
        result = 31 * result + this.cols;
        result = 31 * result + (this.greyscale ? 1231 : 1237);
        result = 31 * result + (this.indexed ? 1231 : 1237);
        result = 31 * result + (this.packed ? 1231 : 1237);
        result = 31 * result + this.rows;
        result = 31 * result + this.samplesPerRow;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageInfo other = (ImageInfo)obj;
        if (this.alpha != other.alpha) {
            return false;
        }
        if (this.bitDepth != other.bitDepth) {
            return false;
        }
        if (this.bitspPixel != other.bitspPixel) {
            return false;
        }
        if (this.bytesPerRow != other.bytesPerRow) {
            return false;
        }
        if (this.bytesPixel != other.bytesPixel) {
            return false;
        }
        if (this.channels != other.channels) {
            return false;
        }
        if (this.cols != other.cols) {
            return false;
        }
        if (this.greyscale != other.greyscale) {
            return false;
        }
        if (this.indexed != other.indexed) {
            return false;
        }
        if (this.packed != other.packed) {
            return false;
        }
        if (this.rows != other.rows) {
            return false;
        }
        return this.samplesPerRow == other.samplesPerRow;
    }
}

