/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static final List<Method> getAnnotatedMethodList(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAnnotatedMethodList(clazz, annotationClass, null);
    }

    private static final List<Method> getAnnotatedMethodList(Class<?> clazz, Class<? extends Annotation> annotationClass, List<Method> methods) {
        assert (clazz != null) : "Unspecified class.";
        assert (annotationClass != null) : "Unspecified annotation class.";
        List<Method> list = methods;
        if (list == null) {
            list = new ArrayList<Method>();
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(annotationClass) != null) {
                list.add(method);
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            return AnnotationUtils.getAnnotatedMethodList(superclass, annotationClass, list);
        }
        return list;
    }

    public static final List<Field> getAnnotatedFieldList(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAnnotatedFieldList(clazz, annotationClass, null);
    }

    private static final List<Field> getAnnotatedFieldList(Class<?> clazz, Class<? extends Annotation> annotationClass, List<Field> fields) {
        assert (clazz != null) : "Unspecified class.";
        assert (annotationClass != null) : "Unspecified annotation class.";
        List<Field> list = fields;
        if (list == null) {
            list = new ArrayList<Field>();
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getAnnotation(annotationClass) != null) {
                list.add(field);
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            return AnnotationUtils.getAnnotatedFieldList(superclass, annotationClass, list);
        }
        return list;
    }

    public static final <A extends Annotation> A tryGetAnnotation(Annotation[] annotations, Class<A> annotationType) {
        assert (annotations != null) : "Unspecified annotations";
        assert (annotationType != null) : "Unspecified annotation type";
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(annotationType)) {
                return (A)((Annotation)annotationType.cast(annotation));
            }
            ++n2;
        }
        return null;
    }

    public static final <A extends Annotation> List<Parameter<A>> getAnnotatedParameters(Method method, Class<A> annotationType) {
        assert (method != null) : "Unspecified method";
        assert (annotationType != null) : "Unspecified annotation type";
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] types = method.getParameterTypes();
        ArrayList<Parameter<A>> list = new ArrayList<Parameter<A>>();
        int i = 0;
        while (i < types.length) {
            Class<?> type = types[i];
            A annotationOrNull = AnnotationUtils.tryGetAnnotation(annotations[i], annotationType);
            if (annotationOrNull != null) {
                list.add(new Parameter<A>(i, type, annotationOrNull));
            }
            ++i;
        }
        return list;
    }

    public static final class Parameter<A extends Annotation> {
        private final int index;
        private final Class<?> type;
        private final A annotation;

        Parameter(int index, Class<?> type, A annotation) {
            this.index = index;
            this.type = type;
            this.annotation = annotation;
        }

        public final int getIndex() {
            return this.index;
        }

        public final Class<?> getType() {
            return this.type;
        }

        public final A getAnnotation() {
            return this.annotation;
        }
    }
}

