/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v1.impl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IProjectImmutable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;

public class ProjectImmutable
implements IProjectImmutable {
    private final Project project;
    private final boolean isExistingProject;

    public ProjectImmutable(Project project) {
        this(project, true);
    }

    public ProjectImmutable(Project project, boolean isExistingProject) {
        this.project = project;
        this.isExistingProject = isExistingProject;
    }

    public Long getId() {
        return this.project.getId();
    }

    @Override
    public String getPermId() {
        return this.project.getPermId();
    }

    @Override
    public String getSpaceCode() {
        return this.project.getSpace().getCode();
    }

    @Override
    public String getCode() {
        return this.project.getCode();
    }

    @Override
    public String getProjectIdentifier() {
        return this.project.getIdentifier();
    }

    @Override
    public boolean isExistingProject() {
        return this.isExistingProject;
    }

    protected void checkExists() {
        if (!this.isExistingProject()) {
            throw new UserFailureException("Project does not exist.");
        }
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public String getDescription() {
        return this.project.getDescription();
    }

    public int hashCode() {
        return this.getProjectIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        ProjectImmutable other = (ProjectImmutable)obj;
        return !(this.getProjectIdentifier() == null ? other.getProjectIdentifier() != null : !this.getProjectIdentifier().equals(other.getProjectIdentifier()));
    }
}

