/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.BorderLayoutDataFactory;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BorderLayoutEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.LayoutEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;

public class BorderLayoutHelper {
    private static final String LEFT_PANEL_PREFIX = "left_panel_";
    private static final int INITIAL_LEFT_PANEL_SIZE = 350;
    private IViewContext<?> viewContext;
    private BorderLayout layout;
    private String displayIdSuffix;

    public BorderLayoutHelper(IViewContext<?> viewContext, BorderLayout layout, String displayIdSuffix) {
        this.viewContext = viewContext;
        this.layout = layout;
        this.displayIdSuffix = displayIdSuffix;
    }

    public BorderLayoutData createLeftBorderLayoutData() {
        String panelId = this.getLeftPanelId();
        float initialSize = this.getLeftPanelInitialSize();
        this.viewContext.log(String.valueOf(panelId) + " initial size: " + initialSize);
        BorderLayoutData layoutData = BorderLayoutDataFactory.create(Style.LayoutRegion.WEST, initialSize);
        layoutData.setCollapsible(true);
        return layoutData;
    }

    public static BorderLayoutData createRightBorderLayoutData() {
        return BorderLayoutDataFactory.create(Style.LayoutRegion.CENTER);
    }

    public void configureLeftPanel(Component panel) {
        if (this.isLeftPanelInitiallyCollapsed()) {
            this.viewContext.log(String.valueOf(this.displayIdSuffix) + " Initially Collapsed");
            panel.setVisible(true);
            this.getLayout().collapse(Style.LayoutRegion.WEST);
        }
        this.addLeftPanelCollapseExpandListeners(panel);
    }

    private void addLeftPanelCollapseExpandListeners(final Component panel) {
        final String panelId = this.getLeftPanelId();
        this.getLayout().addListener(Events.Collapse, (Listener)new Listener<BorderLayoutEvent>(){

            public void handleEvent(BorderLayoutEvent be) {
                BorderLayoutHelper.this.viewContext.log(String.valueOf(panelId) + " Collapsed");
                BorderLayoutHelper.this.viewContext.getDisplaySettingsManager().updatePanelCollapsedSetting(panelId, Boolean.TRUE);
            }
        });
        this.getLayout().addListener(Events.Expand, (Listener)new Listener<BorderLayoutEvent>(){

            public void handleEvent(BorderLayoutEvent be) {
                BorderLayoutHelper.this.viewContext.log(String.valueOf(panelId) + " Expand");
                BorderLayoutHelper.this.viewContext.getDisplaySettingsManager().updatePanelCollapsedSetting(panelId, Boolean.FALSE);
            }
        });
        this.getLayout().addListener(Events.AfterLayout, (Listener)new Listener<LayoutEvent>(){

            public void handleEvent(LayoutEvent le) {
                Integer size = panel.getOffsetWidth();
                BorderLayoutHelper.this.viewContext.log(String.valueOf(panelId) + " AfterLayout, size: " + size);
                if (size > 0) {
                    BorderLayoutHelper.this.viewContext.getDisplaySettingsManager().updatePanelSizeSetting(panelId, size);
                }
            }
        });
    }

    private String getLeftPanelId() {
        return LEFT_PANEL_PREFIX + this.displayIdSuffix;
    }

    private boolean isLeftPanelInitiallyCollapsed() {
        Boolean collapsedOrNull = this.viewContext.getDisplaySettingsManager().tryGetPanelCollapsedSetting(this.getLeftPanelId());
        return collapsedOrNull == null ? false : collapsedOrNull;
    }

    private int getLeftPanelInitialSize() {
        Integer sizeOrNull = this.viewContext.getDisplaySettingsManager().tryGetPanelSizeSetting(this.getLeftPanelId());
        return sizeOrNull == null ? 350 : sizeOrNull;
    }

    private BorderLayout getLayout() {
        return this.layout;
    }
}

