/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.authentication.DefaultSessionManager;
import ch.systemsx.cisd.authentication.DummyAuthenticationService;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.common.servlet.RequestContextProviderAdapter;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractCommonServer;
import ch.systemsx.cisd.openbis.generic.server.EntityOperationsInProgress;
import ch.systemsx.cisd.openbis.generic.server.IDataStoreServiceRegistrator;
import ch.systemsx.cisd.openbis.generic.server.IETLEntityOperationChecker;
import ch.systemsx.cisd.openbis.generic.server.MaterialGroupingDAG;
import ch.systemsx.cisd.openbis.generic.server.MaterialHelper;
import ch.systemsx.cisd.openbis.generic.server.MetaprojectAssignmentsHelper;
import ch.systemsx.cisd.openbis.generic.server.NewExternalDataDAG;
import ch.systemsx.cisd.openbis.generic.server.SampleGroupingDAG;
import ch.systemsx.cisd.openbis.generic.server.SearchHelper;
import ch.systemsx.cisd.openbis.generic.server.ServiceForDataStoreServerLogger;
import ch.systemsx.cisd.openbis.generic.server.SessionFactory;
import ch.systemsx.cisd.openbis.generic.server.TrustedCrossOriginDomainsProvider;
import ch.systemsx.cisd.openbis.generic.server.api.v1.SearchCriteriaToDetailedSearchCriteriaTranslator;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationServiceUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AtomicOperationsPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExistingSampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExistingSpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ListSampleCriteriaPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ListSamplesByPropertyPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewSamplePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewSamplesWithTypePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleValidator;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.DataSetBatchUpdate;
import ch.systemsx.cisd.openbis.generic.server.batch.DataSetCheckBeforeBatchUpdate;
import ch.systemsx.cisd.openbis.generic.server.batch.SampleBatchRegistration;
import ch.systemsx.cisd.openbis.generic.server.batch.SampleCheckBeforeUpdate;
import ch.systemsx.cisd.openbis.generic.server.batch.SampleUpdate;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationServerManagerLocal;
import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityCodeGenerator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityObjectIdHelper;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IAuthorizationGroupBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMetaprojectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IProjectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IRoleAssignmentTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISpaceBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.experimentlister.ExperimentLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataSetTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDataSourceManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMetaprojectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.LogMessagePrefixGenerator;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchableEntityKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.MetaprojectIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityOperationsState;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ArchiverDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentWithContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMetaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSpace;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyTypeWithVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SourceType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationResult;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetShareId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServerInfo;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityCollectionForCreationOrUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityOperationsLogEntryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationHolderDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ListSamplesByPropertyCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewRoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpaceRoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.AttachmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.AuthorizationGroupTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExternalDataManagementSystemTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MetaprojectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ProjectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.RoleAssignmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SimpleDataSetHelper;
import ch.systemsx.cisd.openbis.generic.shared.translator.SpaceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTermTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;

public class ServiceForDataStoreServer
extends AbstractCommonServer<IServiceForDataStoreServer>
implements IServiceForDataStoreServer {
    @Private
    static final EnumSet<DataSetFetchOption> DATASET_FETCH_OPTIONS_FILE_DATASETS = EnumSet.of(DataSetFetchOption.BASIC, DataSetFetchOption.EXPERIMENT, DataSetFetchOption.SAMPLE);
    private final IDAOFactory daoFactory;
    private final IDataStoreServiceFactory dssFactory;
    private final TrustedCrossOriginDomainsProvider trustedOriginDomainProvider;
    private final IETLEntityOperationChecker entityOperationChecker;
    private final ISessionManager<Session> sessionManagerForEntityOperation;
    private final IDataStoreServiceRegistrator dataStoreServiceRegistrator;
    private final IDataStoreDataSourceManager dataSourceManager;
    private IServiceConversationClientManagerLocal conversationClient;
    private IServiceConversationServerManagerLocal conversationServer;
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public ServiceForDataStoreServer(IAuthenticationService authenticationService, IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, ICommonBusinessObjectFactory boFactory, IDataStoreServiceFactory dssFactory, TrustedCrossOriginDomainsProvider trustedOriginDomainProvider, IETLEntityOperationChecker entityOperationChecker, IDataStoreServiceRegistrator dataStoreServiceRegistrator, IDataStoreDataSourceManager dataSourceManager, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this(authenticationService, sessionManager, daoFactory, null, boFactory, dssFactory, trustedOriginDomainProvider, entityOperationChecker, dataStoreServiceRegistrator, dataSourceManager, new DefaultSessionManager<Session>(new SessionFactory(), new LogMessagePrefixGenerator(), new DummyAuthenticationService(), new RequestContextProviderAdapter(new IRequestContextProvider(){

            @Override
            public HttpServletRequest getHttpServletRequest() {
                return null;
            }
        }), 30), managedPropertyEvaluatorFactory);
    }

    ServiceForDataStoreServer(IAuthenticationService authenticationService, IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ICommonBusinessObjectFactory boFactory, IDataStoreServiceFactory dssFactory, TrustedCrossOriginDomainsProvider trustedOriginDomainProvider, IETLEntityOperationChecker entityOperationChecker, IDataStoreServiceRegistrator dataStoreServiceRegistrator, IDataStoreDataSourceManager dataSourceManager, ISessionManager<Session> sessionManagerForEntityOperation, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(authenticationService, sessionManager, daoFactory, propertiesBatchManager, boFactory);
        this.daoFactory = daoFactory;
        this.dssFactory = dssFactory;
        this.trustedOriginDomainProvider = trustedOriginDomainProvider;
        this.entityOperationChecker = entityOperationChecker;
        this.dataStoreServiceRegistrator = dataStoreServiceRegistrator;
        this.dataSourceManager = dataSourceManager;
        this.sessionManagerForEntityOperation = sessionManagerForEntityOperation;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    @Override
    public IServiceForDataStoreServer createLogger(IInvocationLoggerContext context) {
        return new ServiceForDataStoreServerLogger(this.getSessionManager(), context);
    }

    @Override
    public int getVersion() {
        return 35;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public DatabaseInstance getHomeDatabaseInstance(String sessionToken) {
        return DatabaseInstanceTranslator.translate(this.getHomeDatabaseInstance());
    }

    private DatabaseInstancePE getHomeDatabaseInstance() {
        return this.daoFactory.getHomeDatabaseInstance();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void registerDataStoreServer(String sessionToken, DataStoreServerInfo info) {
        Session session = this.getSession(sessionToken);
        String dssSessionToken = info.getSessionToken();
        String dssURL = this.checkVersion(info, session, dssSessionToken);
        IDataStoreDAO dataStoreDAO = this.daoFactory.getDataStoreDAO();
        DataStorePE dataStore = dataStoreDAO.tryToFindDataStoreByCode(info.getDataStoreCode());
        if (dataStore == null) {
            dataStore = new DataStorePE();
            dataStore.setDatabaseInstance(this.getHomeDatabaseInstance());
        }
        dataStore.setCode(info.getDataStoreCode());
        dataStore.setDownloadUrl(info.getDownloadUrl());
        dataStore.setRemoteUrl(dssURL);
        dataStore.setSessionToken(dssSessionToken);
        dataStore.setArchiverConfigured(info.isArchiverConfigured());
        dataStore.setServices(new HashSet<DataStoreServicePE>());
        dataStoreDAO.createOrUpdateDataStore(dataStore);
        this.dataStoreServiceRegistrator.setServiceDescriptions(dataStore, info.getServicesDescriptions());
        this.dataSourceManager.handle(info.getDataStoreCode(), info.getDataSourceDefinitions());
        this.conversationClient.setDataStoreInformation(dssURL, info.getTimeoutInMinutes());
        this.conversationServer.setDataStoreInformation(info.getDataStoreCode(), dssURL, info.getTimeoutInMinutes());
    }

    private String checkVersion(DataStoreServerInfo info, Session session, String dssSessionToken) {
        int port = info.getPort();
        String remoteHost = String.valueOf(session.getRemoteHost()) + ":" + port;
        String dssURL = String.valueOf(info.isUseSSL() ? "https://" : "http://") + remoteHost;
        this.checkVersion(dssSessionToken, dssURL);
        return dssURL;
    }

    private void checkVersion(String dssSessionToken, String dssURL) {
        int dssVersion;
        IDataStoreService service = this.dssFactory.create(dssURL);
        if (this.operationLog.isInfoEnabled()) {
            this.operationLog.info((Object)("Obtain version of Data Store Server at " + dssURL));
        }
        if (9 != (dssVersion = service.getVersion(dssSessionToken))) {
            String msg = "Data Store Server version is " + dssVersion + " instead of " + 9;
            this.notificationLog.error((Object)msg);
            throw new ConfigurationFailureException(msg);
        }
        if (this.operationLog.isInfoEnabled()) {
            this.operationLog.info((Object)("Data Store Server (version " + dssVersion + ") registered for " + dssURL));
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public String createPermId(String sessionToken) throws UserFailureException {
        this.checkSession(sessionToken);
        return this.daoFactory.getPermIdDAO().createPermId();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<String> createPermIds(String sessionToken, int n) throws UserFailureException {
        this.checkSession(sessionToken);
        return this.daoFactory.getPermIdDAO().createPermIds(n);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public long drawANewUniqueID(String sessionToken) throws UserFailureException {
        this.checkSession(sessionToken);
        return this.daoFactory.getCodeSequenceDAO().getNextCodeSequenceId();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Experiment> listExperiments(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ExperimentIdentifier> experimentIdentifiers, ExperimentFetchOptions experimentFetchOptions) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("SessionToken was null");
        }
        if (experimentIdentifiers == null) {
            throw new IllegalArgumentException("ExperimentIdentifiers were null");
        }
        if (experimentFetchOptions == null) {
            throw new IllegalArgumentException("ExperimentFetchOptions were null");
        }
        this.checkSession(sessionToken);
        if (experimentFetchOptions.isSubsetOf(new ExperimentFetchOption[]{ExperimentFetchOption.BASIC, ExperimentFetchOption.METAPROJECTS})) {
            ExperimentLister lister = new ExperimentLister(this.getDAOFactory(), this.getSession(sessionToken).getBaseIndexURL());
            return lister.listExperiments(experimentIdentifiers, experimentFetchOptions);
        }
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        for (ExperimentIdentifier experimentIdentifier : experimentIdentifiers) {
            Experiment experiment = this.tryGetExperiment(sessionToken, experimentIdentifier);
            if (experiment == null) continue;
            experiment.setFetchOptions(new ExperimentFetchOptions(ExperimentFetchOption.values()));
            experiments.add(experiment);
        }
        return experiments;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Experiment> listExperimentsForProjects(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ProjectIdentifier> projectIdentifiers, ExperimentFetchOptions experimentFetchOptions) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("SessionToken was null");
        }
        if (projectIdentifiers == null) {
            throw new IllegalArgumentException("ProjectIdentifiers were null");
        }
        if (experimentFetchOptions == null) {
            throw new IllegalArgumentException("ExperimentFetchOptions were null");
        }
        this.checkSession(sessionToken);
        if (experimentFetchOptions.isSubsetOf(new ExperimentFetchOption[]{ExperimentFetchOption.BASIC, ExperimentFetchOption.METAPROJECTS})) {
            ExperimentLister lister = new ExperimentLister(this.daoFactory, this.getSession(sessionToken).getBaseIndexURL());
            return lister.listExperimentsForProjects(projectIdentifiers, experimentFetchOptions);
        }
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        for (ProjectIdentifier projectIdentifier : projectIdentifiers) {
            List<Experiment> projectExperiments = this.listExperiments(sessionToken, projectIdentifier);
            if (projectExperiments == null) continue;
            for (Experiment projectExperiment : projectExperiments) {
                if (projectExperiment == null) continue;
                projectExperiment.setFetchOptions(new ExperimentFetchOptions(ExperimentFetchOption.values()));
                experiments.add(projectExperiment);
            }
        }
        return experiments;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public Experiment tryGetExperiment(String sessionToken, @AuthorizationGuard(guardClass=ExistingSpaceIdentifierPredicate.class) ExperimentIdentifier experimentIdentifier) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (experimentIdentifier != null) : "Unspecified experiment identifier.";
        Session session = this.getSession(sessionToken);
        ExperimentPE experiment = this.tryLoadExperimentByIdentifier(session, experimentIdentifier);
        if (experiment == null) {
            return null;
        }
        this.enrichWithProperties(experiment);
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), experiment);
        return ExperimentTranslator.translate(experiment, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields.PROPERTIES);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @ReturnValueFilter(validatorClass=SampleValidator.class)
    public List<Sample> listSamples(String sessionToken, @AuthorizationGuard(guardClass=ListSampleCriteriaPredicate.class) ListSampleCriteria criteria) {
        Session session = this.getSession(sessionToken);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(session);
        return sampleLister.list(new ListOrSearchSampleCriteria(criteria));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Sample tryGetSampleWithExperiment(String sessionToken, @AuthorizationGuard(guardClass=ExistingSampleOwnerIdentifierPredicate.class) SampleIdentifier sampleIdentifier) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (sampleIdentifier != null) : "Unspecified sample identifier.";
        Session session = this.getSession(sessionToken);
        SamplePE sample = this.tryLoadSample(session, sampleIdentifier);
        Collection<MetaprojectPE> metaprojects = Collections.emptySet();
        if (sample != null) {
            HibernateUtils.initialize(sample.getProperties());
            this.enrichWithProperties(sample.getExperiment());
            metaprojects = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), sample);
        }
        return SampleTranslator.translate(sample, session.getBaseIndexURL(), true, true, MetaprojectTranslator.translate(metaprojects), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public SampleIdentifier tryGetSampleIdentifier(String sessionToken, String samplePermID) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (samplePermID != null) : "Unspecified sample perm ID.";
        SamplePE sample = this.daoFactory.getSampleDAO().tryToFindByPermID(samplePermID);
        return sample == null ? null : sample.getSampleIdentifier();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Map<String, SampleIdentifier> listSamplesByPermId(String sessionToken, List<String> samplePermIds) {
        List<SamplePE> samples = this.daoFactory.getSampleDAO().listByPermID(new HashSet<String>(samplePermIds));
        HashMap<String, SampleIdentifier> map = new HashMap<String, SampleIdentifier>();
        for (SamplePE sample : samples) {
            map.put(sample.getPermId(), sample.getSampleIdentifier());
        }
        return map;
    }

    private ExperimentPE tryLoadExperimentByIdentifier(Session session, ExperimentIdentifier experimentIdentifier) {
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        return experimentBO.tryFindByExperimentIdentifier(experimentIdentifier);
    }

    private SamplePE tryLoadSample(Session session, SampleIdentifier sampleIdentifier) {
        SamplePE result = null;
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        try {
            sampleBO.tryToLoadBySampleIdentifier(sampleIdentifier);
            result = sampleBO.tryToGetSample();
        }
        catch (UserFailureException userFailureException) {}
        return result;
    }

    private void enrichWithProperties(ExperimentPE experiment) {
        if (experiment == null) {
            return;
        }
        HibernateUtils.initialize(experiment.getProperties());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public ExperimentType getExperimentType(String sessionToken, String experimentTypeCode) throws UserFailureException {
        this.checkSession(sessionToken);
        IEntityTypeDAO entityTypeDAO = this.getDAOFactory().getEntityTypeDAO(ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.EXPERIMENT);
        EntityTypePE entityType = entityTypeDAO.tryToFindEntityTypeByCode(experimentTypeCode);
        if (entityType == null) {
            throw new UserFailureException("No Experiment type found with code '" + experimentTypeCode + "'.");
        }
        assert (entityType instanceof ExperimentTypePE) : "Not an ExperimentTypePE: " + entityType;
        ExperimentTypePE experimentType = (ExperimentTypePE)entityType;
        HibernateUtils.initialize(experimentType.getExperimentTypePropertyTypes());
        return ExperimentTypeTranslator.translate(experimentType, null);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public SampleType getSampleType(String sessionToken, String sampleTypeCode) throws UserFailureException {
        this.checkSession(sessionToken);
        ISampleTypeDAO sampleTypeDAO = this.getDAOFactory().getSampleTypeDAO();
        SampleTypePE sampleType = sampleTypeDAO.tryFindSampleTypeByCode(sampleTypeCode);
        if (sampleType == null) {
            throw new UserFailureException("No sample type found with code '" + sampleTypeCode + "'.");
        }
        HibernateUtils.initialize(sampleType.getSampleTypePropertyTypes());
        return SampleTypeTranslator.translate(sampleType, null);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public DataSetTypeWithVocabularyTerms getDataSetType(String sessionToken, String dataSetTypeCode) throws UserFailureException {
        this.checkSession(sessionToken);
        IDataSetTypeDAO dataSetTypeDAO = this.getDAOFactory().getDataSetTypeDAO();
        DataSetTypePE dataSetType = dataSetTypeDAO.tryToFindDataSetTypeByCode(dataSetTypeCode);
        if (dataSetType == null) {
            throw new UserFailureException("No data set type found with code '" + dataSetTypeCode + "'.");
        }
        Set<DataSetTypePropertyTypePE> dataSetTypePropertyTypes = dataSetType.getDataSetTypePropertyTypes();
        HibernateUtils.initialize(dataSetTypePropertyTypes);
        DataSetTypeWithVocabularyTerms result = new DataSetTypeWithVocabularyTerms();
        result.setDataSetType(DataSetTypeTranslator.translate(dataSetType, null));
        for (DataSetTypePropertyTypePE dataSetTypePropertyTypePE : dataSetTypePropertyTypes) {
            PropertyTypePE propertyTypePE = dataSetTypePropertyTypePE.getPropertyType();
            PropertyTypeWithVocabulary propertyType = new PropertyTypeWithVocabulary();
            propertyType.setCode(propertyTypePE.getCode());
            VocabularyPE vocabulary = propertyTypePE.getVocabulary();
            if (vocabulary != null) {
                Set<VocabularyTermPE> terms = vocabulary.getTerms();
                HibernateUtils.initialize(terms);
                propertyType.setTerms(VocabularyTermTranslator.translateTerms(terms));
            }
            result.addPropertyType(propertyType);
        }
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AbstractExternalData> listDataSetsByExperimentID(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentID) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.createDatasetLister(session);
        List<AbstractExternalData> datasets = datasetLister.listByExperimentTechId(experimentID, true);
        Collections.sort(datasets);
        return datasets;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AbstractExternalData> listDataSetsBySampleID(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId, boolean showOnlyDirectlyConnected) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.createDatasetLister(session);
        List<AbstractExternalData> datasets = datasetLister.listBySampleTechId(sampleId, showOnlyDirectlyConnected);
        Collections.sort(datasets);
        return datasets;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AbstractExternalData> listDataSetsByCode(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.createDatasetLister(session);
        return datasetLister.listByDatasetCode(dataSetCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @ReturnValueFilter(validatorClass=ProjectValidator.class)
    public List<Project> listProjects(String sessionToken) {
        this.checkSession(sessionToken);
        List<ProjectPE> projects = this.getDAOFactory().getProjectDAO().listProjects();
        Collections.sort(projects);
        return ProjectTranslator.translate(projects);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Experiment> listExperiments(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier projectIdentifier) {
        Session session = this.getSession(sessionToken);
        IExperimentTable experimentTable = this.businessObjectFactory.createExperimentTable(session);
        experimentTable.load("(all)", projectIdentifier);
        List<ExperimentPE> experiments = experimentTable.getExperiments();
        Collection<MetaprojectAssignmentPE> assignmentPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectAssignmentsForEntities(session.tryGetPerson(), experiments, ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.EXPERIMENT);
        Map<Long, Set<Metaproject>> assignments = MetaprojectTranslator.translateMetaprojectAssignments(assignmentPEs);
        Collections.sort(experiments);
        return ExperimentTranslator.translate(experiments, session.getBaseIndexURL(), assignments, this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public IEntityProperty[] tryGetPropertiesOfTopSample(String sessionToken, @AuthorizationGuard(guardClass=SampleOwnerIdentifierPredicate.class) SampleIdentifier sampleIdentifier) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (sampleIdentifier != null) : "Unspecified sample identifier.";
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadBySampleIdentifier(sampleIdentifier);
        SamplePE sample = sampleBO.getSample();
        if (sample == null) {
            return null;
        }
        SamplePE top = sample.getTop();
        Set<SamplePropertyPE> properties = top.getProperties();
        HibernateUtils.initialize(properties);
        return EntityPropertyTranslator.translate(properties.toArray(new SamplePropertyPE[0]), new HashMap<PropertyTypePE, PropertyType>(), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public IEntityProperty[] tryGetPropertiesOfSample(String sessionToken, @AuthorizationGuard(guardClass=SampleOwnerIdentifierPredicate.class) SampleIdentifier sampleIdentifier) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (sampleIdentifier != null) : "Unspecified sample identifier.";
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadBySampleIdentifier(sampleIdentifier);
        SamplePE sample = sampleBO.getSample();
        if (sample == null) {
            return null;
        }
        Set<SamplePropertyPE> properties = sample.getProperties();
        HibernateUtils.initialize(properties);
        return EntityPropertyTranslator.translate(properties.toArray(new SamplePropertyPE[0]), new HashMap<PropertyTypePE, PropertyType>(), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void registerEntities(String sessionToken, EntityCollectionForCreationOrUpdate collection) throws UserFailureException {
        this.checkSession(sessionToken);
        List<NewExperiment> experiments = collection.getNewExperiments();
        for (NewExperiment experiment : experiments) {
            this.registerExperiment(sessionToken, experiment);
        }
        List<NewExternalData> dataSets = collection.getNewDataSets();
        for (NewExternalData dataSet : dataSets) {
            ExperimentIdentifier experimentIdentifier = dataSet.getExperimentIdentifierOrNull();
            if (experimentIdentifier == null) continue;
            this.registerDataSet(sessionToken, experimentIdentifier, dataSet);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public long registerExperiment(String sessionToken, @AuthorizationGuard(guardClass=NewExperimentPredicate.class) NewExperiment experiment) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (experiment != null) : "Unspecified new example.";
        Session session = this.getSession(sessionToken);
        return this.registerExperiment(session, experiment);
    }

    private long registerExperiment(Session session, NewExperiment experiment) {
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.define(experiment);
        experimentBO.save();
        return experimentBO.getExperiment().getId();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void registerSamples(String sessionToken, @AuthorizationGuard(guardClass=NewSamplesWithTypePredicate.class) List<NewSamplesWithTypes> newSamplesWithType, String userIDOrNull) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        PersonPE registratorOrNull = userIDOrNull != null ? this.getOrCreatePerson(sessionToken, userIDOrNull) : null;
        for (NewSamplesWithTypes samples : newSamplesWithType) {
            this.registerSamples(session, samples, registratorOrNull);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public long registerSample(String sessionToken, @AuthorizationGuard(guardClass=NewSamplePredicate.class) NewSample newSample, String userIDOrNull) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (newSample != null) : "Unspecified new sample.";
        Session session = this.getSession(sessionToken);
        SamplePE samplePE = this.registerSampleInternal(session, newSample, userIDOrNull);
        return samplePE.getId();
    }

    private PersonPE getOrCreatePerson(String sessionToken, String userID) {
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userID);
        if (person != null) {
            return person;
        }
        List<PersonPE> persons = this.registerPersons(sessionToken, Collections.singletonList(userID));
        return persons.get(0);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void updateSample(String sessionToken, @AuthorizationGuard(guardClass=SampleUpdatesPredicate.class) SampleUpdatesDTO updates) {
        Session session = this.getSession(sessionToken);
        this.updateSampleInternal(updates, session);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void registerDataSet(String sessionToken, @AuthorizationGuard(guardClass=SampleOwnerIdentifierPredicate.class) SampleIdentifier sampleIdentifier, NewExternalData externalData) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (sampleIdentifier != null) : "Unspecified sample identifier.";
        Session session = this.getSession(sessionToken);
        this.registerDataSetInternal(session, sampleIdentifier, externalData);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void registerDataSet(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ExperimentIdentifier experimentIdentifier, NewExternalData externalData) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (experimentIdentifier != null) : "Unspecified experiment identifier.";
        Session session = this.getSession(sessionToken);
        this.registerDataSetInternal(session, experimentIdentifier, externalData);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void addPropertiesToDataSet(String sessionToken, List<NewProperty> properties, String dataSetCode, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier identifier) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        IDataBO dataBO = this.businessObjectFactory.createDataBO(session);
        dataBO.addPropertiesToDataSet(dataSetCode, properties);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void updateShareIdAndSize(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String dataSetCode, String shareId, long size) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IDataDAO dataSetDAO = this.getDAOFactory().getDataDAO();
        DataPE dataSet = dataSetDAO.tryToFindFullDataSetByCode(dataSetCode, false, false);
        if (dataSet == null) {
            throw new UserFailureException("Unknown data set: " + dataSetCode);
        }
        ExternalDataPE externalData = dataSet.tryAsExternalData();
        if (externalData == null) {
            throw new UserFailureException("Can't update share id and size of a virtual data set: " + dataSetCode);
        }
        long positiveSize = Math.max(1L, size);
        externalData.setShareId(shareId);
        externalData.setSize(positiveSize);
        dataSetDAO.updateDataSet(dataSet, session.tryGetPerson());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void updateDataSetStatuses(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes, DataSetArchivingStatus newStatus, boolean presentInArchive) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        IDataBO dataBO = this.businessObjectFactory.createDataBO(session);
        dataBO.updateStatuses(dataSetCodes, newStatus, presentInArchive);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public boolean compareAndSetDataSetStatus(String sessionToken, String dataSetCode, DataSetArchivingStatus oldStatus, DataSetArchivingStatus newStatus, boolean newPresentInArchive) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        IDataBO dataBO = this.businessObjectFactory.createDataBO(session);
        dataBO.loadByCode(dataSetCode);
        return dataBO.compareAndSetDataSetStatus(oldStatus, newStatus, newPresentInArchive);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public int archiveDatasets(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes, boolean removeFromDataStore) {
        return super.archiveDatasets(sessionToken, datasetCodes, removeFromDataStore);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public int unarchiveDatasets(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes) {
        return super.unarchiveDatasets(sessionToken, datasetCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public IDatasetLocationNode tryGetDataSetLocation(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String dataSetCode) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (dataSetCode != null) : "Unspecified data set code.";
        Session session = this.getSession(sessionToken);
        IDatasetLister lister = this.businessObjectFactory.createDatasetLister(session);
        return lister.listLocationsByDatasetCode(dataSetCode);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public AbstractExternalData tryGetLocalDataSet(String sessionToken, String dataSetCode, String dataStore) throws UserFailureException {
        AbstractExternalData dataSet = this.tryGetDataSet(sessionToken, dataSetCode);
        if (dataSet != null && dataSet.getDataStore().getCode().equals(dataStore)) {
            return dataSet;
        }
        return null;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public AbstractExternalData tryGetDataSet(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String dataSetCode) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (dataSetCode != null) : "Unspecified data set code.";
        Session session = this.getSession(sessionToken);
        IDataBO dataBO = this.businessObjectFactory.createDataBO(session);
        dataBO.loadByCode(dataSetCode);
        dataBO.enrichWithParentsAndExperiment();
        dataBO.enrichWithChildren();
        dataBO.enrichWithProperties();
        dataBO.enrichWithContainedDataSets();
        DataPE dataPE = dataBO.tryGetData();
        if (dataPE == null) {
            return null;
        }
        Collection<MetaprojectPE> metaprojects = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), dataPE);
        return DataSetTranslator.translate(dataPE, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojects), this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public AbstractExternalData tryGetThinDataSet(String sessionToken, String dataSetCode) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (dataSetCode != null) : "Unspecified data set code.";
        Session session = this.getSession(sessionToken);
        IDataBO dataBO = this.businessObjectFactory.createDataBO(session);
        dataBO.loadByCode(dataSetCode);
        DataPE dataPE = dataBO.tryGetData();
        if (dataPE == null) {
            return null;
        }
        return DataSetTranslator.translate(dataPE, session.getBaseIndexURL(), Collections.<Metaproject>emptyList(), this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void checkInstanceAdminAuthorization(String sessionToken) throws UserFailureException {
        this.checkSession(sessionToken);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    public void checkSpacePowerUserAuthorization(String sessionToken) throws UserFailureException {
        this.checkSession(sessionToken);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void checkDataSetAccess(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String dataSetCode) throws UserFailureException {
        this.checkSession(sessionToken);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public void checkDataSetCollectionAccess(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes) {
        this.checkSession(sessionToken);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void checkSpaceAccess(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier spaceId) {
        this.checkSession(sessionToken);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Sample> listSamplesByCriteria(String sessionToken, @AuthorizationGuard(guardClass=ListSamplesByPropertyPredicate.class) ListSamplesByPropertyCriteria criteria) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (criteria != null) : "Unspecified criteria.";
        Session session = this.getSession(sessionToken);
        ISampleTable sampleTable = this.businessObjectFactory.createSampleTable(session);
        sampleTable.loadSamplesByCriteria(criteria);
        List<SamplePE> samples = sampleTable.getSamples();
        Collection<MetaprojectAssignmentPE> assignmentPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectAssignmentsForEntities(session.tryGetPerson(), samples, ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.SAMPLE);
        Map<Long, Set<Metaproject>> assignments = MetaprojectTranslator.translateMetaprojectAssignments(assignmentPEs);
        return SampleTranslator.translate(samples, "", assignments, this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<DataSetShareId> listShareIds(String sessionToken, String dataStoreCode) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.businessObjectFactory.createDatasetLister(session);
        DataStorePE dataStore = this.loadDataStore(session, dataStoreCode);
        return datasetLister.listAllDataSetShareIdsByDataStore(dataStore.getId());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<SimpleDataSetInformationDTO> listPhysicalDataSets(String sessionToken, String dataStoreCode) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        DataStorePE dataStore = this.loadDataStore(session, dataStoreCode);
        IDatasetLister datasetLister = this.businessObjectFactory.createDatasetLister(session);
        List<AbstractExternalData> dataSets = datasetLister.listByDataStore(dataStore.getId(), DATASET_FETCH_OPTIONS_FILE_DATASETS);
        return SimpleDataSetHelper.filterAndTranslate(dataSets);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<SimpleDataSetInformationDTO> listOldestPhysicalDataSets(String sessionToken, String dataStoreCode, int limit) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        DataStorePE dataStore = this.loadDataStore(session, dataStoreCode);
        IDatasetLister datasetLister = this.businessObjectFactory.createDatasetLister(session);
        List<AbstractExternalData> dataSets = datasetLister.listByDataStore(dataStore.getId(), limit, DATASET_FETCH_OPTIONS_FILE_DATASETS);
        return SimpleDataSetHelper.filterAndTranslate(dataSets);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<SimpleDataSetInformationDTO> listOldestPhysicalDataSets(String sessionToken, String dataStoreCode, Date youngerThan, int limit) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        DataStorePE dataStore = this.loadDataStore(session, dataStoreCode);
        IDatasetLister datasetLister = this.businessObjectFactory.createDatasetLister(session);
        List<AbstractExternalData> dataSets = datasetLister.listByDataStore(dataStore.getId(), youngerThan, limit, DATASET_FETCH_OPTIONS_FILE_DATASETS);
        return SimpleDataSetHelper.filterAndTranslate(dataSets);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<SimpleDataSetInformationDTO> listPhysicalDataSetsWithUnknownSize(String sessionToken, String dataStoreCode, int chunkSize, String dataSetCodeLowerLimit) {
        Session session = this.getSession(sessionToken);
        DataStorePE dataStore = this.loadDataStore(session, dataStoreCode);
        IDatasetLister datasetLister = this.businessObjectFactory.createDatasetLister(session);
        List<AbstractExternalData> dataSets = datasetLister.listByDataStoreWithUnknownSize(dataStore.getId(), chunkSize, dataSetCodeLowerLimit, DATASET_FETCH_OPTIONS_FILE_DATASETS);
        return SimpleDataSetHelper.filterAndTranslate(dataSets);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void updatePhysicalDataSetsSize(String sessionToken, Map<String, Long> sizeMap) {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        IDataBO dataBO = this.businessObjectFactory.createDataBO(session);
        dataBO.updateSizes(sizeMap);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AbstractExternalData> listAvailableDataSets(String sessionToken, String dataStoreCode, ArchiverDataSetCriteria criteria) {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.createDatasetLister(session);
        return datasetLister.listByArchiverCriteria(dataStoreCode, criteria);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AbstractExternalData> listDataSets(String sessionToken, String dataStoreCode, TrackingDataSetCriteria criteria) {
        Session session = this.getSession(sessionToken);
        this.getDAOFactory().getHomeDatabaseInstance();
        DataStorePE dataStore = this.getDAOFactory().getDataStoreDAO().tryToFindDataStoreByCode(dataStoreCode);
        if (dataStore == null) {
            throw new UserFailureException("Unknown data store: " + dataStoreCode);
        }
        IDatasetLister datasetLister = this.createDatasetLister(session);
        List<AbstractExternalData> allDataSets = datasetLister.listByTrackingCriteria(criteria);
        ArrayList<AbstractExternalData> result = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData externalData : allDataSets) {
            if (!dataStoreCode.equals(externalData.getDataStore().getCode())) continue;
            result.add(externalData);
        }
        return result;
    }

    private DataStorePE loadDataStore(Session session, String dataStoreCode) {
        DataStorePE dataStore = this.getDAOFactory().getDataStoreDAO().tryToFindDataStoreByCode(dataStoreCode);
        if (dataStore == null) {
            throw new UserFailureException(String.format("Unknown data store '%s'", dataStoreCode));
        }
        return dataStore;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<DeletedDataSet> listDeletedDataSets(String sessionToken, Long lastSeenDeletionEventIdOrNull, Date maxDeletionDataOrNull) {
        this.checkSession(sessionToken);
        return this.getDAOFactory().getEventDAO().listDeletedDataSets(lastSeenDeletionEventIdOrNull, maxDeletionDataOrNull);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Collection<VocabularyTerm> listVocabularyTerms(String sessionToken, String vocabularyCode) throws UserFailureException {
        this.checkSession(sessionToken);
        VocabularyPE vocabularyOrNull = this.getDAOFactory().getVocabularyDAO().tryFindVocabularyByCode(vocabularyCode);
        if (vocabularyOrNull == null) {
            throw new UserFailureException(String.format("Vocabulary '%s' not found", vocabularyCode));
        }
        return VocabularyTermTranslator.translateTerms(vocabularyOrNull.getTerms());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Vocabulary tryGetVocabulary(String sessionToken, String vocabularyCode) {
        this.checkSession(sessionToken);
        VocabularyPE vocabularyOrNull = this.getDAOFactory().getVocabularyDAO().tryFindVocabularyByCode(vocabularyCode);
        if (vocabularyOrNull == null) {
            return null;
        }
        return VocabularyTranslator.translate(vocabularyOrNull, true);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<String> generateCodes(String sessionToken, String prefix, EntityKind entityKind, int number) {
        this.checkSession(sessionToken);
        return new EntityCodeGenerator(this.daoFactory).generateCodes(prefix, entityKind, number);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Person> listAdministrators(String sessionToken) {
        this.checkSession(sessionToken);
        List<PersonPE> persons = this.getDAOFactory().getPersonDAO().listPersons();
        ArrayList<PersonPE> admins = new ArrayList<PersonPE>();
        for (PersonPE person : persons) {
            for (RoleAssignmentPE roleAssigment : person.getRoleAssignments()) {
                if (roleAssigment.getDatabaseInstance() == null || !roleAssigment.getRole().equals(RoleWithHierarchy.RoleCode.ADMIN)) continue;
                admins.add(person);
            }
        }
        Collections.sort(admins);
        return PersonTranslator.translate(admins);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Person tryPersonWithUserIdOrEmail(String sessionToken, String useridOrEmail) {
        this.checkSession(sessionToken);
        PersonPE personPE = this.tryFindPersonForUserIdOrEmail(useridOrEmail);
        return personPE != null ? PersonTranslator.translate(personPE) : null;
    }

    private PersonPE tryFindPersonForUserIdOrEmail(String userIdOrEmail) {
        if (userIdOrEmail == null) {
            return null;
        }
        IPersonDAO personDao = this.getDAOFactory().getPersonDAO();
        PersonPE person = personDao.tryFindPersonByUserId(userIdOrEmail);
        if (person != null) {
            return person;
        }
        return personDao.tryFindPersonByEmail(userIdOrEmail);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Sample registerSampleAndDataSet(String sessionToken, @AuthorizationGuard(guardClass=NewSamplePredicate.class) NewSample newSample, NewExternalData externalData, String userIdOrNull) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (newSample != null) : "Unspecified new sample.";
        Session session = this.getSession(sessionToken);
        SamplePE samplePE = this.registerSampleInternal(session, newSample, userIdOrNull);
        this.registerDataSetInternal(sessionToken, externalData, samplePE);
        Sample result = SampleTranslator.translate(samplePE, session.getBaseIndexURL(), null, this.managedPropertyEvaluatorFactory);
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Sample updateSampleAndRegisterDataSet(String sessionToken, @AuthorizationGuard(guardClass=SampleUpdatesPredicate.class) SampleUpdatesDTO updates, NewExternalData externalData) {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.updateSampleInternal(updates, session);
        SamplePE samplePE = sampleBO.getSample();
        this.registerDataSetInternal(sessionToken, externalData, samplePE);
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), samplePE);
        Sample result = SampleTranslator.translate(samplePE, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory);
        return result;
    }

    private ISampleBO updateSampleInternal(SampleUpdatesDTO updates, Session session) {
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.update(updates);
        sampleBO.save();
        return sampleBO;
    }

    private void registerDataSetInternal(String sessionToken, NewExternalData externalData, SamplePE samplePE) {
        Session session = this.getSession(sessionToken);
        SampleIdentifier sampleIdentifier = samplePE.getSampleIdentifier();
        assert (sampleIdentifier != null) : "Unspecified sample identifier.";
        ExperimentPE experiment = samplePE.getExperiment();
        if (experiment == null) {
            throw new UserFailureException("No experiment found for sample " + sampleIdentifier);
        }
        if (experiment.getDeletion() != null) {
            throw new UserFailureException("Data set can not be registered because experiment '" + experiment.getIdentifier() + "' is in trash.");
        }
        IDataBO dataBO = this.businessObjectFactory.createDataBO(session);
        SourceType sourceType = externalData.isMeasured() ? SourceType.MEASUREMENT : SourceType.DERIVED;
        dataBO.define(externalData, samplePE, sourceType);
        dataBO.save();
        String dataSetCode = dataBO.getData().getCode();
        assert (dataSetCode != null) : "Data set code not specified.";
    }

    private SamplePE registerSampleInternal(Session session, NewSample newSample, String userIdOrNull) {
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.define(newSample);
        if (userIdOrNull != null) {
            sampleBO.getSample().setRegistrator(this.getOrCreatePerson(session.getSessionToken(), userIdOrNull));
        }
        sampleBO.save();
        SamplePE samplePE = sampleBO.getSample();
        return samplePE;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Space tryGetSpace(String sessionToken, @AuthorizationGuard(guardClass=ExistingSpaceIdentifierPredicate.class) SpaceIdentifier spaceIdentifier) {
        Session session = this.getSession(sessionToken);
        ISpaceBO spaceBO = this.businessObjectFactory.createSpaceBO(session);
        SpaceIdentifier identifier = new SpaceIdentifier(spaceIdentifier.getDatabaseInstanceCode(), spaceIdentifier.getSpaceCode());
        try {
            spaceBO.load(identifier);
            return SpaceTranslator.translate(spaceBO.getSpace());
        }
        catch (UserFailureException userFailureException) {
            return null;
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Project tryGetProject(String sessionToken, @AuthorizationGuard(guardClass=ExistingSpaceIdentifierPredicate.class) ProjectIdentifier projectIdentifier) {
        Session session = this.getSession(sessionToken);
        IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
        try {
            bo.loadByProjectIdentifier(projectIdentifier);
            ProjectPE project = bo.getProject();
            return ProjectTranslator.translate(project);
        }
        catch (UserFailureException userFailureException) {
            return null;
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Material tryGetMaterial(String sessionToken, MaterialIdentifier materialIdentifier) {
        Session session = this.getSession(sessionToken);
        IMaterialBO bo = this.businessObjectFactory.createMaterialBO(session);
        try {
            bo.loadByMaterialIdentifier(materialIdentifier);
            bo.enrichWithProperties();
            MaterialPE materialPE = bo.getMaterial();
            Collection<MetaprojectPE> metaprojectPEs = Collections.emptySet();
            if (materialPE != null) {
                metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), materialPE);
            }
            return MaterialTranslator.translate(materialPE, MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory);
        }
        catch (UserFailureException userFailureException) {
            return null;
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Metaproject tryGetMetaproject(String sessionToken, String name, String ownerId) {
        Session session = this.getSession(sessionToken);
        IMetaprojectBO bo = this.businessObjectFactory.createMetaprojectBO(session);
        MetaprojectPE pe = bo.tryFindByMetaprojectId(new MetaprojectIdentifierId(ownerId, name));
        if (pe == null) {
            return null;
        }
        return MetaprojectTranslator.translate(pe);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public AtomicEntityOperationResult performEntityOperations(String sessionToken, @AuthorizationGuard(guardClass=AtomicOperationsPredicate.class) AtomicEntityOperationDetails operationDetails) {
        AtomicEntityOperationResult atomicEntityOperationResult;
        block5: {
            IServiceConversationProgressListener progressListener = ServiceConversationsThreadContext.getProgressListener();
            TechId registrationId = operationDetails.getRegistrationIdOrNull();
            EntityOperationsInProgress.getInstance().addRegistrationPending(registrationId);
            String sessionTokenForEntityOperation = null;
            try {
                Session session = this.getSession(sessionToken);
                String userId = operationDetails.tryUserIdOrNull();
                boolean authorize = userId != null;
                Session sessionForEntityOperation = session;
                if (authorize) {
                    sessionTokenForEntityOperation = this.sessionManagerForEntityOperation.tryToOpenSession(userId, "dummy password");
                    sessionForEntityOperation = this.sessionManagerForEntityOperation.getSession(sessionTokenForEntityOperation);
                    this.injectPerson(sessionForEntityOperation, userId);
                }
                long spacesCreated = this.createSpaces(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long materialsCreated = this.createMaterials(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long projectsCreated = this.createProjects(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long projectsUpdated = this.updateProjects(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long vocabulariesUpdated = this.updateVocabularies(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long experimentsCreated = this.createExperiments(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long experimentsUpdates = this.updateExperiments(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long samplesCreated = this.createSamples(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long samplesUpdated = this.updateSamples(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long dataSetsCreated = this.createDataSets(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long dataSetsUpdated = this.updateDataSets(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long materialsUpdates = this.updateMaterials(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long metaprojectsCreated = this.createMetaprojects(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long metaprojectsUpdates = this.updateMetaprojects(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long spaceRolesAssigned = this.assignSpaceRoles(sessionForEntityOperation, operationDetails, progressListener, authorize);
                long spaceRolesRevoked = this.revokeSpaceRoles(sessionForEntityOperation, operationDetails, progressListener, authorize);
                if (registrationId != null) {
                    this.daoFactory.getEntityOperationsLogDAO().addLogEntry(registrationId.getId());
                }
                atomicEntityOperationResult = new AtomicEntityOperationResult(spacesCreated, projectsCreated, projectsUpdated, materialsCreated, materialsUpdates, experimentsCreated, experimentsUpdates, samplesCreated, samplesUpdated, dataSetsCreated, dataSetsUpdated, metaprojectsCreated, metaprojectsUpdates, vocabulariesUpdated, spaceRolesAssigned, spaceRolesRevoked);
                EntityOperationsInProgress.getInstance().removeRegistrationPending(registrationId);
                if (sessionTokenForEntityOperation == null) break block5;
            }
            catch (Throwable throwable) {
                EntityOperationsInProgress.getInstance().removeRegistrationPending(registrationId);
                if (sessionTokenForEntityOperation != null) {
                    this.sessionManagerForEntityOperation.closeSession(sessionTokenForEntityOperation);
                }
                throw throwable;
            }
            this.sessionManagerForEntityOperation.closeSession(sessionTokenForEntityOperation);
        }
        return atomicEntityOperationResult;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public EntityOperationsState didEntityOperationsSucceed(String token, TechId registrationId) {
        if (registrationId == null) {
            return EntityOperationsState.NO_OPERATION;
        }
        if (EntityOperationsInProgress.getInstance().isRegistrationPending(registrationId)) {
            return EntityOperationsState.IN_PROGRESS;
        }
        EntityOperationsLogEntryPE logEntry = this.daoFactory.getEntityOperationsLogDAO().tryFindLogEntry(registrationId.getId());
        if (logEntry != null) {
            return EntityOperationsState.OPERATION_SUCCEEDED;
        }
        return EntityOperationsState.NO_OPERATION;
    }

    private long createSpaces(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        ArrayList<SpacePE> spacePEsCreated = new ArrayList<SpacePE>();
        List<NewSpace> newSpaces = operationDetails.getSpaceRegistrations();
        if (authorize) {
            this.checkSpaceCreationAllowed(session, newSpaces);
        }
        int index = 0;
        for (NewSpace newSpace : newSpaces) {
            SpacePE spacePE = this.registerSpaceInternal(session, newSpace, operationDetails.tryUserIdOrNull());
            spacePEsCreated.add(spacePE);
            progress.update("createSpaces", newSpaces.size(), ++index);
        }
        return index;
    }

    protected void checkSpaceCreationAllowed(Session session, List<NewSpace> newSpaces) {
        if (newSpaces != null && !newSpaces.isEmpty()) {
            this.entityOperationChecker.assertSpaceCreationAllowed(session, newSpaces);
        }
    }

    protected void checkSpaceRoleAssignmentAllowed(Session session, SpaceIdentifier space) {
        this.entityOperationChecker.assertSpaceRoleAssignmentAllowed(session, space);
    }

    private long updateVocabularies(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        List<VocabularyUpdatesDTO> updates = operationDetails.getVocabularyUpdates();
        for (VocabularyUpdatesDTO update : updates) {
            this.updateVocabulary(session, update);
        }
        return updates.size();
    }

    private void updateVocabulary(Session session, VocabularyUpdatesDTO updates) {
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        vocabularyBO.update(updates);
    }

    private long createMaterials(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        MaterialHelper materialHelper = new MaterialHelper(session, this.businessObjectFactory, this.getDAOFactory(), this.getPropertiesBatchManager(), this.managedPropertyEvaluatorFactory);
        Map<String, List<NewMaterial>> materialRegs = operationDetails.getMaterialRegistrations();
        if (authorize) {
            this.checkMaterialCreationAllowed(session, materialRegs);
        }
        List<NewMaterialWithType> materials = materialHelper.convertMaterialRegistrationIntoMaterialsWithType(materialRegs);
        Map<String, Set<String>> materialTypesWithMateiralProperties = materialHelper.getPropertyTypesOfMaterialType(materialRegs.keySet());
        List<List<NewMaterialWithType>> materialGroups = MaterialGroupingDAG.groupByDepencies(materials, materialTypesWithMateiralProperties);
        int index = 0;
        for (List<NewMaterialWithType> materialsGroup : materialGroups) {
            materialHelper.registerMaterials(materialsGroup);
            progress.update("createMaterials", materialRegs.size(), ++index);
        }
        return index;
    }

    private long updateMaterials(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        MaterialHelper materialHelper = new MaterialHelper(session, this.businessObjectFactory, this.getDAOFactory(), this.getPropertiesBatchManager(), this.managedPropertyEvaluatorFactory);
        List<MaterialUpdateDTO> allMaterialUpdates = operationDetails.getMaterialUpdates();
        if (authorize) {
            this.checkMaterialUpdateAllowed(session, allMaterialUpdates);
        }
        materialHelper.updateMaterials(allMaterialUpdates);
        return allMaterialUpdates.size();
    }

    protected void checkMaterialCreationAllowed(Session session, Map<String, List<NewMaterial>> materials) {
        if (materials != null && !materials.isEmpty()) {
            this.entityOperationChecker.assertMaterialCreationAllowed(session, materials);
        }
    }

    protected void checkMaterialUpdateAllowed(Session session, List<MaterialUpdateDTO> materialUpdates) {
        if (materialUpdates != null && !materialUpdates.isEmpty()) {
            this.entityOperationChecker.assertMaterialUpdateAllowed(session, materialUpdates);
        }
    }

    private long updateMetaprojects(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        List<MetaprojectUpdatesDTO> updates = operationDetails.getMetaprojectUpdates();
        for (MetaprojectUpdatesDTO update : updates) {
            this.updateMetaprojects(session, update);
        }
        return updates.size();
    }

    private void updateMetaprojects(Session session, MetaprojectUpdatesDTO update) {
        IMetaprojectBO metaprojectBO = this.businessObjectFactory.createMetaprojectBO(session);
        metaprojectBO.loadDataByTechId(update.getMetaprojectId());
        Metaproject updates = new Metaproject();
        updates.setName(metaprojectBO.getMetaproject().getName());
        updates.setDescription(update.getDescription());
        metaprojectBO.update(updates);
        metaprojectBO.addSamples(update.getAddedSamples());
        metaprojectBO.removeSamples(update.getRemovedSamples());
        metaprojectBO.addDataSets(update.getAddedDataSets());
        metaprojectBO.removeDataSets(update.getRemovedDataSets());
        metaprojectBO.addExperiments(update.getAddedExperiments());
        metaprojectBO.removeExperiments(update.getRemovedExperiments());
        metaprojectBO.addMaterials(update.getAddedMaterials());
        metaprojectBO.removeMaterials(update.getRemovedMaterials());
        metaprojectBO.save();
    }

    private long assignSpaceRoles(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progressListener, boolean authorize) {
        List<SpaceRoleAssignment> spaceRoleAssignments = operationDetails.getSpaceRoleAssignments();
        int index = 0;
        int assignmentCount = 0;
        for (SpaceRoleAssignment assignment : spaceRoleAssignments) {
            assignmentCount += assignment.getGrantees().size();
        }
        if (assignmentCount < 1) {
            return assignmentCount;
        }
        IRoleAssignmentTable table = this.businessObjectFactory.createRoleAssignmentTable(session);
        for (SpaceRoleAssignment assignment : spaceRoleAssignments) {
            RoleWithHierarchy.RoleCode roleCode = assignment.getRoleCode();
            SpaceIdentifier space = assignment.getSpaceIdentifier();
            if (authorize) {
                this.checkSpaceRoleAssignmentAllowed(session, space);
            }
            for (Grantee grantee : assignment.getGrantees()) {
                NewRoleAssignment newRoleAssignment = new NewRoleAssignment();
                newRoleAssignment.setGrantee(grantee);
                newRoleAssignment.setSpaceIdentifier(space);
                newRoleAssignment.setRole(roleCode);
                table.add(newRoleAssignment);
                progressListener.update("assignSpaceRole", assignmentCount, ++index);
            }
        }
        table.save();
        return index;
    }

    private long revokeSpaceRoles(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progressListener, boolean authorize) {
        List<SpaceRoleAssignment> spaceRoleRevocations = operationDetails.getSpaceRoleRevocations();
        int index = 0;
        int assignmentCount = 0;
        for (SpaceRoleAssignment assignment : spaceRoleRevocations) {
            assignmentCount += assignment.getGrantees().size();
        }
        if (assignmentCount < 1) {
            return assignmentCount;
        }
        for (SpaceRoleAssignment assignment : spaceRoleRevocations) {
            RoleWithHierarchy.RoleCode roleCode = assignment.getRoleCode();
            SpaceIdentifier space = assignment.getSpaceIdentifier();
            for (Grantee grantee : assignment.getGrantees()) {
                RoleAssignmentPE roleAssignment = this.getDAOFactory().getRoleAssignmentDAO().tryFindSpaceRoleAssignment(roleCode, space.getSpaceCode(), grantee);
                if (roleAssignment == null) {
                    throw new UserFailureException("Given space role does not exist.");
                }
                PersonPE personPE = session.tryGetPerson();
                if (roleAssignment.getPerson() != null && roleAssignment.getPerson().equals(personPE) && roleAssignment.getRole().equals(RoleWithHierarchy.RoleCode.ADMIN)) {
                    boolean isInstanceAdmin = false;
                    for (RoleAssignmentPE roleAssigment : personPE.getRoleAssignments()) {
                        if (roleAssigment.getDatabaseInstance() == null || !roleAssigment.getRole().equals(RoleWithHierarchy.RoleCode.ADMIN)) continue;
                        isInstanceAdmin = true;
                    }
                    if (!isInstanceAdmin) {
                        throw new UserFailureException("For safety reason you cannot give away your own space admin power. Ask instance admin to do that for you.");
                    }
                }
                this.getDAOFactory().getRoleAssignmentDAO().deleteRoleAssignment(roleAssignment);
                progressListener.update("revokeSpaceRole", assignmentCount, ++index);
            }
        }
        return index;
    }

    private long createMetaprojects(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        List<NewMetaproject> metaprojectRegistrations = operationDetails.getMetaprojectRegistrations();
        int index = 0;
        for (NewMetaproject metaproject : metaprojectRegistrations) {
            this.registerMetaproject(session, metaproject);
            progress.update("createMetaProjects", metaprojectRegistrations.size(), ++index);
        }
        return index;
    }

    private MetaprojectPE registerMetaproject(Session session, NewMetaproject metaproject) {
        IMetaprojectBO metaprojectBO = this.businessObjectFactory.createMetaprojectBO(session);
        Metaproject registration = new Metaproject();
        registration.setName(metaproject.getName());
        registration.setDescription(metaproject.getDescription());
        metaprojectBO.define(metaproject.getOwnerId(), registration);
        metaprojectBO.addSamples(metaproject.getSamples());
        metaprojectBO.addExperiments(metaproject.getExperiments());
        metaprojectBO.addMaterials(metaproject.getMaterials());
        metaprojectBO.addDataSets(metaproject.getDatasets());
        metaprojectBO.save();
        return metaprojectBO.getMetaproject();
    }

    private SpacePE registerSpaceInternal(Session session, NewSpace newSpace, String registratorUserIdOrNull) {
        ISpaceBO groupBO = this.businessObjectFactory.createSpaceBO(session);
        groupBO.define(newSpace.getCode(), newSpace.getDescription());
        SpacePE space = groupBO.getSpace();
        if (registratorUserIdOrNull != null) {
            space.setRegistrator(this.getOrCreatePerson(session.getSessionToken(), registratorUserIdOrNull));
        }
        groupBO.save();
        if (newSpace.getSpaceAdminUserId() != null) {
            IRoleAssignmentTable roleTable = this.businessObjectFactory.createRoleAssignmentTable(session);
            NewRoleAssignment assignment = new NewRoleAssignment();
            SpaceIdentifier spaceIdentifier = new SpaceIdentifier(space.getCode());
            assignment.setSpaceIdentifier(spaceIdentifier);
            assignment.setRole(RoleWithHierarchy.RoleCode.ADMIN);
            Grantee grantee = Grantee.createPerson(newSpace.getSpaceAdminUserId());
            assignment.setGrantee(grantee);
            roleTable.add(assignment);
            roleTable.save();
        }
        return space;
    }

    private long createProjects(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        ArrayList<ProjectPE> projectPEsCreated = new ArrayList<ProjectPE>();
        List<NewProject> newProjects = operationDetails.getProjectRegistrations();
        if (authorize) {
            this.checkProjectCreationAllowed(session, newProjects);
        }
        int index = 0;
        for (NewProject newProject : newProjects) {
            ProjectPE projectPE = this.registerProjectInternal(session, newProject, operationDetails.tryUserIdOrNull());
            projectPEsCreated.add(projectPE);
            progress.update("createProjects", newProjects.size(), ++index);
        }
        return index;
    }

    protected void checkProjectCreationAllowed(Session session, List<NewProject> newProjects) {
        if (newProjects != null && !newProjects.isEmpty()) {
            this.entityOperationChecker.assertProjectCreationAllowed(session, newProjects);
        }
    }

    private ProjectPE registerProjectInternal(Session session, NewProject newProject, String registratorUserIdOrNull) {
        IProjectBO projectBO = this.businessObjectFactory.createProjectBO(session);
        ProjectIdentifier identifier = new ProjectIdentifierFactory(newProject.getIdentifier()).createIdentifier();
        projectBO.define(identifier, newProject.getDescription(), newProject.getAttachments(), null);
        if (registratorUserIdOrNull != null) {
            projectBO.getProject().setRegistrator(this.getOrCreatePerson(session.getSessionToken(), registratorUserIdOrNull));
        }
        projectBO.save();
        return projectBO.getProject();
    }

    private long updateProjects(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        ArrayList<ProjectPE> projectPEsUpdated = new ArrayList<ProjectPE>();
        List<ProjectUpdatesDTO> projectsToUpdate = operationDetails.getProjectUpdates();
        if (authorize) {
            this.checkProjectUpdateAllowed(session, projectsToUpdate);
        }
        int index = 0;
        for (ProjectUpdatesDTO project : projectsToUpdate) {
            ProjectPE projectPE = this.updateProjectInternal(session, project, operationDetails.tryUserIdOrNull());
            projectPEsUpdated.add(projectPE);
            progress.update("updateProjects", projectsToUpdate.size(), ++index);
        }
        return index;
    }

    protected void checkProjectUpdateAllowed(Session session, List<ProjectUpdatesDTO> projectsToUpdate) {
        if (projectsToUpdate != null && !projectsToUpdate.isEmpty()) {
            this.entityOperationChecker.assertProjectUpdateAllowed(session, projectsToUpdate);
        }
    }

    private ProjectPE updateProjectInternal(Session session, ProjectUpdatesDTO projectToUpdate, String registratorUserIdOrNull) {
        IProjectBO projectBO = this.businessObjectFactory.createProjectBO(session);
        if (projectToUpdate.getTechId() != null) {
            projectBO.loadDataByTechId(projectToUpdate.getTechId());
        } else if (projectToUpdate.getPermId() != null) {
            projectBO.loadByPermId(projectToUpdate.getPermId());
        } else {
            ProjectIdentifier identifier = new ProjectIdentifierFactory(projectToUpdate.getIdentifier()).createIdentifier();
            projectBO.loadByProjectIdentifier(identifier);
        }
        projectBO.update(projectToUpdate);
        if (registratorUserIdOrNull != null) {
            projectBO.getProject().setModifier(this.getOrCreatePerson(session.getSessionToken(), registratorUserIdOrNull));
        }
        projectBO.save();
        return projectBO.getProject();
    }

    private long createSamples(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        List<NewSample> newSamples = operationDetails.getSampleRegistrations();
        if (authorize) {
            this.authorizeSampleCreation(session, newSamples);
        }
        String userIdOrNull = operationDetails.tryUserIdOrNull();
        PersonPE registratorOrNull = this.tryFindPersonForUserIdOrEmail(userIdOrNull);
        ISampleTable sampleTable = this.businessObjectFactory.createSampleTable(session);
        List<List<NewSample>> sampleGroups = this.splitIntoDependencyGroups(newSamples);
        for (List<NewSample> groupOfSamples : sampleGroups) {
            BatchOperationExecutor.executeInBatches(new SampleBatchRegistration(sampleTable, groupOfSamples, registratorOrNull), this.getBatchSize(operationDetails), progress, "createContainerSamples");
        }
        return newSamples.size();
    }

    private List<List<NewSample>> splitIntoDependencyGroups(List<NewSample> newSamples) {
        return SampleGroupingDAG.groupByDepencies(newSamples);
    }

    private void authorizeSampleCreation(Session session, List<NewSample> newSamples) {
        ArrayList<NewSample> instanceSamples = new ArrayList<NewSample>();
        ArrayList<NewSample> spaceSamples = new ArrayList<NewSample>();
        for (NewSample newSample : newSamples) {
            SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(newSample);
            if (sampleIdentifier.isDatabaseInstanceLevel()) {
                instanceSamples.add(newSample);
                continue;
            }
            spaceSamples.add(newSample);
        }
        this.checkInstanceSampleCreationAllowed(session, instanceSamples);
        this.checkSpaceSampleCreationAllowed(session, spaceSamples);
    }

    private void checkInstanceSampleCreationAllowed(Session session, List<NewSample> instanceSamples) {
        if (!instanceSamples.isEmpty()) {
            this.entityOperationChecker.assertInstanceSampleCreationAllowed(session, instanceSamples);
        }
    }

    private void checkSpaceSampleCreationAllowed(Session session, List<NewSample> spaceSamples) {
        if (!spaceSamples.isEmpty()) {
            this.entityOperationChecker.assertSpaceSampleCreationAllowed(session, spaceSamples);
        }
    }

    private long updateSamples(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        List<SampleUpdatesDTO> sampleUpdates = operationDetails.getSampleUpdates();
        int sampleUpdateCount = sampleUpdates.size();
        if (sampleUpdateCount < 1) {
            return 0L;
        }
        progress.update("authorizingSampleUpdates", sampleUpdateCount, 0);
        if (authorize) {
            this.checkSampleUpdatesAllowed(session, sampleUpdates);
        }
        progress.update("authorizingSampleUpdates", sampleUpdateCount, sampleUpdateCount);
        ISampleTable sampleTable = this.businessObjectFactory.createSampleTable(session);
        BatchOperationExecutor.executeInBatches(new SampleCheckBeforeUpdate(sampleTable, sampleUpdates), this.getBatchSize(operationDetails), progress, "checkSamplesBeforeUpdate");
        BatchOperationExecutor.executeInBatches(new SampleUpdate(sampleTable, sampleUpdates), this.getBatchSize(operationDetails), progress, "updateSamples");
        return sampleUpdateCount;
    }

    private void checkSampleUpdatesAllowed(Session session, List<SampleUpdatesDTO> sampleUpdates) {
        ArrayList<SampleUpdatesDTO> instanceSamples = new ArrayList<SampleUpdatesDTO>();
        ArrayList<SampleUpdatesDTO> spaceSamples = new ArrayList<SampleUpdatesDTO>();
        for (SampleUpdatesDTO sampleUpdate : sampleUpdates) {
            SampleIdentifier sampleIdentifier = sampleUpdate.getSampleIdentifier();
            if (sampleIdentifier.isDatabaseInstanceLevel()) {
                instanceSamples.add(sampleUpdate);
                continue;
            }
            spaceSamples.add(sampleUpdate);
        }
        this.checkInstanceSampleUpdateAllowed(session, instanceSamples);
        this.checkSpaceSampleUpdateAllowed(session, spaceSamples);
    }

    private void checkInstanceSampleUpdateAllowed(Session session, List<SampleUpdatesDTO> instanceSamples) {
        if (!instanceSamples.isEmpty()) {
            this.entityOperationChecker.assertInstanceSampleUpdateAllowed(session, instanceSamples);
        }
    }

    private void checkSpaceSampleUpdateAllowed(Session session, List<SampleUpdatesDTO> spaceSamples) {
        if (!spaceSamples.isEmpty()) {
            this.entityOperationChecker.assertSpaceSampleUpdateAllowed(session, spaceSamples);
        }
    }

    private long createDataSets(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        ArrayList<DataPE> dataSetsCreated = new ArrayList<DataPE>();
        List<NewExternalData> dataSetRegistrations = operationDetails.getDataSetRegistrations();
        if (authorize) {
            this.checkDataSetCreationAllowed(session, dataSetRegistrations);
        }
        List<List<NewExternalData>> orderedRegistrations = NewExternalDataDAG.groupByDepencies(dataSetRegistrations);
        int total = 0;
        for (List<NewExternalData> dependencyLevel : orderedRegistrations) {
            total += dependencyLevel.size();
        }
        int index = 0;
        for (List<NewExternalData> dependencyLevel : orderedRegistrations) {
            for (NewExternalData dataSet : dependencyLevel) {
                this.registerDatasetInternal(session, dataSetsCreated, dataSet);
                progress.update("createDataSets", total, ++index);
            }
        }
        return index;
    }

    private void checkDataSetCreationAllowed(Session session, List<? extends NewExternalData> dataSets) {
        if (dataSets != null && !dataSets.isEmpty()) {
            this.entityOperationChecker.assertDataSetCreationAllowed(session, dataSets);
        }
    }

    private long updateDataSets(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        List<DataSetBatchUpdatesDTO> dataSetUpdates = operationDetails.getDataSetUpdates();
        int dataSetUpdatesCount = dataSetUpdates.size();
        if (dataSetUpdatesCount < 1) {
            return 0L;
        }
        progress.update("authorizingDataSetUpdates", dataSetUpdatesCount, 0);
        if (authorize) {
            this.checkDataSetUpdateAllowed(session, dataSetUpdates);
        }
        progress.update("authorizingDataSetUpdates", dataSetUpdatesCount, dataSetUpdatesCount);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        BatchOperationExecutor.executeInBatches(new DataSetCheckBeforeBatchUpdate(dataSetTable, dataSetUpdates), this.getBatchSize(operationDetails), progress, "checkDataSetsBeforeUpdate");
        BatchOperationExecutor.executeInBatches(new DataSetBatchUpdate(dataSetTable, dataSetUpdates), this.getBatchSize(operationDetails), progress, "updateDataSets");
        return dataSetUpdatesCount;
    }

    private void checkDataSetUpdateAllowed(Session session, List<DataSetBatchUpdatesDTO> dataSets) {
        if (dataSets != null && !dataSets.isEmpty()) {
            this.entityOperationChecker.assertDataSetUpdateAllowed(session, dataSets);
        }
    }

    private void registerDatasetInternal(Session session, ArrayList<DataPE> dataSetsCreated, NewExternalData dataSet) {
        IDataBO dataBO;
        SampleIdentifier sampleIdentifier = dataSet.getSampleIdentifierOrNull();
        if (sampleIdentifier != null) {
            dataBO = this.registerDataSetInternal(session, sampleIdentifier, dataSet);
        } else {
            ExperimentIdentifier experimentIdentifier = dataSet.getExperimentIdentifierOrNull();
            dataBO = this.registerDataSetInternal(session, experimentIdentifier, dataSet);
        }
        dataSetsCreated.add(dataBO.getData());
    }

    private long createExperiments(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        List<NewExperiment> experimentRegistrations = operationDetails.getExperimentRegistrations();
        if (authorize) {
            this.entityOperationChecker.assertExperimentCreationAllowed(session, experimentRegistrations);
        }
        int index = 0;
        for (NewExperiment experiment : experimentRegistrations) {
            this.registerExperiment(session, experiment);
            progress.update("createExperiments", experimentRegistrations.size(), ++index);
        }
        return index;
    }

    private void updateExperiment(Session session, ExperimentUpdatesDTO updates) {
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.update(updates);
        experimentBO.save();
    }

    private long updateExperiments(Session session, AtomicEntityOperationDetails operationDetails, IServiceConversationProgressListener progress, boolean authorize) {
        List<ExperimentUpdatesDTO> updates = operationDetails.getExperimentUpdates();
        for (ExperimentUpdatesDTO update : updates) {
            if (authorize) {
                this.entityOperationChecker.assertExperimentUpdateAllowed(session, update);
            }
            this.updateExperiment(session, update);
        }
        return updates.size();
    }

    private IDataBO registerDataSetInternal(Session session, SampleIdentifier sampleIdentifier, NewExternalData externalData) {
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadBySampleIdentifier(sampleIdentifier);
        SamplePE sample = sampleBO.getSample();
        ExperimentPE experiment = sample.getExperiment();
        if (experiment == null) {
            throw new UserFailureException("No experiment found for sample " + sampleIdentifier);
        }
        if (experiment.getDeletion() != null) {
            throw new UserFailureException("Data set can not be registered because experiment '" + experiment.getIdentifier() + "' is in trash.");
        }
        IDataBO dataBO = this.businessObjectFactory.createDataBO(session);
        SourceType sourceType = externalData.isMeasured() ? SourceType.MEASUREMENT : SourceType.DERIVED;
        dataBO.define(externalData, sample, sourceType);
        dataBO.save();
        boolean isContainer = externalData instanceof NewContainerDataSet;
        if (isContainer) {
            dataBO.setContainedDataSets(experiment, (NewContainerDataSet)externalData);
        }
        String dataSetCode = dataBO.getData().getCode();
        assert (dataSetCode != null) : "Data set code not specified.";
        return dataBO;
    }

    private IDataBO registerDataSetInternal(Session session, ExperimentIdentifier experimentIdentifier, NewExternalData externalData) {
        ExperimentPE experiment = this.tryLoadExperimentByIdentifier(session, experimentIdentifier);
        if (experiment.getDeletion() != null) {
            throw new UserFailureException("Data set can not be registered because experiment '" + experiment.getIdentifier() + "' is in trash.");
        }
        IDataBO externalDataBO = this.businessObjectFactory.createDataBO(session);
        SourceType sourceType = externalData.isMeasured() ? SourceType.MEASUREMENT : SourceType.DERIVED;
        externalDataBO.define(externalData, experiment, sourceType);
        externalDataBO.save();
        boolean isContainer = externalData instanceof NewContainerDataSet;
        if (isContainer) {
            externalDataBO.setContainedDataSets(experiment, (NewContainerDataSet)externalData);
        }
        String dataSetCode = externalDataBO.getData().getCode();
        assert (dataSetCode != null) : "Data set code not specified.";
        return externalDataBO;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Sample> searchForSamples(String sessionToken, SearchCriteria searchCriteria) {
        Session session = this.getSession(sessionToken);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.SAMPLE, searchCriteria);
        SearchHelper searchHelper = new SearchHelper(session, this.businessObjectFactory, this.getDAOFactory());
        return searchHelper.searchForSamples(session.getUserName(), detailedSearchCriteria);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AbstractExternalData> searchForDataSets(String sessionToken, SearchCriteria searchCriteria) {
        Session session = this.getSession(sessionToken);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.DATA_SET, searchCriteria);
        SearchHelper searchHelper = new SearchHelper(session, this.businessObjectFactory, this.getDAOFactory());
        return searchHelper.searchForDataSets(session.getUserName(), detailedSearchCriteria);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Material> listMaterials(String sessionToken, ListMaterialCriteria criteria, boolean withProperties) {
        Session session = this.getSession(sessionToken);
        IMaterialLister lister = this.businessObjectFactory.createMaterialLister(session);
        ListMaterialCriteria criteriaWithIds = this.populateMissingTypeId(criteria);
        return lister.list(criteriaWithIds, withProperties);
    }

    private ListMaterialCriteria populateMissingTypeId(ListMaterialCriteria criteria) {
        MaterialType materialTypeOrNull = criteria.tryGetMaterialType();
        if (materialTypeOrNull != null && materialTypeOrNull.getId() == null) {
            String materialTypeCode = materialTypeOrNull.getCode();
            EntityTypePE typeWithId = this.daoFactory.getEntityTypeDAO(ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.MATERIAL).tryToFindEntityTypeByCode(materialTypeCode);
            if (typeWithId == null) {
                throw UserFailureException.fromTemplate("Invalid material type '%s'", materialTypeCode);
            }
            MaterialType materialTypeWithId = new MaterialType();
            materialTypeWithId.setId(typeWithId.getId());
            materialTypeWithId.setCode(materialTypeCode);
            return ListMaterialCriteria.createFromMaterialType(materialTypeWithId);
        }
        return criteria;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void removeDataSetsPermanently(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes, String reason) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        this.permanentlyDeleteDataSets(session, dataSetTable, dataSetCodes, reason, false);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void updateDataSet(String sessionToken, @AuthorizationGuard(guardClass=DataSetUpdatesPredicate.class) DataSetUpdatesDTO dataSetUpdates) {
        Session session = this.getSession(sessionToken);
        IDataBO dataSetBO = this.businessObjectFactory.createDataBO(session);
        dataSetBO.update(dataSetUpdates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<String> getTrustedCrossOriginDomains(String sessionToken) {
        return this.trustedOriginDomainProvider.getTrustedDomains();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void setStorageConfirmed(String sessionToken, String dataSetCode) {
        this.checkSession(sessionToken);
        if (this.daoFactory.getDataDAO().confirmStorage(dataSetCode)) {
            this.daoFactory.getPostRegistrationDAO().addDataSet(dataSetCode);
        } else if (!this.daoFactory.getDataDAO().exists(dataSetCode)) {
            throw new UserFailureException("Storage confirmation for a dataset: " + dataSetCode + " failed because the data set has been already deleted.");
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void markSuccessfulPostRegistration(String sessionToken, String dataSetCode) {
        this.checkSession(sessionToken);
        this.daoFactory.getPostRegistrationDAO().removeDataSet(dataSetCode);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void notifyDatasetAccess(String sessionToken, String dataSetCode) {
        this.checkSession(sessionToken);
        this.daoFactory.getDataDAO().updateAccessTimestamp(dataSetCode);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AbstractExternalData> listDataSetsForPostRegistration(String sessionToken, String dataStoreCode) {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.createDatasetLister(session);
        Collection<Long> allDataSetIds = this.daoFactory.getPostRegistrationDAO().listDataSetsForPostRegistration();
        List<AbstractExternalData> allDataSets = datasetLister.listByDatasetIds(allDataSetIds);
        this.getDAOFactory().getHomeDatabaseInstance();
        DataStorePE dataStore = this.getDAOFactory().getDataStoreDAO().tryToFindDataStoreByCode(dataStoreCode);
        if (dataStore == null) {
            throw new UserFailureException("Unknown data store: " + dataStoreCode);
        }
        ArrayList<AbstractExternalData> result = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData externalData : allDataSets) {
            if (!dataStoreCode.equals(externalData.getDataStore().getCode())) continue;
            result.add(externalData);
        }
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void heartbeat(String token) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public boolean doesUserHaveRole(String token, String user, String roleCode, String spaceOrNull) {
        return new AuthorizationServiceUtils(this.daoFactory, user).doesUserHaveRole(roleCode, spaceOrNull);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<String> filterToVisibleDataSets(String token, String user, List<String> dataSetCodes) {
        return new AuthorizationServiceUtils(this.daoFactory, user).filterDataSetCodes(dataSetCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<String> filterToVisibleExperiments(String token, String user, List<String> experimentIds) {
        return new AuthorizationServiceUtils(this.daoFactory, user).filterExperimentIds(experimentIds);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<String> filterToVisibleSamples(String token, String user, List<String> sampleIds) {
        return new AuthorizationServiceUtils(this.daoFactory, user).filterSampleIds(sampleIds);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<? extends EntityTypePropertyType<?>> listPropertyDefinitionsForType(String sessionToken, String code, ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind entityKind) {
        IEntityTypeDAO edao = this.daoFactory.getEntityTypeDAO(entityKind);
        IEntityPropertyTypeDAO dao = this.daoFactory.getEntityPropertyTypeDAO(entityKind);
        EntityTypePE type = edao.tryToFindEntityTypeByCode(code);
        List<EntityTypePropertyTypePE> propertiesPE = dao.listEntityPropertyTypes(type);
        if (entityKind == ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.DATA_SET) {
            Collection collection = CollectionUtils.collect(propertiesPE, DataSetTypePropertyTypeTranslator.TRANSFORMER);
            return new LinkedList(collection);
        }
        if (entityKind == ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.SAMPLE) {
            Collection collection = CollectionUtils.collect(propertiesPE, SampleTypePropertyTypeTranslator.TRANSFORMER);
            return new LinkedList(collection);
        }
        if (entityKind == ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.EXPERIMENT) {
            Collection collection = CollectionUtils.collect(propertiesPE, ExperimentTypePropertyTypeTranslator.TRANSFORMER);
            return new LinkedList(collection);
        }
        if (entityKind == ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.MATERIAL) {
            Collection collection = CollectionUtils.collect(propertiesPE, MaterialTypePropertyTypeTranslator.TRANSFORMER);
            return new LinkedList(collection);
        }
        throw new IllegalArgumentException("Unsupported entity kind " + (Object)((Object)entityKind));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public ExternalDataManagementSystem tryGetExternalDataManagementSystem(String token, String externalDataManagementSystemCode) {
        this.checkSession(token);
        ExternalDataManagementSystemPE externalSystem = this.getDAOFactory().getExternalDataManagementSystemDAO().tryToFindExternalDataManagementSystemByCode(externalDataManagementSystemCode);
        if (externalSystem != null) {
            return ExternalDataManagementSystemTranslator.translate(externalSystem);
        }
        return null;
    }

    private int getBatchSize(AtomicEntityOperationDetails details) {
        return details == null || details.getBatchSizeOrNull() == null ? BatchOperationExecutor.getDefaultBatchSize() : details.getBatchSizeOrNull();
    }

    public void setConversationClient(IServiceConversationClientManagerLocal conversationClient) {
        this.conversationClient = conversationClient;
    }

    public void setConversationServer(IServiceConversationServerManagerLocal conversationServer) {
        this.conversationServer = conversationServer;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Metaproject> listMetaprojects(String sessionToken, String userId) {
        IMetaprojectDAO metaprojectDAO = this.daoFactory.getMetaprojectDAO();
        PersonPE owner = this.daoFactory.getPersonDAO().tryFindPersonByUserId(userId);
        if (owner == null) {
            throw new IllegalArgumentException("User with id " + userId + " doesn't exist.");
        }
        List<MetaprojectPE> metaprojectPEs = metaprojectDAO.listMetaprojects(owner);
        return MetaprojectTranslator.translate(metaprojectPEs);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public MetaprojectAssignments getMetaprojectAssignments(String systemSessionToken, String name, String userName, EnumSet<MetaprojectAssignmentsFetchOption> fetchOptions) {
        Metaproject metaproject = this.tryGetMetaproject(systemSessionToken, name, userName);
        if (metaproject == null) {
            throw UserFailureException.fromTemplate("Can't find metaproject '%s/%s'", userName, name);
        }
        MetaprojectAssignmentsHelper helper = new MetaprojectAssignmentsHelper(this.daoFactory, this.managedPropertyEvaluatorFactory);
        return helper.getMetaprojectAssignments(this.getSession(systemSessionToken), metaproject, userName, fetchOptions);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Metaproject> listMetaprojectsForEntity(String systemSessionToken, String userId, IObjectId entityId) {
        IMetaprojectDAO metaprojectDAO = this.daoFactory.getMetaprojectDAO();
        PersonPE owner = this.daoFactory.getPersonDAO().tryFindPersonByUserId(userId);
        EntityObjectIdHelper helper = new EntityObjectIdHelper(this.businessObjectFactory);
        IEntityInformationHolderDTO entity = helper.getEntityById(this.getSession(systemSessionToken), entityId);
        Collection<MetaprojectPE> metaprojectPEs = metaprojectDAO.listMetaprojectsForEntity(owner, entity);
        return MetaprojectTranslator.translate(metaprojectPEs);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AuthorizationGroup> listAuthorizationGroups(String sessionToken) {
        this.checkSession(sessionToken);
        List<AuthorizationGroupPE> authorizationGroups = this.getDAOFactory().getAuthorizationGroupDAO().list();
        Collections.sort(authorizationGroups);
        return AuthorizationGroupTranslator.translate(authorizationGroups);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<AuthorizationGroup> listAuthorizationGroupsForUser(String sessionToken, String userId) {
        this.checkSession(sessionToken);
        List<AuthorizationGroupPE> allAuthorizationGroups = this.getDAOFactory().getAuthorizationGroupDAO().list();
        ArrayList<AuthorizationGroupPE> authorizationGroups = new ArrayList<AuthorizationGroupPE>();
        for (AuthorizationGroupPE authorizationGroup : allAuthorizationGroups) {
            Set<PersonPE> persons = authorizationGroup.getPersons();
            for (PersonPE person : persons) {
                if (!userId.equals(person.getUserId())) continue;
                authorizationGroups.add(authorizationGroup);
            }
        }
        Collections.sort(authorizationGroups);
        return AuthorizationGroupTranslator.translate(authorizationGroups);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Person> listUsersForAuthorizationGroup(String sessionToken, TechId authorizationGroupId) {
        Session session = this.getSession(sessionToken);
        IAuthorizationGroupBO bo = this.businessObjectFactory.createAuthorizationGroupBO(session);
        bo.loadByTechId(authorizationGroupId);
        return PersonTranslator.translate(bo.getAuthorizationGroup().getPersons());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<RoleAssignment> listRoleAssignments(String sessionToken) {
        this.checkSession(sessionToken);
        List<RoleAssignmentPE> roles = this.getDAOFactory().getRoleAssignmentDAO().listRoleAssignments();
        return RoleAssignmentTranslator.translate(roles);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Attachment> listAttachments(String sessionToken, AttachmentHolderKind attachmentHolderKind, Long attachmentHolderId) {
        Session session = this.getSession(sessionToken);
        AttachmentHolderPE attachmentHolder = null;
        switch (attachmentHolderKind) {
            case PROJECT: {
                IProjectBO projectBO = this.businessObjectFactory.createProjectBO(session);
                projectBO.loadDataByTechId(new TechId(attachmentHolderId));
                attachmentHolder = projectBO.getProject();
                break;
            }
            case EXPERIMENT: {
                IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
                experimentBO.loadDataByTechId(new TechId(attachmentHolderId));
                attachmentHolder = experimentBO.getExperiment();
                break;
            }
            case SAMPLE: {
                ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
                sampleBO.loadDataByTechId(new TechId(attachmentHolderId));
                attachmentHolder = sampleBO.getSample();
            }
        }
        if (attachmentHolder != null) {
            List<AttachmentPE> attachments = this.getDAOFactory().getAttachmentDAO().listAttachments(attachmentHolder);
            return AttachmentTranslator.translate(attachments, session.getBaseIndexURL());
        }
        return null;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public AttachmentWithContent getAttachment(String sessionToken, AttachmentHolderKind attachmentHolderKind, Long attachmentHolderId, String fileName, Integer versionOrNull) {
        Session session = this.getSession(sessionToken);
        AttachmentPE attachment = null;
        switch (attachmentHolderKind) {
            case PROJECT: {
                IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
                bo.loadDataByTechId(new TechId(attachmentHolderId));
                attachment = bo.tryGetProjectFileAttachment(fileName, versionOrNull);
                break;
            }
            case EXPERIMENT: {
                IExperimentBO bo = this.businessObjectFactory.createExperimentBO(session);
                bo.loadDataByTechId(new TechId(attachmentHolderId));
                attachment = bo.tryGetExperimentFileAttachment(fileName, versionOrNull);
                break;
            }
            case SAMPLE: {
                ISampleBO bo = this.businessObjectFactory.createSampleBO(session);
                bo.loadDataByTechId(new TechId(attachmentHolderId));
                attachment = bo.tryGetSampleFileAttachment(fileName, versionOrNull);
            }
        }
        if (attachment != null) {
            return AttachmentTranslator.translateWithContent(attachment);
        }
        return null;
    }
}

