/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.api.v1;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.shared.AbstractServerLogger;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationChangingService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignmentsIds;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.NewVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.WebAppSettings;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.Map;

class GeneralInformationChangingServiceLogger
extends AbstractServerLogger
implements IGeneralInformationChangingService {
    public GeneralInformationChangingServiceLogger(ISessionManager<Session> sessionManagerNull, IInvocationLoggerContext context) {
        super(sessionManagerNull, context);
    }

    @Override
    public void updateSampleProperties(String sessionToken, long sampleID, Map<String, String> properties) {
        this.logTracking(sessionToken, "update-sample-properties", "SAMPLE(%s)", sampleID);
    }

    @Override
    public void addUnofficialVocabularyTerm(String sessionToken, TechId vocabularyId, String code, String label, String description, Long previousTermOrdinal) {
        this.logTracking(sessionToken, "add_unofficial_vocabulary_term", "ID(%s) CODE(%s), LABEL(%s), DESCRIPTION(%s), PREVIOUS_ORDINAL(%s)", vocabularyId, code, label, description, Long.toString(previousTermOrdinal));
    }

    @Override
    public void addUnofficialVocabularyTerm(String sessionToken, Long vocabularyId, NewVocabularyTerm term) {
        this.logTracking(sessionToken, "add-unofficial-vocabulary-term", "VOCABULARY_ID(%s) TERM(%s)", vocabularyId, term);
    }

    @Override
    public WebAppSettings getWebAppSettings(String sessionToken, String webAppId) {
        this.logAccess(sessionToken, "get-custom-display-settings", "WEB_APP_ID(%s)", webAppId);
        return null;
    }

    @Override
    public void setWebAppSettings(String sessionToken, WebAppSettings webAppSettings) {
        this.logAccess(sessionToken, "set-custom-display-settings", "WEB_APP_ID(%s)", webAppSettings.getWebAppId());
    }

    @Override
    public Metaproject createMetaproject(String sessionToken, String name, String description) {
        this.logAccess(sessionToken, "createMetaproject", "NAME(%s) DESCRIPTION(%s)", name, description);
        return null;
    }

    @Override
    public Metaproject updateMetaproject(String sessionToken, IMetaprojectId metaprojectId, String name, String descriptionOrNull) {
        this.logAccess(sessionToken, "updateMetaproject", "METAPROJECT_ID(%s) NAME(%s) DESCRIPTION(%s)", metaprojectId, name, descriptionOrNull);
        return null;
    }

    @Override
    public void deleteMetaproject(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "deleteMetaproject", "METAPROJECT_ID(%s)", metaprojectId);
    }

    @Override
    public void addToMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToAdd) {
        MetaprojectAssignmentsIds assignments = assignmentsToAdd != null ? assignmentsToAdd : new MetaprojectAssignmentsIds();
        this.logAccess(sessionToken, "addToMetaproject", "METAPROJECT_ID(%s), EXPERIMENTS(%s), SAMPLES(%s), DATA_SETS(%s), MATERIALS(%s)", metaprojectId, this.abbreviate(assignments.getExperiments()), this.abbreviate(assignments.getSamples()), this.abbreviate(assignments.getDataSets()), this.abbreviate(assignments.getMaterials()));
    }

    @Override
    public void removeFromMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToRemove) {
        MetaprojectAssignmentsIds assignments = assignmentsToRemove != null ? assignmentsToRemove : new MetaprojectAssignmentsIds();
        this.logAccess(sessionToken, "removeFromMetaproject", "METAPROJECT_ID(%s), EXPERIMENTS(%s), SAMPLES(%s), DATA_SETS(%s), MATERIALS(%s)", metaprojectId, this.abbreviate(assignments.getExperiments()), this.abbreviate(assignments.getSamples()), this.abbreviate(assignments.getDataSets()), this.abbreviate(assignments.getMaterials()));
    }

    @Override
    public String registerSamples(String sessionToken, String sampleTypeCode, String sessionKey, String defaultGroupIdentifier) {
        this.logAccess(sessionToken, "registerSamples", "sampleTypeCode(%s), sessionKey(%s), defaultGroupIdentifier(%s)", sampleTypeCode, sessionKey, defaultGroupIdentifier);
        return null;
    }

    @Override
    public String updateSamples(String sessionToken, String sampleTypeCode, String sessionKey, String defaultGroupIdentifier) {
        this.logAccess(sessionToken, "updateSamples", "sampleTypeCode(%s), sessionKey(%s), defaultGroupIdentifier(%s)", sampleTypeCode, sessionKey, defaultGroupIdentifier);
        return null;
    }

    @Override
    public Map<String, Object> uploadedSamplesInfo(String sessionToken, String sampleTypeCode, String sessionKey) {
        this.logAccess(sessionToken, "uploadedSamplesInfo", "sampleTypeCode(%s), sessionKey(%s)", sampleTypeCode, sessionKey);
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }
}

