/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

final class SampleTypeDAO
extends AbstractTypeDAO<SampleTypePE>
implements ISampleTypeDAO {
    @Private
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SampleTypeDAO.class);

    SampleTypeDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, SampleTypePE.class);
    }

    @Override
    public final List<SampleTypePE> listSampleTypes() throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)this.getDatabaseInstance()));
        criteria.setFetchMode("sampleTypePropertyTypesInternal", FetchMode.JOIN);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<SampleTypePE> list = SampleTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s: %d sample type(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final SampleTypePE tryFindSampleTypeByExample(SampleTypePE sampleType) throws DataAccessException {
        assert (sampleType != null) : "Unspecified sample type.";
        List list = SampleTypeDAO.cast(this.getHibernateTemplate().findByExample((Object)sampleType));
        SampleTypePE result = (SampleTypePE)SampleTypeDAO.tryFindEntity(list, "sample type", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): Sample type '%s' found.", MethodUtils.getCurrentMethod().getName(), sampleType, result));
        }
        return result;
    }

    @Override
    public final SampleTypePE tryFindSampleTypeByCode(String code) throws DataAccessException {
        return (SampleTypePE)this.tryFindTypeByCode(code);
    }
}

