/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.PhosphoNetXDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinByExperimentAndReferenceCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.DataSetProtein;
import java.util.Arrays;
import java.util.List;

class DataSetProteinGrid
extends TypedTableGrid<DataSetProtein> {
    private static final String PREFIX = "openbis_data-set-protein-browser";
    public static final String BROWSER_ID = "openbis_data-set-protein-browser_main";
    public static final String GRID_ID = "openbis_data-set-protein-browser-grid";
    private final IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext;
    private ListProteinByExperimentAndReferenceCriteria criteria;

    static IDisposableComponent create(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, IIdAndCodeHolder experimentIdOrNull, TechId proteinReferenceID) {
        return new DataSetProteinGrid(viewContext, experimentIdOrNull, proteinReferenceID).asDisposableWithoutToolbar();
    }

    private static String createWidgetID(IIdAndCodeHolder experimentIdOrNull, TechId proteinReferenceID) {
        return "-" + (experimentIdOrNull == null ? "" : experimentIdOrNull.getId() + "-") + proteinReferenceID;
    }

    private DataSetProteinGrid(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, IIdAndCodeHolder experimentIdOrNull, TechId proteinReferenceID) {
        super(viewContext.getCommonViewContext(), BROWSER_ID + DataSetProteinGrid.createWidgetID(experimentIdOrNull, proteinReferenceID), true, PhosphoNetXDisplayTypeIDGenerator.DATA_SET_PROTEIN_BROWSER_GRID);
        this.specificViewContext = viewContext;
        this.criteria = new ListProteinByExperimentAndReferenceCriteria();
        if (experimentIdOrNull != null) {
            this.criteria.setExperimentID(new TechId(experimentIdOrNull));
        }
        this.criteria.setProteinReferenceID(proteinReferenceID);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return "FDR".equals(columnID) ? "false_discovery_rate_column" : columnID.toLowerCase();
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList(new String[0]);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<DataSetProtein>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<DataSetProtein>> callback) {
        this.criteria.copyPagingConfig(resultSetConfig);
        this.specificViewContext.getService().listProteinsByExperimentAndReference(this.criteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<DataSetProtein>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.specificViewContext.getService().prepareExportDataSetProteins(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }
}

