/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IPhosphoNetXServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.DataSetProtein;
import java.util.List;

public class DataSetProteinProvider
extends AbstractTableModelProvider<DataSetProtein> {
    private final IPhosphoNetXServer server;
    private final String sessionToken;
    private final TechId experimentID;
    private final TechId proteinReferenceID;

    public DataSetProteinProvider(IPhosphoNetXServer server, String sessionToken, TechId experimentID, TechId proteinReferenceID) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.experimentID = experimentID;
        this.proteinReferenceID = proteinReferenceID;
    }

    @Override
    protected TypedTableModel<DataSetProtein> createTableModel() {
        List<DataSetProtein> proteins = this.server.listProteinsByExperimentAndReference(this.sessionToken, this.experimentID, this.proteinReferenceID);
        TypedTableModelBuilder<DataSetProtein> builder = new TypedTableModelBuilder<DataSetProtein>();
        builder.addColumn("DATA_SET_PERM_ID").withDefaultWidth(200);
        builder.addColumn("SEQUENCE_NAME").withDefaultWidth(80);
        builder.addColumn("PEPTIDE_COUNT").withDataType(DataTypeCode.INTEGER).withDefaultWidth(80);
        builder.addColumn("FDR").withDefaultWidth(80);
        for (DataSetProtein protein : proteins) {
            builder.addRow(protein);
            builder.column("DATA_SET_PERM_ID").addString(protein.getDataSetPermID());
            builder.column("SEQUENCE_NAME").addString(protein.getSequenceName());
            builder.column("PEPTIDE_COUNT").addInteger(Long.valueOf(protein.getPeptideCount()));
            int perMille = (int)(1000.0 * protein.getFalseDiscoveryRate() + 0.5);
            builder.column("FDR").addString(String.valueOf(perMille / 10) + "." + perMille % 10 + " %");
        }
        return builder.getModel();
    }
}

