/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ErrorModel;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IDataSetProteinTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinSequenceTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.DataSetProtein;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.IdentifiedProtein;
import java.util.ArrayList;
import java.util.List;
import net.lemnik.eodsql.DataSet;

class DataSetProteinTable
extends AbstractBusinessObject
implements IDataSetProteinTable {
    private List<DataSetProtein> dataSetProteins;

    DataSetProteinTable(IDAOFactory daoFactory, IPhosphoNetXDAOFactory specificDAOFactory, Session session) {
        super(daoFactory, specificDAOFactory, session);
    }

    @Override
    public List<DataSetProtein> getDataSetProteins() {
        return this.dataSetProteins;
    }

    @Override
    public void load(String experimentPermID, TechId proteinReferenceID, IProteinSequenceTable sequenceTable) {
        IProteinQueryDAO proteinQueryDAO = this.getSpecificDAOFactory().getProteinQueryDAO(experimentPermID);
        ErrorModel errorModel = new ErrorModel(proteinQueryDAO);
        DataSet<IdentifiedProtein> proteins = proteinQueryDAO.listProteinsByProteinReferenceAndExperiment(experimentPermID, proteinReferenceID.getId());
        this.dataSetProteins = new ArrayList<DataSetProtein>();
        for (IdentifiedProtein protein : proteins) {
            errorModel.setFalseDiscoveryRateFor(protein);
            DataSetProtein dataSetProtein = new DataSetProtein();
            dataSetProtein.setDataSetID(new TechId(protein.getDataSetID()));
            dataSetProtein.setDataSetPermID(protein.getDataSetPermID());
            dataSetProtein.setFalseDiscoveryRate(protein.getFalseDiscoveryRate());
            dataSetProtein.setPeptideCount(protein.getPeptideCount());
            dataSetProtein.setProteinID(new TechId(protein.getProteinID()));
            dataSetProtein.setSequenceName(sequenceTable.getShortName(protein.getDatabaseID()));
            this.dataSetProteins.add(dataSetProtein);
        }
        proteins.close();
    }
}

