/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.api.MinimalMinorVersion;
import ch.systemsx.cisd.common.api.retry.RetryCaller;
import ch.systemsx.cisd.common.api.retry.RetryProxyFactory;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.ConcatenatedFileOutputStreamWriter;
import ch.systemsx.cisd.common.multiplexer.ThreadPoolMultiplexer;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DssComponentFactory;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.OpenbisServiceFacade;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetMetadataDTO;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.DssServiceRpcScreeningHolder;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.DssServiceRpcScreeningMultiplexer;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningBatchHandler;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningFactory;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.v1.IDssServiceRpcScreening;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationChangingService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.IDataSetFilter;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.TypeBasedDataSetFilter;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IPlateImageHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.WellImageCache;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.IScreeningApiServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetImageRepresentationFormats;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentImageMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureInformation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorWithDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureVectorDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageRepresentationFormatSelectionCriterion;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellMaterialMapping;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellReferenceWithDatasets;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ScreeningOpenbisServiceFacade
implements IScreeningOpenbisServiceFacade {
    static final int MAJOR_VERSION_AS = 1;
    static final int MAJOR_VERSION_DSS = 1;
    private static final String OPENBIS_SCREENING_API = "/rmi-screening-api-v1";
    static final long SERVER_TIMEOUT_MILLIS = 300000L;
    private static final IDssServiceRpcScreeningFactory DSS_SERVICE_FACTORY = new IDssServiceRpcScreeningFactory(){

        @Override
        public DssServiceRpcScreeningHolder createDssService(String serverUrl) {
            return new DssServiceRpcScreeningHolder(serverUrl, 1, 300000L);
        }
    };
    private final IScreeningApiServer openbisScreeningServer;
    private final IGeneralInformationService generalInformationService;
    private final IGeneralInformationChangingService generalInformationChangingService;
    private final IDssComponent dssComponent;
    private final DssServiceRpcScreeningMultiplexer dssMultiplexer;
    private final String sessionToken;
    private final int minorVersionApplicationServer;
    private final Map<IImageDatasetIdentifier, ImageDatasetMetadata> imageMetadataCache = new ConcurrentHashMap<IImageDatasetIdentifier, ImageDatasetMetadata>();
    private final WellImageCache imageCache = new WellImageCache();
    private IDssServiceRpcScreeningFactory dssServiceCache;
    private final IOpenbisServiceFacade openbisServiceFacade;

    public static IScreeningOpenbisServiceFacade tryCreate(final String userId, final String userPassword, final String serverUrl) {
        RetryCaller<IScreeningOpenbisServiceFacade, RuntimeException> caller = new RetryCaller<IScreeningOpenbisServiceFacade, RuntimeException>(){

            @Override
            protected IScreeningOpenbisServiceFacade call() {
                IScreeningApiServer openbisServer = ScreeningOpenbisServiceFacade.createScreeningOpenbisServer(serverUrl);
                String sessionToken = openbisServer.tryLoginScreening(userId, userPassword);
                if (sessionToken == null) {
                    return null;
                }
                return ScreeningOpenbisServiceFacade.tryCreate(sessionToken, serverUrl, openbisServer, null);
            }
        };
        return (IScreeningOpenbisServiceFacade)caller.callWithRetry();
    }

    public static IScreeningOpenbisServiceFacade tryCreate(String sessionToken, String serverUrl) {
        return ScreeningOpenbisServiceFacade.tryCreate(sessionToken, serverUrl, null);
    }

    public static IScreeningOpenbisServiceFacade tryCreateWithLocalDss(String sessionToken, String serverUrl, IDssServiceRpcScreening localDss) {
        return ScreeningOpenbisServiceFacade.tryCreate(sessionToken, serverUrl, localDss);
    }

    private static IScreeningOpenbisServiceFacade tryCreate(final String sessionToken, final String serverUrl, final IDssServiceRpcScreening localDss) {
        RetryCaller<IScreeningOpenbisServiceFacade, RuntimeException> caller = new RetryCaller<IScreeningOpenbisServiceFacade, RuntimeException>(){

            @Override
            protected IScreeningOpenbisServiceFacade call() {
                return ScreeningOpenbisServiceFacade.tryCreate(sessionToken, serverUrl, ScreeningOpenbisServiceFacade.createScreeningOpenbisServer(serverUrl), localDss);
            }
        };
        return (IScreeningOpenbisServiceFacade)caller.callWithRetry();
    }

    public static IScreeningOpenbisServiceFacade tryCreateForTest(String sessionToken, String serverUrl, IScreeningApiServer openbisServer) {
        return ScreeningOpenbisServiceFacade.tryCreate(sessionToken, serverUrl, openbisServer, null);
    }

    private static IScreeningOpenbisServiceFacade tryCreate(String sessionToken, String serverUrl, IScreeningApiServer openbisServer, IDssServiceRpcScreening localDss) {
        IGeneralInformationService generalInformationService = ScreeningOpenbisServiceFacade.createGeneralInformationService(serverUrl);
        IGeneralInformationChangingService generalInformationChangingService = ScreeningOpenbisServiceFacade.createGeneralInformationChangingService(serverUrl);
        int minorVersion = openbisServer.getMinorVersion();
        IDssComponent dssComponent = DssComponentFactory.tryCreate(sessionToken, serverUrl, 300000L);
        ScreeningOpenbisServiceFacade facade = new ScreeningOpenbisServiceFacade(sessionToken, openbisServer, minorVersion, DSS_SERVICE_FACTORY, dssComponent, generalInformationService, generalInformationChangingService, localDss);
        return RetryProxyFactory.createProxy(facade);
    }

    @Override
    public List<Material> searchForMaterials(SearchCriteria searchCriteria) {
        return this.generalInformationService.searchForMaterials(this.sessionToken, searchCriteria);
    }

    @Override
    public List<Sample> searchForSamples(SearchCriteria searchCriteria) {
        return this.generalInformationService.searchForSamples(this.sessionToken, searchCriteria);
    }

    private static IScreeningApiServer createScreeningOpenbisServer(String serverUrl) {
        ServiceFinder serviceFinder = new ServiceFinder("openbis", OPENBIS_SCREENING_API);
        return serviceFinder.createService(IScreeningApiServer.class, serverUrl);
    }

    private static IGeneralInformationService createGeneralInformationService(String serverUrl) {
        ServiceFinder generalInformationServiceFinder = new ServiceFinder("openbis", "/rmi-general-information-v1");
        IGeneralInformationService service = generalInformationServiceFinder.createService(IGeneralInformationService.class, serverUrl);
        return service;
    }

    private static IGeneralInformationChangingService createGeneralInformationChangingService(String serverUrl) {
        ServiceFinder generalInformationServiceFinder = new ServiceFinder("openbis", "/rmi-general-information-changing-v1");
        IGeneralInformationChangingService service = generalInformationServiceFinder.createService(IGeneralInformationChangingService.class, serverUrl);
        return service;
    }

    ScreeningOpenbisServiceFacade(String sessionToken, IScreeningApiServer screeningServer, int minorVersion, final IDssServiceRpcScreeningFactory dssServiceFactory, IDssComponent dssComponent, IGeneralInformationService generalInformationService, IGeneralInformationChangingService generalInformationChangingService, final IDssServiceRpcScreening localDss) {
        this.openbisScreeningServer = screeningServer;
        this.generalInformationService = generalInformationService;
        this.generalInformationChangingService = generalInformationChangingService;
        this.dssComponent = dssComponent;
        this.sessionToken = sessionToken;
        this.openbisServiceFacade = new OpenbisServiceFacade(sessionToken, generalInformationService, generalInformationChangingService, dssComponent);
        this.minorVersionApplicationServer = minorVersion;
        this.dssServiceCache = localDss != null ? new IDssServiceRpcScreeningFactory(){

            @Override
            public DssServiceRpcScreeningHolder createDssService(String serverUrl) {
                return new DssServiceRpcScreeningHolder(serverUrl, localDss);
            }
        } : new IDssServiceRpcScreeningFactory(){
            private final Map<String, DssServiceRpcScreeningHolder> cache = new HashMap<String, DssServiceRpcScreeningHolder>();

            @Override
            public DssServiceRpcScreeningHolder createDssService(String serverUrl) {
                DssServiceRpcScreeningHolder dssServiceHolder = this.cache.get(serverUrl);
                if (dssServiceHolder == null) {
                    dssServiceHolder = dssServiceFactory.createDssService(serverUrl);
                    this.cache.put(serverUrl, dssServiceHolder);
                }
                return dssServiceHolder;
            }
        };
        ThreadPoolMultiplexer multiplexer = new ThreadPoolMultiplexer("screening-facade-multiplexer");
        this.dssMultiplexer = new DssServiceRpcScreeningMultiplexer(multiplexer, this.dssServiceCache);
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void logout() {
        this.checkASMinimalMinorVersion("logoutScreening", new Class[0]);
        this.openbisScreeningServer.logoutScreening(this.sessionToken);
    }

    @Override
    public void clearWellImageCache() {
        this.imageCache.clear();
    }

    @Override
    public List<Plate> listPlates() {
        this.checkASMinimalMinorVersion("listPlates", new Class[0]);
        return this.openbisScreeningServer.listPlates(this.sessionToken);
    }

    @Override
    public List<PlateMetadata> getPlateMetadataList(List<? extends PlateIdentifier> plateIdentifiers) {
        this.checkASMinimalMinorVersion("getPlateMetadataList", List.class);
        return this.openbisScreeningServer.getPlateMetadataList(this.sessionToken, plateIdentifiers);
    }

    @Override
    public List<Plate> listPlates(ExperimentIdentifier experiment) {
        if (this.hasASMethod("listPlates", ExperimentIdentifier.class)) {
            return this.openbisScreeningServer.listPlates(this.sessionToken, experiment);
        }
        List<Plate> allPlates = this.listPlates();
        ArrayList<Plate> result = new ArrayList<Plate>(allPlates.size());
        for (Plate plate : allPlates) {
            if (!plate.getExperimentIdentifier().getPermId().equals(experiment.getPermId()) && !plate.getExperimentIdentifier().getAugmentedCode().equals(experiment.getAugmentedCode())) continue;
            result.add(plate);
        }
        return result;
    }

    @Override
    public List<Plate> listPlates(ExperimentIdentifier experiment, String analysisProcedure) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.TYPE, "PLATE"));
        SearchCriteria experimentCriteria = new SearchCriteria();
        experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, experiment.getExperimentCode()));
        experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.PROJECT, experiment.getProjectCode()));
        experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.SPACE, experiment.getSpaceCode()));
        searchCriteria.addSubCriteria(SearchSubCriteria.createExperimentCriteria(experimentCriteria));
        List<Sample> samples = this.openbisServiceFacade.searchForSamples(searchCriteria);
        List<DataSet> dataSets = this.openbisServiceFacade.listDataSets(samples, null);
        HashSet<String> sampleIdentifiers = new HashSet<String>();
        for (DataSet dataSet : dataSets) {
            if (!analysisProcedure.equals(dataSet.getProperties().get("$ANALYSIS_PROCEDURE"))) continue;
            sampleIdentifiers.add(dataSet.getSampleIdentifierOrNull());
        }
        ArrayList<Plate> plates = new ArrayList<Plate>();
        for (Sample sample : samples) {
            String sampleIdentifier = sample.getIdentifier();
            if (!sampleIdentifiers.contains(sampleIdentifier)) continue;
            String spaceCode = PlateIdentifier.createFromAugmentedCode(sampleIdentifier).tryGetSpaceCode();
            String permID = sample.getPermId();
            String experimentIdentifierOrNull = sample.getExperimentIdentifierOrNull();
            ExperimentIdentifier expermientIdentifier = experimentIdentifierOrNull == null ? null : ExperimentIdentifier.createFromAugmentedCode(experimentIdentifierOrNull);
            plates.add(new Plate(sample.getCode(), spaceCode, permID, expermientIdentifier));
        }
        return plates;
    }

    @Override
    public List<ExperimentIdentifier> listExperiments() {
        this.checkASMinimalMinorVersion("listExperiments", new Class[0]);
        return this.openbisScreeningServer.listExperiments(this.sessionToken);
    }

    @Override
    public List<ExperimentIdentifier> listExperiments(String userId) {
        this.checkASMinimalMinorVersion("listExperiments", String.class);
        return this.openbisScreeningServer.listExperiments(this.sessionToken, userId);
    }

    @Override
    public List<FeatureVectorDatasetReference> listFeatureVectorDatasets(List<? extends PlateIdentifier> plates) {
        this.checkASMinimalMinorVersion("listFeatureVectorDatasets", List.class);
        return this.openbisScreeningServer.listFeatureVectorDatasets(this.sessionToken, plates);
    }

    @Override
    public List<FeatureVectorDatasetReference> listFeatureVectorDatasets(List<? extends PlateIdentifier> plates, String analysisProcedureOrNull) {
        List<FeatureVectorDatasetReference> dataSets = this.listFeatureVectorDatasets(plates);
        return this.filterByAnalysisProcedure(dataSets, analysisProcedureOrNull);
    }

    private <T extends DatasetReference> List<T> filterByAnalysisProcedure(List<T> dataSets, String analysisProcedureOrNull) {
        if (analysisProcedureOrNull == null) {
            return dataSets;
        }
        ArrayList<DatasetReference> filteredDataSets = new ArrayList<DatasetReference>();
        for (DatasetReference dataSet : dataSets) {
            if (!analysisProcedureOrNull.equals(dataSet.getProperties().get("$ANALYSIS_PROCEDURE"))) continue;
            filteredDataSets.add(dataSet);
        }
        return filteredDataSets;
    }

    @Override
    @Deprecated
    public List<ImageDatasetReference> listImageDatasets(List<? extends PlateIdentifier> plates) {
        this.checkASMinimalMinorVersion("listImageDatasets", List.class);
        return this.openbisScreeningServer.listImageDatasets(this.sessionToken, plates);
    }

    @Override
    public List<ImageDatasetReference> listRawImageDatasets(List<? extends PlateIdentifier> plates) {
        if (this.hasASMethod("listRawImageDatasets", List.class)) {
            return this.openbisScreeningServer.listRawImageDatasets(this.sessionToken, plates);
        }
        this.checkASMinimalMinorVersion("listImageDatasets", List.class);
        return this.openbisScreeningServer.listImageDatasets(this.sessionToken, plates);
    }

    @Override
    public List<ImageDatasetReference> listSegmentationImageDatasets(List<? extends PlateIdentifier> plates) {
        if (this.hasASMethod("listSegmentationImageDatasets", List.class)) {
            return this.openbisScreeningServer.listSegmentationImageDatasets(this.sessionToken, plates);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ImageDatasetReference> listSegmentationImageDatasets(List<? extends PlateIdentifier> plates, String analysisProcedureOrNull) {
        List<ImageDatasetReference> dataSets = this.listSegmentationImageDatasets(plates);
        return this.filterByAnalysisProcedure(dataSets, analysisProcedureOrNull);
    }

    @Override
    public List<PlateWellReferenceWithDatasets> listPlateWells(ExperimentIdentifier experimentIdentifer, MaterialIdentifier materialIdentifier, boolean findDatasets) {
        this.checkASMinimalMinorVersion("listPlateWells", ExperimentIdentifier.class, MaterialIdentifier.class, Boolean.TYPE);
        return this.openbisScreeningServer.listPlateWells(this.sessionToken, experimentIdentifer, materialIdentifier, findDatasets);
    }

    @Override
    public List<PlateWellReferenceWithDatasets> listPlateWells(MaterialIdentifier materialIdentifier, boolean findDatasets) {
        this.checkASMinimalMinorVersion("listPlateWells", MaterialIdentifier.class, Boolean.TYPE);
        return this.openbisScreeningServer.listPlateWells(this.sessionToken, materialIdentifier, findDatasets);
    }

    @Override
    public List<WellIdentifier> listPlateWells(PlateIdentifier plateIdentifier) {
        this.checkASMinimalMinorVersion("listPlateWells", PlateIdentifier.class);
        return this.openbisScreeningServer.listPlateWells(this.sessionToken, plateIdentifier);
    }

    @Override
    public Map<String, String> getPlateProperties(PlateIdentifier plateIdentifier) {
        Sample plateSample = this.openbisScreeningServer.getPlateSample(this.sessionToken, plateIdentifier);
        Map<String, String> properties = plateSample.getProperties();
        return properties;
    }

    @Override
    public void updatePlateProperties(PlateIdentifier plateIdentifier, Map<String, String> properties) {
        Sample plateSample = this.openbisScreeningServer.getPlateSample(this.sessionToken, plateIdentifier);
        this.generalInformationChangingService.updateSampleProperties(this.sessionToken, plateSample.getId(), properties);
    }

    @Override
    public Map<String, String> getWellProperties(WellIdentifier wellIdentifier) {
        Sample wellSample = this.openbisScreeningServer.getWellSample(this.sessionToken, wellIdentifier);
        Map<String, String> properties = wellSample.getProperties();
        return properties;
    }

    @Override
    public void updateWellProperties(WellIdentifier wellIdentifier, Map<String, String> properties) {
        Sample wellSample = this.openbisScreeningServer.getWellSample(this.sessionToken, wellIdentifier);
        this.generalInformationChangingService.updateSampleProperties(this.sessionToken, wellSample.getId(), properties);
    }

    @Override
    public List<IDataSetDss> getDataSets(WellIdentifier wellIdentifier, String datasetTypeCodePattern) throws IllegalStateException, EnvironmentFailureException {
        return this.getDataSets(wellIdentifier, (IDataSetFilter)new TypeBasedDataSetFilter(datasetTypeCodePattern));
    }

    @Override
    public List<IDataSetDss> getDataSets(WellIdentifier wellIdentifier, IDataSetFilter dataSetFilter) throws IllegalStateException, EnvironmentFailureException {
        Sample wellSample = this.getWellSample(wellIdentifier);
        return this.getDataSets(wellSample, dataSetFilter);
    }

    @Override
    public IDataSetDss getDataSet(String dataSetCode) throws IllegalStateException, EnvironmentFailureException {
        return RetryProxyFactory.createProxy(this.dssComponent.getDataSet(dataSetCode));
    }

    @Override
    public List<IDataSetDss> getDataSets(PlateIdentifier plateIdentifier, String datasetTypeCodePattern) throws IllegalStateException, EnvironmentFailureException {
        return this.getDataSets(plateIdentifier, (IDataSetFilter)new TypeBasedDataSetFilter(datasetTypeCodePattern));
    }

    @Override
    public List<IDataSetDss> getDataSets(PlateIdentifier plateIdentifier, IDataSetFilter dataSetFilter) throws IllegalStateException, EnvironmentFailureException {
        this.checkASMinimalMinorVersion("getPlateSample", PlateIdentifier.class);
        Sample sample = this.openbisScreeningServer.getPlateSample(this.sessionToken, plateIdentifier);
        return this.getDataSets(sample, dataSetFilter);
    }

    private List<IDataSetDss> getDataSets(Sample sample, IDataSetFilter filter) {
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> dataSets = this.generalInformationService.listDataSetsForSample(this.sessionToken, sample, true);
        ArrayList<IDataSetDss> result = new ArrayList<IDataSetDss>();
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet : dataSets) {
            if (!filter.pass(dataSet)) continue;
            IDataSetDss dataSetDss = this.dssComponent.getDataSet(dataSet.getCode());
            result.add(RetryProxyFactory.createProxy(dataSetDss));
        }
        return result;
    }

    @Override
    public List<DataSet> getFullDataSets(PlateIdentifier plateIdentifier, IDataSetFilter dataSetFilter) throws IllegalStateException, EnvironmentFailureException {
        this.checkASMinimalMinorVersion("getPlateSample", PlateIdentifier.class);
        Sample sample = this.openbisScreeningServer.getPlateSample(this.sessionToken, plateIdentifier);
        return this.getFullDataSets(sample, dataSetFilter);
    }

    private List<DataSet> getFullDataSets(Sample sample, IDataSetFilter filter) {
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> dataSets = this.generalInformationService.listDataSets(this.sessionToken, Arrays.asList(sample), EnumSet.of(DataSet.Connections.PARENTS));
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet : dataSets) {
            if (!filter.pass(dataSet)) continue;
            DataSet fullDataset = new DataSet(this.openbisServiceFacade, this.dssComponent, dataSet, null);
            result.add(fullDataset);
        }
        return result;
    }

    @Override
    public List<IDataSetDss> getDataSets(ExperimentIdentifier experimentIdentifier, IDataSetFilter filter) {
        List<Experiment> experiments = this.generalInformationService.listExperiments(this.sessionToken, Collections.singletonList(experimentIdentifier.getAugmentedCode()));
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> dataSets = this.generalInformationService.listDataSetsForExperiments(this.sessionToken, experiments, EnumSet.of(DataSet.Connections.PARENTS));
        ArrayList<IDataSetDss> result = new ArrayList<IDataSetDss>();
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet : dataSets) {
            if (!filter.pass(dataSet)) continue;
            IDataSetDss dataSetDss = this.dssComponent.getDataSet(dataSet.getCode());
            result.add(RetryProxyFactory.createProxy(dataSetDss));
        }
        return result;
    }

    @Override
    public List<DataSet> getFullDataSets(ExperimentIdentifier experimentIdentifier, IDataSetFilter dataSetFilter) throws IllegalStateException, EnvironmentFailureException {
        List<Experiment> experiments = this.generalInformationService.listExperiments(this.sessionToken, Collections.singletonList(experimentIdentifier.getAugmentedCode()));
        if (experiments.isEmpty()) {
            throw UserFailureException.fromTemplate("Experiment '%s' does not exist.", experimentIdentifier);
        }
        return this.getFullDataSets(experiments, dataSetFilter);
    }

    private List<DataSet> getFullDataSets(List<Experiment> experiments, IDataSetFilter filter) {
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> dataSets = this.generalInformationService.listDataSetsForExperiments(this.sessionToken, experiments, EnumSet.of(DataSet.Connections.PARENTS));
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet : dataSets) {
            if (!filter.pass(dataSet)) continue;
            DataSet fullDataset = new DataSet(this.openbisServiceFacade, this.dssComponent, dataSet, null);
            result.add(fullDataset);
        }
        return result;
    }

    @Override
    public List<DataSet> getDataSetMetaData(List<String> dataSetCodes) {
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> dataSets = this.generalInformationService.getDataSetMetaData(this.sessionToken, dataSetCodes);
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet : dataSets) {
            DataSet fullDataset = new DataSet(this.openbisServiceFacade, this.dssComponent, dataSet, null);
            result.add(fullDataset);
        }
        return result;
    }

    @Override
    public IDataSetDss putDataSet(WellIdentifier wellIdentifier, File dataSetFile, NewDataSetMetadataDTO dataSetMetadataOrNull) throws IllegalStateException, EnvironmentFailureException, IOException {
        Sample wellSample = this.getWellSample(wellIdentifier);
        return this.createDataSetDss(wellSample, dataSetMetadataOrNull, dataSetFile);
    }

    private Sample getWellSample(WellIdentifier wellIdentifier) {
        this.checkASMinimalMinorVersion("getWellSample", WellIdentifier.class);
        return this.openbisScreeningServer.getWellSample(this.sessionToken, wellIdentifier);
    }

    @Override
    public IDataSetDss putDataSet(PlateIdentifier plateIdentifier, File dataSetFile, NewDataSetMetadataDTO dataSetMetadataOrNull) throws IllegalStateException, EnvironmentFailureException, IOException {
        Sample sample = this.openbisScreeningServer.getPlateSample(this.sessionToken, plateIdentifier);
        return this.createDataSetDss(sample, dataSetMetadataOrNull, dataSetFile);
    }

    @Override
    public IDataSetDss putDataSet(ExperimentIdentifier experimentIdentifier, File dataSetFile, NewDataSetMetadataDTO dataSetMetadataOrNull) throws IllegalStateException, EnvironmentFailureException, IOException {
        NewDataSetDTO.DataSetOwner dataSetOwner = new NewDataSetDTO.DataSetOwner(NewDataSetDTO.DataSetOwnerType.EXPERIMENT, experimentIdentifier.getAugmentedCode());
        NewDataSetMetadataDTO dataSetMetadata = dataSetMetadataOrNull == null ? new NewDataSetMetadataDTO() : dataSetMetadataOrNull;
        return this.createDatasetDss(dataSetMetadata, dataSetFile, dataSetOwner);
    }

    private IDataSetDss createDataSetDss(Sample sample, NewDataSetMetadataDTO dataSetMetadataOrNull, File dataSetFile) throws IOException {
        NewDataSetDTO.DataSetOwner dataSetOwner = new NewDataSetDTO.DataSetOwner(NewDataSetDTO.DataSetOwnerType.SAMPLE, sample.getIdentifier());
        NewDataSetMetadataDTO dataSetMetadata = dataSetMetadataOrNull == null ? new NewDataSetMetadataDTO() : dataSetMetadataOrNull;
        return this.createDatasetDss(dataSetMetadata, dataSetFile, dataSetOwner);
    }

    private IDataSetDss createDatasetDss(NewDataSetMetadataDTO dataSetMetadata, File dataSetFile, NewDataSetDTO.DataSetOwner dataSetOwner) throws IOException {
        String dataSetFolderNameOrNull = dataSetFile.isDirectory() ? dataSetFile.getName() : null;
        List<FileInfoDssDTO> fileInfos = this.getFileInfosForPath(dataSetFile);
        NewDataSetDTO newDataSet = new NewDataSetDTO(dataSetMetadata, dataSetOwner, dataSetFolderNameOrNull, fileInfos);
        IDataSetDss dataSetDss = this.dssComponent.putDataSet(newDataSet, dataSetFile);
        return RetryProxyFactory.createProxy(dataSetDss);
    }

    private List<FileInfoDssDTO> getFileInfosForPath(File file) throws IOException {
        ArrayList<FileInfoDssDTO> fileInfos = new ArrayList<FileInfoDssDTO>();
        if (!file.exists()) {
            return fileInfos;
        }
        String path = file.getCanonicalPath();
        if (!file.isDirectory()) {
            path = file.getParentFile().getCanonicalPath();
        }
        FileInfoDssBuilder builder = new FileInfoDssBuilder(path, path);
        builder.appendFileInfosForFile(file, fileInfos, true);
        return fileInfos;
    }

    @Override
    public List<IDatasetIdentifier> getDatasetIdentifiers(List<String> datasetCodes) {
        this.checkASMinimalMinorVersion("getDatasetIdentifiers", List.class);
        return this.openbisScreeningServer.getDatasetIdentifiers(this.sessionToken, datasetCodes);
    }

    @Override
    public List<String> listAvailableFeatureNames(List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        return this.listAvailableFeatureCodes(featureDatasets);
    }

    @Override
    public List<String> listAvailableFeatureCodes(List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, String> handler = new IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<IFeatureVectorDatasetIdentifier> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "listAvailableFeatureNames", new Class[]{List.class});
                return dssService.getService().listAvailableFeatureNames(ScreeningOpenbisServiceFacade.this.sessionToken, references);
            }
        };
        return this.dssMultiplexer.process(featureDatasets, handler).getMergedBatchResultsWithoutDuplicates();
    }

    @Override
    public List<String> listAvailableFeatureLists(IFeatureVectorDatasetIdentifier featureDataset) {
        IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, String> handler = new IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<IFeatureVectorDatasetIdentifier> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "getFeatureList", new Class[]{IFeatureVectorDatasetIdentifier.class, String.class});
                return dssService.getService().listAvailableFeatureLists(ScreeningOpenbisServiceFacade.this.sessionToken, references.get(0));
            }
        };
        return this.dssMultiplexer.process(Collections.singletonList(featureDataset), handler).getMergedBatchResultsWithoutDuplicates();
    }

    @Override
    public List<String> getFeatureList(IFeatureVectorDatasetIdentifier featureDataset, final String featureListCode) {
        IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, String> handler = new IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<IFeatureVectorDatasetIdentifier> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "getFeatureList", new Class[]{IFeatureVectorDatasetIdentifier.class, String.class});
                return dssService.getService().getFeatureList(ScreeningOpenbisServiceFacade.this.sessionToken, references.get(0), featureListCode);
            }
        };
        return this.dssMultiplexer.process(Collections.singletonList(featureDataset), handler).getMergedBatchResultsWithoutDuplicates();
    }

    @Override
    public List<FeatureInformation> listAvailableFeatures(List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, FeatureInformation> handler = new IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, FeatureInformation>(){

            @Override
            public List<FeatureInformation> handle(DssServiceRpcScreeningHolder dssService, List<IFeatureVectorDatasetIdentifier> references) {
                if (ScreeningOpenbisServiceFacade.this.hasDSSMethod(dssService, "listAvailableFeatures", new Class[]{List.class})) {
                    return dssService.getService().listAvailableFeatures(ScreeningOpenbisServiceFacade.this.sessionToken, references);
                }
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "listAvailableFeatureNames", new Class[]{List.class});
                ArrayList<FeatureInformation> result = new ArrayList<FeatureInformation>();
                List<String> codes = dssService.getService().listAvailableFeatureNames(ScreeningOpenbisServiceFacade.this.sessionToken, references);
                for (String code : codes) {
                    result.add(new FeatureInformation(code, code, ""));
                }
                return result;
            }
        };
        return this.dssMultiplexer.process(featureDatasets, handler).getMergedBatchResultsWithoutDuplicates();
    }

    @Override
    public List<FeatureVectorDataset> loadFeaturesForPlates(List<? extends PlateIdentifier> plates, List<String> featureCodesOrNull) {
        List<FeatureVectorDatasetReference> datasets = this.listFeatureVectorDatasets(plates);
        return this.loadFeatures(datasets, featureCodesOrNull);
    }

    @Override
    public List<FeatureVectorDataset> loadFeaturesForPlates(List<? extends PlateIdentifier> plates, List<String> featureCodesOrNull, String analysisProcedureOrNull) {
        List<FeatureVectorDatasetReference> datasets = this.listFeatureVectorDatasets(plates, analysisProcedureOrNull);
        return this.loadFeatures(datasets, featureCodesOrNull);
    }

    @Override
    public List<FeatureVectorDataset> loadFeatures(List<FeatureVectorDatasetReference> featureDatasets, List<String> featureCodesOrNull) {
        final List<String> featureNames = this.isEmpty(featureCodesOrNull) ? this.listAvailableFeatureNames(featureDatasets) : featureCodesOrNull;
        IDssServiceRpcScreeningBatchHandler<FeatureVectorDatasetReference, FeatureVectorDataset> handler = new IDssServiceRpcScreeningBatchHandler<FeatureVectorDatasetReference, FeatureVectorDataset>(){

            @Override
            public List<FeatureVectorDataset> handle(DssServiceRpcScreeningHolder dssService, List<FeatureVectorDatasetReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadFeatures", new Class[]{List.class, List.class});
                return dssService.getService().loadFeatures(ScreeningOpenbisServiceFacade.this.sessionToken, references, featureNames);
            }
        };
        return this.dssMultiplexer.process(featureDatasets, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    public List<FeatureVectorDatasetWellReference> convertToFeatureVectorDatasetWellIdentifier(List<PlateWellReferenceWithDatasets> plateWellReferenceWithDataSets) {
        ArrayList<FeatureVectorDatasetWellReference> result = new ArrayList<FeatureVectorDatasetWellReference>(plateWellReferenceWithDataSets.size());
        for (PlateWellReferenceWithDatasets plateWellRef : plateWellReferenceWithDataSets) {
            for (FeatureVectorDatasetReference fvdr : plateWellRef.getFeatureVectorDatasetReferences()) {
                result.add(this.createFVDatasetReference(fvdr, plateWellRef.getWellPosition()));
            }
        }
        return result;
    }

    private FeatureVectorDatasetWellReference createFVDatasetReference(FeatureVectorDatasetReference fvdr, WellPosition wellPosition) {
        return new FeatureVectorDatasetWellReference(fvdr.getDatasetCode(), fvdr.getDataSetType(), fvdr.getDatastoreServerUrl(), fvdr.getPlate(), fvdr.getExperimentIdentifier(), fvdr.getPlateGeometry(), fvdr.getRegistrationDate(), fvdr.getParentImageDataset(), fvdr.getProperties(), wellPosition);
    }

    @Override
    public List<FeatureVectorWithDescription> loadFeaturesForDatasetWellReferences(List<FeatureVectorDatasetWellReference> datasetWellReferences, List<String> featureCodesOrNull) {
        final List<String> featureNames = this.isEmpty(featureCodesOrNull) ? this.listAvailableFeatureNames(datasetWellReferences) : featureCodesOrNull;
        IDssServiceRpcScreeningBatchHandler<FeatureVectorDatasetWellReference, FeatureVectorWithDescription> handler = new IDssServiceRpcScreeningBatchHandler<FeatureVectorDatasetWellReference, FeatureVectorWithDescription>(){

            @Override
            public List<FeatureVectorWithDescription> handle(DssServiceRpcScreeningHolder dssService, List<FeatureVectorDatasetWellReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadFeaturesForDatasetWellReferences", new Class[]{List.class, List.class});
                return dssService.getService().loadFeaturesForDatasetWellReferences(ScreeningOpenbisServiceFacade.this.sessionToken, references, featureNames);
            }
        };
        return this.dssMultiplexer.process(datasetWellReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    private boolean isEmpty(List<String> featureCodeOrNull) {
        return featureCodeOrNull == null || featureCodeOrNull.isEmpty();
    }

    @Override
    public List<FeatureVectorWithDescription> loadFeaturesForPlateWells(ExperimentIdentifier experimentIdentifer, MaterialIdentifier materialIdentifier, List<String> featureCodesOrNull) {
        return this.loadFeaturesForPlateWells(experimentIdentifer, materialIdentifier, null, featureCodesOrNull);
    }

    @Override
    public List<FeatureVectorWithDescription> loadFeaturesForPlateWells(ExperimentIdentifier experimentIdentifer, MaterialIdentifier materialIdentifier, String analysisProcedureOrNull, List<String> featureCodesOrNull) {
        List<PlateWellReferenceWithDatasets> plateWellRefs = this.listPlateWells(experimentIdentifer, materialIdentifier, true);
        return this.loadFeatureVectors(featureCodesOrNull, analysisProcedureOrNull, plateWellRefs);
    }

    @Override
    public List<FeatureVectorWithDescription> loadFeaturesForPlateWells(MaterialIdentifier materialIdentifier, List<String> featureCodesOrNull) {
        return this.loadFeaturesForPlateWells(materialIdentifier, null, featureCodesOrNull);
    }

    @Override
    public List<FeatureVectorWithDescription> loadFeaturesForPlateWells(MaterialIdentifier materialIdentifier, String analysisProcedureOrNull, List<String> featureCodesOrNull) {
        List<PlateWellReferenceWithDatasets> plateWellRefs = this.listPlateWells(materialIdentifier, true);
        return this.loadFeatureVectors(featureCodesOrNull, analysisProcedureOrNull, plateWellRefs);
    }

    private List<FeatureVectorWithDescription> loadFeatureVectors(List<String> featureCodesOrNull, String analysisProcedureOrNull, List<PlateWellReferenceWithDatasets> plateWellRefs) {
        List<String> featureCodes = this.isEmpty(featureCodesOrNull) ? this.listAvailableFeatureCodesForPlateWells(plateWellRefs) : featureCodesOrNull;
        List<FeatureVectorDatasetWellReference> datasetWellReferences = this.filterByAnalysisProcedure(this.convertToFeatureVectorDatasetWellIdentifier(plateWellRefs), analysisProcedureOrNull);
        List<FeatureVectorWithDescription> featureVectors = this.loadFeaturesForDatasetWellReferences(datasetWellReferences, featureCodes);
        return featureVectors;
    }

    private List<String> listAvailableFeatureCodesForPlateWells(List<PlateWellReferenceWithDatasets> plateWellRefs) {
        ArrayList<FeatureVectorDatasetReference> featureVectorDatasetReferences = new ArrayList<FeatureVectorDatasetReference>(plateWellRefs.size());
        for (PlateWellReferenceWithDatasets plateWellRef : plateWellRefs) {
            featureVectorDatasetReferences.addAll(plateWellRef.getFeatureVectorDatasetReferences());
        }
        List<String> availableFeatureCodes = this.listAvailableFeatureCodes(featureVectorDatasetReferences);
        return availableFeatureCodes;
    }

    @Override
    public List<WellPosition> convertToWellPositions(List<WellIdentifier> wellIds) {
        ArrayList<WellPosition> result = new ArrayList<WellPosition>(wellIds.size());
        for (WellIdentifier id : wellIds) {
            result.add(id.getWellPosition());
        }
        return result;
    }

    @Override
    public List<PlateImageReference> createPlateImageReferences(ImageDatasetReference imageDatasetRef) {
        return this.createPlateImageReferences(imageDatasetRef, null, null, null);
    }

    @Override
    public List<PlateImageReference> createPlateImageReferences(ImageDatasetReference imageDatasetRef, List<String> channelCodesOrNull, List<WellPosition> wellsOrNull) {
        return this.createPlateImageReferences(imageDatasetRef, null, channelCodesOrNull, wellsOrNull);
    }

    @Override
    public List<PlateImageReference> createPlateImageReferences(ImageDatasetReference imageDatasetRef, ImageDatasetMetadata metadataOrNull, List<String> channelCodesOrNull, List<WellPosition> wellsOrNull) {
        List<WellPosition> wellsToUse = wellsOrNull == null || wellsOrNull.isEmpty() ? this.createWellPositions(imageDatasetRef.getPlateGeometry()) : wellsOrNull;
        return this.createPlateImageReferences((IImageDatasetIdentifier)imageDatasetRef, metadataOrNull, channelCodesOrNull, wellsToUse);
    }

    @Override
    public List<PlateImageReference> createPlateImageReferences(IImageDatasetIdentifier imageDatasetId, List<String> channeldCodesOrNull, List<WellPosition> wellsToUse) {
        return this.createPlateImageReferences(imageDatasetId, null, channeldCodesOrNull, wellsToUse);
    }

    @Override
    public List<PlateImageReference> createPlateImageReferences(IImageDatasetIdentifier imageDatasetId, ImageDatasetMetadata metadataOrNull, List<String> channelCodesOrNull, List<WellPosition> wellsToUse) {
        ImageDatasetMetadata metadata = this.getImageMetadata(imageDatasetId, metadataOrNull);
        List<String> channelsToUse = channelCodesOrNull == null || channelCodesOrNull.isEmpty() ? metadata.getChannelCodes() : channelCodesOrNull;
        ArrayList<PlateImageReference> result = new ArrayList<PlateImageReference>(wellsToUse.size() * metadata.getNumberOfChannels() * metadata.getNumberOfTiles());
        for (WellPosition well : wellsToUse) {
            for (String channel : channelsToUse) {
                int tile = 0;
                while (tile < metadata.getNumberOfTiles()) {
                    result.add(new PlateImageReference(tile, channel, well, metadata.getImageDataset()));
                    ++tile;
                }
            }
        }
        return result;
    }

    private ImageDatasetMetadata getImageMetadata(IImageDatasetIdentifier imageDatasetRef, ImageDatasetMetadata metadataOrNull) {
        if (metadataOrNull != null) {
            return metadataOrNull;
        }
        return this.listImageMetadata(imageDatasetRef);
    }

    private List<WellPosition> createWellPositions(Geometry plateGeometry) {
        ArrayList<WellPosition> result = new ArrayList<WellPosition>(plateGeometry.getNumberOfRows() * plateGeometry.getNumberOfColumns());
        int row = 1;
        while (row <= plateGeometry.getNumberOfRows()) {
            int col = 1;
            while (col <= plateGeometry.getNumberOfColumns()) {
                result.add(new WellPosition(row, col));
                ++col;
            }
            ++row;
        }
        return result;
    }

    @Override
    public void loadImages(List<PlateImageReference> imageReferences, IImageOutputStreamProvider outputStreamProvider) throws IOException {
        this.loadImages(imageReferences, outputStreamProvider, true);
    }

    @Override
    public void loadImages(List<PlateImageReference> imageReferences, final IImageOutputStreamProvider outputStreamProvider, final boolean convertToPNG) throws IOException {
        try {
            IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

                @Override
                public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                    InputStream stream;
                    if (ScreeningOpenbisServiceFacade.this.hasDSSMethod(dssService, "loadImages", new Class[]{List.class, Boolean.TYPE})) {
                        stream = dssService.getService().loadImages(ScreeningOpenbisServiceFacade.this.sessionToken, references, convertToPNG);
                    } else {
                        ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadImages", new Class[]{List.class});
                        stream = dssService.getService().loadImages(ScreeningOpenbisServiceFacade.this.sessionToken, references);
                    }
                    try {
                        try {
                            ConcatenatedFileOutputStreamWriter imagesWriter = new ConcatenatedFileOutputStreamWriter(stream);
                            for (PlateImageReference imageRef : references) {
                                OutputStream output = outputStreamProvider.getOutputStream(imageRef);
                                imagesWriter.writeNextBlock(output);
                            }
                        }
                        catch (IOException ex) {
                            throw new WrappedIOException(ex);
                        }
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException ex) {
                            throw new WrappedIOException(ex);
                        }
                    }
                    return null;
                }
            };
            this.dssMultiplexer.process(imageReferences, handler);
        }
        catch (WrappedIOException ex) {
            throw ex.getIoException();
        }
    }

    @Override
    public void loadImages(final List<PlateImageReference> imageReferences, final boolean convertToPNG, final IPlateImageHandler plateImageHandler) throws IOException {
        try {
            IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

                @Override
                public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                    InputStream stream;
                    if (ScreeningOpenbisServiceFacade.this.hasDSSMethod(dssService, "loadImages", new Class[]{List.class, Boolean.TYPE})) {
                        stream = dssService.getService().loadImages(ScreeningOpenbisServiceFacade.this.sessionToken, references, convertToPNG);
                    } else {
                        ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadImages", new Class[]{List.class});
                        stream = dssService.getService().loadImages(ScreeningOpenbisServiceFacade.this.sessionToken, references);
                    }
                    ScreeningOpenbisServiceFacade.this.processImagesStreamUnchecked(plateImageHandler, imageReferences, stream);
                    return null;
                }
            };
            this.dssMultiplexer.process(imageReferences, handler);
        }
        catch (WrappedIOException ex) {
            throw ex.getIoException();
        }
    }

    @Override
    public List<byte[]> loadImages(IDatasetIdentifier dataSetIdentifier, List<WellPosition> wellPositions, String channel, ImageSize thumbnailSizeOrNull) throws IOException {
        long size;
        DssServiceRpcScreeningHolder dssServiceHolder = this.dssServiceCache.createDssService(dataSetIdentifier.getDatastoreServerUrl());
        InputStream stream = dssServiceHolder.getService().loadImages(this.sessionToken, dataSetIdentifier, wellPositions, channel, thumbnailSizeOrNull);
        ConcatenatedFileOutputStreamWriter imagesWriter = new ConcatenatedFileOutputStreamWriter(stream);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        do {
            ByteArrayOutputStream outputStream;
            if ((size = imagesWriter.writeNextBlock(outputStream = new ByteArrayOutputStream())) <= 0L) continue;
            result.add(outputStream.toByteArray());
        } while (size >= 0L);
        return result;
    }

    @Override
    public void loadImages(IDatasetIdentifier dataSetIdentifier, List<WellPosition> wellPositions, String channel, ImageSize thumbnailSizeOrNull, IPlateImageHandler plateImageHandler) throws IOException {
        DssServiceRpcScreeningHolder dssServiceHolder = this.dssServiceCache.createDssService(dataSetIdentifier.getDatastoreServerUrl());
        IDssServiceRpcScreening service = dssServiceHolder.getService();
        this.checkDSSMinimalMinorVersion(dssServiceHolder, "listPlateImageReferences", IDatasetIdentifier.class, List.class, String.class);
        List<PlateImageReference> plateImageReferences = service.listPlateImageReferences(this.sessionToken, dataSetIdentifier, wellPositions, channel);
        this.checkDSSMinimalMinorVersion(dssServiceHolder, "loadImages", List.class, ImageSize.class);
        InputStream stream = service.loadImages(this.sessionToken, plateImageReferences, thumbnailSizeOrNull);
        this.processImagesStream(plateImageHandler, plateImageReferences, stream);
    }

    @Override
    public byte[] loadImageWellCaching(PlateImageReference imageReference, ImageSize imageSizeOrNull) throws IOException {
        WellImageCache.CachedImage imageOrNull;
        ImageDatasetReference imageDatasetId;
        ImageDatasetMetadata imageMetadata;
        ImageSize size = imageSizeOrNull == null ? new ImageSize(imageMetadata.getWidth(), imageMetadata.getHeight()) : imageSizeOrNull;
        final WellImageCache.WellImages images = this.imageCache.getWellImages(imageReference, size, imageMetadata = this.listImageMetadata(imageDatasetId = new ImageDatasetReference(imageReference.getDatasetCode(), null, imageReference.getDatastoreServerUrl(), null, null, null, null, null, null)));
        if (images.isLoaderCall()) {
            try {
                List<PlateImageReference> imageReferences = this.createPlateImageReferences((IImageDatasetIdentifier)imageDatasetId, imageMetadata, null, Collections.singletonList(imageReference.getWellPosition()));
                this.loadImages(imageReferences, imageSizeOrNull, new IPlateImageHandler(){

                    @Override
                    public void handlePlateImage(PlateImageReference plateImageReference, byte[] imageFileBytes) {
                        images.putImage(plateImageReference, imageFileBytes);
                    }
                });
            }
            catch (IOException ex) {
                images.cancel(ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                images.cancel(ex);
                throw ex;
            }
        }
        if ((imageOrNull = images.getImage(imageReference)) == null) {
            throw new IOException(imageReference + " doesn't exist.");
        }
        return imageOrNull.getImageData();
    }

    @Override
    public void loadImages(List<PlateImageReference> imageReferences, final ImageSize sizeOrNull, final IPlateImageHandler plateImageHandler) throws IOException {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

            @Override
            public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadImages", new Class[]{List.class, ImageSize.class});
                InputStream stream = dssService.getService().loadImages(ScreeningOpenbisServiceFacade.this.sessionToken, references, sizeOrNull);
                ScreeningOpenbisServiceFacade.this.processImagesStreamUnchecked(plateImageHandler, references, stream);
                return null;
            }
        };
        this.dssMultiplexer.process(imageReferences, handler);
    }

    @Override
    public byte[] loadThumbnailImageWellCaching(PlateImageReference imageReference) throws IOException {
        WellImageCache.CachedImage imageOrNull;
        ImageDatasetReference imageDatasetId = new ImageDatasetReference(imageReference.getDatasetCode(), null, imageReference.getDatastoreServerUrl(), null, null, null, null, null, null);
        ImageDatasetMetadata imageMetadata = this.listImageMetadata(imageDatasetId);
        if (!imageMetadata.hasThumbnails()) {
            String error = String.format("No thumbnail images for data set '%s' have been found on the server", imageMetadata.getImageDataset().getDatasetCode());
            throw new RuntimeException(error);
        }
        final WellImageCache.WellImages images = this.imageCache.getWellImages(imageReference, new ImageSize(imageMetadata.getThumbnailWidth(), imageMetadata.getThumbnailHeight()), imageMetadata);
        if (images.isLoaderCall()) {
            try {
                List<PlateImageReference> imageReferences = this.createPlateImageReferences((IImageDatasetIdentifier)imageDatasetId, imageMetadata, null, Collections.singletonList(imageReference.getWellPosition()));
                this.loadThumbnailImages(imageReferences, new IPlateImageHandler(){

                    @Override
                    public void handlePlateImage(PlateImageReference plateImageReference, byte[] imageFileBytes) {
                        images.putImage(plateImageReference, imageFileBytes);
                    }
                });
            }
            catch (IOException ex) {
                images.cancel(ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                images.cancel(ex);
                throw ex;
            }
        }
        if ((imageOrNull = images.getImage(imageReference)) == null) {
            throw new IOException(imageReference + " doesn't exist.");
        }
        return imageOrNull.getImageData();
    }

    @Override
    public void loadThumbnailImages(List<PlateImageReference> imageReferences, final IPlateImageHandler plateImageHandler) throws IOException {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

            @Override
            public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadThumbnailImages", new Class[]{List.class});
                InputStream stream = dssService.getService().loadThumbnailImages(ScreeningOpenbisServiceFacade.this.sessionToken, references);
                ScreeningOpenbisServiceFacade.this.processImagesStreamUnchecked(plateImageHandler, references, stream);
                return null;
            }
        };
        this.dssMultiplexer.process(imageReferences, handler);
    }

    @Override
    public void loadThumbnailImages(List<PlateImageReference> imageReferences, final IImageOutputStreamProvider outputStreamProvider) throws IOException {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

            @Override
            public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadThumbnailImages", new Class[]{List.class});
                InputStream stream = dssService.getService().loadThumbnailImages(ScreeningOpenbisServiceFacade.this.sessionToken, references);
                try {
                    try {
                        ConcatenatedFileOutputStreamWriter imagesWriter = new ConcatenatedFileOutputStreamWriter(stream);
                        for (PlateImageReference imageRef : references) {
                            OutputStream output = outputStreamProvider.getOutputStream(imageRef);
                            imagesWriter.writeNextBlock(output);
                        }
                    }
                    catch (IOException ex) {
                        throw new WrappedIOException(ex);
                    }
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        throw new WrappedIOException(ex);
                    }
                }
                return null;
            }
        };
        this.dssMultiplexer.process(imageReferences, handler);
    }

    @Override
    public void loadPhysicalThumbnails(List<PlateImageReference> imageReferences, final ImageRepresentationFormat format, final IPlateImageHandler plateImageHandler) throws IOException {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

            @Override
            public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadPhysicalThumbnails", new Class[]{List.class, ImageRepresentationFormat.class});
                InputStream stream = dssService.getService().loadPhysicalThumbnails(ScreeningOpenbisServiceFacade.this.sessionToken, references, format);
                ScreeningOpenbisServiceFacade.this.processImagesStreamUnchecked(plateImageHandler, references, stream);
                return null;
            }
        };
        this.dssMultiplexer.process(imageReferences, handler);
    }

    @Override
    public void loadPhysicalThumbnails(List<PlateImageReference> imageReferences, final ImageRepresentationFormat format, final IImageOutputStreamProvider outputStreamProvider) throws IOException {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

            @Override
            public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadPhysicalThumbnails", new Class[]{List.class, ImageRepresentationFormat.class});
                InputStream stream = dssService.getService().loadPhysicalThumbnails(ScreeningOpenbisServiceFacade.this.sessionToken, references, format);
                try {
                    try {
                        ConcatenatedFileOutputStreamWriter imagesWriter = new ConcatenatedFileOutputStreamWriter(stream);
                        for (PlateImageReference imageRef : references) {
                            OutputStream output = outputStreamProvider.getOutputStream(imageRef);
                            imagesWriter.writeNextBlock(output);
                        }
                    }
                    catch (IOException ex) {
                        throw new WrappedIOException(ex);
                    }
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        throw new WrappedIOException(ex);
                    }
                }
                return null;
            }
        };
        this.dssMultiplexer.process(imageReferences, handler);
    }

    @Override
    public void saveImageTransformerFactory(List<IDatasetIdentifier> dataSetIdentifiers, String channel, IImageTransformerFactory transformerFactoryOrNull) {
        Map<String, List<IDatasetIdentifier>> map = DssServiceRpcScreeningMultiplexer.getReferencesPerDataStore(dataSetIdentifiers);
        Set<Map.Entry<String, List<IDatasetIdentifier>>> entrySet = map.entrySet();
        for (Map.Entry<String, List<IDatasetIdentifier>> entry : entrySet) {
            String serverUrl = entry.getKey();
            IDssServiceRpcScreening service = this.dssServiceCache.createDssService(serverUrl).getService();
            service.saveImageTransformerFactory(this.sessionToken, entry.getValue(), channel, transformerFactoryOrNull);
        }
    }

    @Override
    public IImageTransformerFactory getImageTransformerFactoryOrNull(List<IDatasetIdentifier> dataSetIdentifiers, String channel) {
        Map<String, List<IDatasetIdentifier>> map = DssServiceRpcScreeningMultiplexer.getReferencesPerDataStore(dataSetIdentifiers);
        Set<Map.Entry<String, List<IDatasetIdentifier>>> entrySet = map.entrySet();
        if (entrySet.size() != 1) {
            throw new IllegalArgumentException("Only one data store expected instead of " + map.keySet());
        }
        Map.Entry<String, List<IDatasetIdentifier>> entry = entrySet.iterator().next();
        IDssServiceRpcScreening service = this.dssServiceCache.createDssService(entry.getKey()).getService();
        return service.getImageTransformerFactoryOrNull(this.sessionToken, dataSetIdentifiers, channel);
    }

    @Override
    public ImageDatasetMetadata listImageMetadata(IImageDatasetIdentifier imageDataset) {
        List<ImageDatasetMetadata> metadataList = this.listImageMetadata(Collections.singletonList(imageDataset));
        if (metadataList.isEmpty()) {
            throw new IllegalArgumentException("Cannot find metadata for image data set '" + imageDataset + "'.");
        }
        return metadataList.get(0);
    }

    @Override
    public List<ImageDatasetMetadata> listImageMetadata(List<? extends IImageDatasetIdentifier> imageDatasets) {
        IDssServiceRpcScreeningBatchHandler<IImageDatasetIdentifier, ImageDatasetMetadata> handler = new IDssServiceRpcScreeningBatchHandler<IImageDatasetIdentifier, ImageDatasetMetadata>(){

            @Override
            public List<ImageDatasetMetadata> handle(DssServiceRpcScreeningHolder dssService, List<IImageDatasetIdentifier> references) {
                ArrayList<ImageDatasetMetadata> result = new ArrayList<ImageDatasetMetadata>();
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "listImageMetadata", new Class[]{List.class});
                Iterator<IImageDatasetIdentifier> it = references.iterator();
                while (it.hasNext()) {
                    IImageDatasetIdentifier ref = it.next();
                    ImageDatasetMetadata cached = (ImageDatasetMetadata)ScreeningOpenbisServiceFacade.this.imageMetadataCache.get(ref);
                    if (cached == null) continue;
                    result.add(cached);
                    it.remove();
                }
                if (references.isEmpty()) {
                    return result;
                }
                List<ImageDatasetMetadata> metadata = dssService.getService().listImageMetadata(ScreeningOpenbisServiceFacade.this.sessionToken, references);
                for (ImageDatasetMetadata md : metadata) {
                    ScreeningOpenbisServiceFacade.this.imageMetadataCache.put(md.getImageDataset(), md);
                }
                result.addAll(metadata);
                return result;
            }
        };
        return this.dssMultiplexer.process(imageDatasets, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    public List<PlateWellMaterialMapping> listPlateMaterialMapping(List<? extends PlateIdentifier> plates, MaterialTypeIdentifier materialTypeIdentifierOrNull) {
        return this.openbisScreeningServer.listPlateMaterialMapping(this.sessionToken, plates, materialTypeIdentifierOrNull);
    }

    @Override
    public List<String> listAnalysisProcedures(ExperimentIdentifier experimentIdentifier) {
        SearchCriteria searchCriteria = new SearchCriteria();
        SearchCriteria experimentCriteria = new SearchCriteria();
        experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, experimentIdentifier.getExperimentCode()));
        experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.PROJECT, experimentIdentifier.getProjectCode()));
        experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.SPACE, experimentIdentifier.getSpaceCode()));
        searchCriteria.addSubCriteria(SearchSubCriteria.createExperimentCriteria(experimentCriteria));
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> dataSets = this.generalInformationService.searchForDataSets(this.sessionToken, searchCriteria);
        HashSet<String> procedures = new HashSet<String>();
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet : dataSets) {
            HashMap<String, String> properties = dataSet.getProperties();
            String analysisProcedure = properties.get("$ANALYSIS_PROCEDURE");
            if (analysisProcedure == null) continue;
            procedures.add(analysisProcedure);
        }
        ArrayList<String> result = new ArrayList<String>(procedures);
        Collections.sort(result);
        return result;
    }

    private void checkDSSMinimalMinorVersion(DssServiceRpcScreeningHolder serviceHolder, String methodName, Class<?> ... parameterTypes) {
        int minimalMinorVersion = ScreeningOpenbisServiceFacade.getMinimalMinorVersion(IDssServiceRpcScreening.class, methodName, parameterTypes);
        if (!this.hasDSSMethod(serviceHolder, methodName, parameterTypes)) {
            String paramString = Arrays.asList(parameterTypes).toString();
            throw new UnsupportedOperationException(String.format("Method '%s(%s)' requires minor version %d, but server '%s' has only minor version %d.", methodName, paramString.substring(1, paramString.length() - 1), minimalMinorVersion, serviceHolder.getServerUrl(), serviceHolder.getMinorVersion()));
        }
    }

    private void checkASMinimalMinorVersion(String methodName, Class<?> ... parameterTypes) {
        int minimalMinorVersion = ScreeningOpenbisServiceFacade.getMinimalMinorVersion(IScreeningApiServer.class, methodName, parameterTypes);
        if (this.minorVersionApplicationServer < minimalMinorVersion) {
            String paramString = Arrays.asList(parameterTypes).toString();
            throw new UnsupportedOperationException(String.format("Method '%s(%s)' requires minor version %d, but server has only minor version %d.", methodName, paramString.substring(1, paramString.length() - 1), minimalMinorVersion, this.minorVersionApplicationServer));
        }
    }

    private boolean hasDSSMethod(DssServiceRpcScreeningHolder serviceHolder, String methodName, Class<?> ... parameterTypes) {
        int minimalMinorVersion = ScreeningOpenbisServiceFacade.getMinimalMinorVersion(IDssServiceRpcScreening.class, methodName, parameterTypes);
        return serviceHolder.getMinorVersion() >= minimalMinorVersion;
    }

    private boolean hasASMethod(String methodName, Class<?> ... parameterTypes) {
        int minimalMinorVersion = ScreeningOpenbisServiceFacade.getMinimalMinorVersion(IScreeningApiServer.class, methodName, parameterTypes);
        return this.minorVersionApplicationServer >= minimalMinorVersion;
    }

    private static int getMinimalMinorVersion(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method method;
        assert (clazz != null) : "Unspecified class.";
        assert (methodName != null) : "Unspecified method name.";
        Class[] actualParameterTypes = new Class[parameterTypes.length + 1];
        actualParameterTypes[0] = String.class;
        System.arraycopy(parameterTypes, 0, actualParameterTypes, 1, parameterTypes.length);
        try {
            method = clazz.getMethod(methodName, actualParameterTypes);
        }
        catch (Exception ex) {
            throw new Error("Method not found.", ex);
        }
        MinimalMinorVersion minimalMinorVersion = method.getAnnotation(MinimalMinorVersion.class);
        if (minimalMinorVersion == null) {
            return 0;
        }
        return minimalMinorVersion.value();
    }

    @Override
    public void loadImages(List<PlateImageReference> imageReferences, final LoadImageConfiguration configuration, final IPlateImageHandler plateImageHandler) throws IOException {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

            @Override
            public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadImages", new Class[]{List.class, LoadImageConfiguration.class});
                InputStream stream = dssService.getService().loadImages(ScreeningOpenbisServiceFacade.this.sessionToken, references, configuration);
                ScreeningOpenbisServiceFacade.this.processImagesStreamUnchecked(plateImageHandler, references, stream);
                return null;
            }
        };
        this.dssMultiplexer.process(imageReferences, handler);
    }

    @Override
    public void loadImages(List<PlateImageReference> imageReferences, final IPlateImageHandler plateImageHandler, final ImageRepresentationFormat format) throws IOException {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

            @Override
            public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadImages", new Class[]{List.class, ImageRepresentationFormat.class});
                InputStream stream = dssService.getService().loadImages(ScreeningOpenbisServiceFacade.this.sessionToken, references, format);
                ScreeningOpenbisServiceFacade.this.processImagesStreamUnchecked(plateImageHandler, references, stream);
                return null;
            }
        };
        this.dssMultiplexer.process(imageReferences, handler);
    }

    @Override
    public void loadImages(List<PlateImageReference> imageReferences, final IPlateImageHandler plateImageHandler, final IImageRepresentationFormatSelectionCriterion ... criteria) throws IOException {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, Void>(){

            @Override
            public List<Void> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                ScreeningOpenbisServiceFacade.this.checkDSSMinimalMinorVersion(dssService, "loadImages", new Class[]{List.class, IImageRepresentationFormatSelectionCriterion[].class});
                InputStream stream = dssService.getService().loadImages(ScreeningOpenbisServiceFacade.this.sessionToken, references, criteria);
                ScreeningOpenbisServiceFacade.this.processImagesStreamUnchecked(plateImageHandler, references, stream);
                return null;
            }
        };
        this.dssMultiplexer.process(imageReferences, handler);
    }

    private void processImagesStreamUnchecked(IPlateImageHandler plateImageHandler, List<PlateImageReference> references, InputStream stream) {
        try {
            try {
                this.processImagesStream(plateImageHandler, references, stream);
            }
            catch (IOException ex) {
                throw new WrappedIOException(ex);
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new WrappedIOException(ex);
            }
        }
    }

    private void processImagesStream(IPlateImageHandler plateImageHandler, List<PlateImageReference> references, InputStream stream) throws IOException {
        long size;
        ConcatenatedFileOutputStreamWriter imagesWriter = new ConcatenatedFileOutputStreamWriter(stream);
        int index = 0;
        do {
            ByteArrayOutputStream outputStream;
            if ((size = imagesWriter.writeNextBlock(outputStream = new ByteArrayOutputStream())) >= 0L) {
                plateImageHandler.handlePlateImage(references.get(index), outputStream.toByteArray());
            }
            ++index;
        } while (size >= 0L);
    }

    @Override
    public ExperimentImageMetadata getExperimentImageMetadata(ExperimentIdentifier experimentIdentifier) {
        this.checkASMinimalMinorVersion("getExperimentImageMetadata", ExperimentIdentifier.class);
        return this.openbisScreeningServer.getExperimentImageMetadata(this.sessionToken, experimentIdentifier);
    }

    @Override
    public List<DatasetImageRepresentationFormats> listAvailableImageRepresentationFormats(List<? extends IDatasetIdentifier> dataSetIdentifiers) {
        ArrayList<IDatasetIdentifier> simplerList = new ArrayList<IDatasetIdentifier>(dataSetIdentifiers.size());
        simplerList.addAll(dataSetIdentifiers);
        Map<String, List<IDatasetIdentifier>> map = DssServiceRpcScreeningMultiplexer.getReferencesPerDataStore(simplerList);
        Set<Map.Entry<String, List<IDatasetIdentifier>>> entrySet = map.entrySet();
        if (entrySet.size() != 1) {
            throw new IllegalArgumentException("Only one data store expected instead of " + map.keySet());
        }
        Map.Entry<String, List<IDatasetIdentifier>> entry = entrySet.iterator().next();
        IDssServiceRpcScreening service = this.dssServiceCache.createDssService(entry.getKey()).getService();
        return service.listAvailableImageRepresentationFormats(this.sessionToken, dataSetIdentifiers);
    }

    public static interface IImageOutputStreamProvider {
        public OutputStream getOutputStream(PlateImageReference var1) throws IOException;
    }

    private static final class WrappedIOException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final IOException ioException;

        WrappedIOException(IOException cause) {
            super(cause);
            this.ioException = cause;
        }

        public final IOException getIoException() {
            return this.ioException;
        }
    }
}

