/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.Loading;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MovieButtons;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MovieButtonsFrameLoader;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.SliderWithAutoWidth;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.SliderWithMovieButtonsValueLoader;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SliderEvent;
import com.extjs.gxt.ui.client.widget.Slider;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class SliderWithMovieButtons
extends Composite {
    private Slider slider;
    private MovieButtons buttons;
    private Loading loading;
    private SliderWithMovieButtonsValueLoader valueLoader = SliderWithMovieButtonsValueLoader.NULL_LOADER;

    public SliderWithMovieButtons(int numberOfValues) {
        this.loading = new Loading();
        this.buttons = new MovieButtons(numberOfValues);
        this.buttons.setFrameLoader(new MovieButtonsFrameLoader(){

            @Override
            public void loadFrame(int frame, final AsyncCallback<Void> callback) {
                final int value = frame + 1;
                SliderWithMovieButtons.this.showLoading();
                SliderWithMovieButtons.this.slider.setValue(value, true);
                SliderWithMovieButtons.this.valueLoader.loadValue(value, new AsyncCallback<Void>(){

                    public void onSuccess(Void result) {
                        SliderWithMovieButtons.this.hideLoading(value);
                        callback.onSuccess((Object)result);
                    }

                    public void onFailure(Throwable caught) {
                        SliderWithMovieButtons.this.hideLoading(value);
                        callback.onFailure(caught);
                    }
                });
            }
        });
        this.slider = new SliderWithAutoWidth(numberOfValues);
        this.slider.addListener(Events.Change, (Listener)new Listener<SliderEvent>(){

            public void handleEvent(SliderEvent be) {
                final int value = be.getNewValue();
                SliderWithMovieButtons.this.showLoading();
                SliderWithMovieButtons.this.buttons.setFrame(value - 1);
                SliderWithMovieButtons.this.valueLoader.loadValue(value, new AsyncCallback<Void>(){

                    public void onSuccess(Void result) {
                        SliderWithMovieButtons.this.hideLoading(value);
                    }

                    public void onFailure(Throwable caught) {
                        SliderWithMovieButtons.this.hideLoading(value);
                    }
                });
            }
        });
        this.initWidget((Widget)new HTML());
    }

    public Widget getWidgets() {
        VerticalPanel panel = new VerticalPanel();
        panel.add(this.getSliderWidget());
        panel.add(this.getButtonsWidget());
        panel.add(this.getLoadingWidget());
        return panel;
    }

    public Widget getSliderWidget() {
        return this.slider;
    }

    public Widget getButtonsWidget() {
        return this.buttons;
    }

    public Widget getLoadingWidget() {
        return this.loading;
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public int getDelay() {
        return this.buttons.getDelay();
    }

    public void setDelay(int delay) {
        this.buttons.setDelay(delay);
    }

    public void addDelayChangeHandler(ChangeHandler handler) {
        this.buttons.addDelayChangeHandler(handler);
    }

    public SliderWithMovieButtonsValueLoader getValueLoader() {
        return this.valueLoader;
    }

    public void setValueLoader(SliderWithMovieButtonsValueLoader valueLoader) {
        if (valueLoader == null) {
            throw new IllegalArgumentException("Value loader was null");
        }
        this.valueLoader = valueLoader;
    }

    private void showLoading() {
        this.loading.showLoading();
    }

    private void hideLoading(int value) {
        if (this.slider.getValue() == value) {
            this.loading.hideLoading();
        }
    }
}

