/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class VisitechReader
extends FormatReader {
    public static final String[] HTML_SUFFIX = new String[]{"html"};
    public static final String HEADER_MARKER = "[USE SAME FILE]";
    public static final byte[] PIXELS_MARKER = new byte[]{0, 0, 0, 0, 0, 0, -16, 63, 0, 0, 0, 0, 0, 0, -16, 63};
    private Vector<String> files;
    private long[] pixelOffsets;

    public VisitechReader() {
        super("Visitech XYS", new String[]{"xys", "html"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .html file plus one or more .xys files";
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (VisitechReader.checkSuffix(name, "xys")) {
            return true;
        }
        if (name.indexOf(" ") == -1) {
            return false;
        }
        if (!open) {
            return false;
        }
        String prefix = name.substring(0, name.lastIndexOf(" "));
        Location xys = new Location(prefix + " 1.xys");
        return xys.exists();
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int plane = FormatTools.getPlaneSize(this);
        int div = this.getSizeZ() * this.getSizeT();
        int fileIndex = this.series * this.getSizeC() + no / div;
        int planeIndex = no % div;
        if (fileIndex >= this.files.size() || fileIndex >= this.pixelOffsets.length) {
            return buf;
        }
        String file2 = this.files.get(fileIndex);
        RandomAccessInputStream s = new RandomAccessInputStream(file2);
        s.order(this.isLittleEndian());
        s.seek(this.pixelOffsets[fileIndex]);
        int paddingBytes = (int)(s.length() - s.getFilePointer() - (long)(div * plane)) / (div - 1);
        if (planeIndex > 0) {
            s.skipBytes((plane + paddingBytes) * planeIndex);
        }
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> v = new Vector<String>();
        v.add(this.currentId);
        if (!noPixels && this.files != null) {
            int nFiles = this.getSizeC();
            for (int i = 0; i < nFiles; ++i) {
                int index = this.getSeries() * nFiles + i;
                if (index >= this.files.size()) continue;
                v.add(this.files.get(index));
            }
        }
        return v.toArray(new String[v.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.files = null;
            this.pixelOffsets = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String file2;
        super.initFile(id);
        if (!VisitechReader.checkSuffix(id, HTML_SUFFIX)) {
            String base = id.substring(0, id.lastIndexOf(" "));
            this.currentId = null;
            this.initFile(base + " Report.html");
            return;
        }
        String s = DataTools.readFile(id);
        s = s.replaceAll("<[bB][rR]>", "\n");
        s = s.replaceAll("<[sS][tT][yY][lL][eE]\\p{ASCII}*?[sS][tT][yY][lL][eE]>", "");
        s = s.replaceAll("<[sS][cC][rR][iI][pP][tT]\\p{ASCII}*?[sS][cC][rR][iI][pP][tT]>", "");
        String key = null;
        String value = null;
        int numSeries = 0;
        String[] tokens = s.split("\n");
        int estimatedSeriesCount = 0;
        int estimatedSizeC = 0;
        for (String token : tokens) {
            if ((token = token.trim()).startsWith("<") && !token.startsWith("</") || token.indexOf("pixels") != -1) {
                int ndx = (token = token.replaceAll("<.*?>", "")).indexOf(":");
                if (ndx != -1) {
                    key = token.substring(0, ndx).trim();
                    value = token.substring(ndx + 1).trim();
                    if (key.equals("Number of steps")) {
                        this.core[0].sizeZ = Integer.parseInt(value);
                    } else if (key.equals("Image bit depth")) {
                        int bits = Integer.parseInt(value);
                        while (bits % 8 != 0) {
                            ++bits;
                        }
                        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bits /= 8, false, false);
                    } else if (key.equals("Image dimensions")) {
                        int n = value.indexOf(",");
                        this.core[0].sizeX = Integer.parseInt(value.substring(1, n).trim());
                        this.core[0].sizeY = Integer.parseInt(value.substring(n + 1, value.length() - 1).trim());
                    } else if (key.startsWith("Channel Selection")) {
                        ++this.core[0].sizeC;
                    } else if (key.startsWith("Microscope XY")) {
                        ++numSeries;
                    }
                    this.addGlobalMeta(key, value);
                }
                if (token.indexOf("pixels") != -1) {
                    ++this.core[0].sizeC;
                    this.core[0].imageCount += Integer.parseInt(token.substring(0, token.indexOf(" ")));
                    continue;
                }
                if (!token.startsWith("Time Series")) continue;
                int idx = token.indexOf(";") + 1;
                String ss = token.substring(idx, token.indexOf(" ", idx)).trim();
                this.core[0].sizeT = Integer.parseInt(ss);
                continue;
            }
            if (token.indexOf("Document created") == -1) continue;
            ++estimatedSeriesCount;
            ++estimatedSizeC;
        }
        if (numSeries == 0) {
            numSeries = estimatedSeriesCount;
            this.core[0].sizeC *= estimatedSizeC;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = estimatedSizeC;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        this.files = new Vector();
        int ndx = this.currentId.lastIndexOf(File.separator) + 1;
        String base = this.currentId.substring(ndx, this.currentId.lastIndexOf(" "));
        File f = new File(this.currentId).getAbsoluteFile();
        String string = file2 = f.exists() ? f.getParent() + File.separator : "";
        if (numSeries == 0) {
            numSeries = 1;
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            String pixelsFile = file2 + base + " " + (i + 1) + ".xys";
            Location p = new Location(pixelsFile);
            if (p.exists()) {
                this.files.add(p.getAbsolutePath());
                continue;
            }
            if (numSeries > 1) {
                this.core[0].sizeC -= this.getSizeC() / numSeries;
                --numSeries;
                continue;
            }
            if (this.getSizeC() <= 1) continue;
            --this.core[0].sizeC;
        }
        this.files.add(this.currentId);
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            if (this.getSizeT() == 0) {
                this.core[0].sizeT = 1;
            }
        }
        if (this.getImageCount() == 0) {
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        if (numSeries > 1) {
            int x = this.getSizeX();
            int y = this.getSizeY();
            int z = this.getSizeZ();
            int c = this.getSizeC() / numSeries;
            int t = this.getSizeT();
            int count = z * c * t;
            int ptype = this.getPixelType();
            this.core = new CoreMetadata[numSeries];
            for (int i2 = 0; i2 < numSeries; ++i2) {
                this.core[i2] = new CoreMetadata();
                this.core[i2].sizeX = x;
                this.core[i2].sizeY = y;
                this.core[i2].sizeZ = z;
                this.core[i2].sizeC = c;
                this.core[i2].sizeT = t;
                this.core[i2].imageCount = count;
                this.core[i2].pixelType = ptype;
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].rgb = false;
            this.core[i].dimensionOrder = "XYZTC";
            this.core[i].interleaved = false;
            this.core[i].littleEndian = true;
            this.core[i].indexed = false;
            this.core[i].falseColor = false;
            this.core[i].metadataComplete = true;
        }
        this.pixelOffsets = new long[this.files.size() - 1];
        for (i = 0; i < this.pixelOffsets.length; ++i) {
            this.pixelOffsets[i] = this.findPixelsOffset(i);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i3 = 0; i3 < numSeries; ++i3) {
            store.setImageName("Position " + (i3 + 1), i3);
        }
    }

    private long findPixelsOffset(int fileIndex) throws IOException {
        String file2 = this.files.get(fileIndex);
        RandomAccessInputStream s = new RandomAccessInputStream(file2);
        s.order(this.isLittleEndian());
        s.findString(false, HEADER_MARKER);
        int plane = FormatTools.getPlaneSize(this);
        int planeCount = this.getSizeZ() * this.getSizeT();
        long skip = (s.length() - s.getFilePointer() - (long)(planeCount * plane)) / (long)planeCount;
        long fp = s.getFilePointer() + skip - (long)HEADER_MARKER.length();
        s.seek(fp);
        if (s.readByte() == PIXELS_MARKER[PIXELS_MARKER.length - 1]) {
            ++fp;
        }
        s.close();
        return fp;
    }
}

