/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import thredds.datatype.DateRange;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.grid.GridDataset;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.units.ConversionException;

public class GridCoordSys
extends CoordinateSystem {
    private static SimpleUnit kmUnit = SimpleUnit.factory("km");
    private ProjectionImpl proj;
    private CoordinateAxis horizXaxis;
    private CoordinateAxis horizYaxis;
    private CoordinateAxis1D vertZaxis;
    private CoordinateAxis1D timeTaxis;
    private VerticalCT vCT;
    private Dimension timeDim;
    private boolean isDate = false;
    private boolean isLatLon = false;
    private ArrayList levels = null;
    private ArrayList times = null;
    private Date[] timeDates = null;
    private ProjectionRect mapArea = null;
    private LatLonRect llbb = null;

    public static boolean isGridCoordSys(StringBuffer sbuff, CoordinateSystem cs) {
        if (cs.getRankDomain() < 2) {
            if (sbuff != null) {
                sbuff.append(cs.getName() + " domain rank < 2\n");
            }
            return false;
        }
        if (!cs.isLatLon()) {
            if (cs.getXaxis() == null || cs.getYaxis() == null) {
                if (sbuff != null) {
                    sbuff.append(cs.getName() + " NO Lat,Lon or X,Y axis\n");
                }
                return false;
            }
            if (null == cs.getProjection()) {
                if (sbuff != null) {
                    sbuff.append(cs.getName() + " NO projection found\n");
                }
                return false;
            }
        }
        CoordinateAxis xaxis = null;
        CoordinateAxis yaxis = null;
        if (cs.isGeoXY()) {
            xaxis = cs.getXaxis();
            yaxis = cs.getYaxis();
            ProjectionImpl p = cs.getProjection();
            if (!(p instanceof RotatedPole)) {
                if (!kmUnit.isCompatible(xaxis.getUnitsString())) {
                    sbuff.append(cs.getName() + " X axis units must be convertible to km\n");
                    return false;
                }
                if (!kmUnit.isCompatible(yaxis.getUnitsString())) {
                    sbuff.append(cs.getName() + " Y axis units must be convertible to km\n");
                    return false;
                }
            }
        } else if (cs.isLatLon()) {
            xaxis = cs.getLonAxis();
            yaxis = cs.getLatAxis();
        }
        if (xaxis.getRank() > 2 || yaxis.getRank() > 2) {
            if (sbuff != null) {
                sbuff.append(cs.getName() + " X or Y axis rank must be <= 2\n");
            }
            return false;
        }
        int countRangeRank = 2;
        CoordinateAxis z = cs.getHeightAxis();
        if (z == null || !(z instanceof CoordinateAxis1D)) {
            z = cs.getPressureAxis();
        }
        if (z == null || !(z instanceof CoordinateAxis1D)) {
            z = cs.getZaxis();
        }
        if (z != null && !(z instanceof CoordinateAxis1D)) {
            if (sbuff != null) {
                sbuff.append(cs.getName() + " Z axis must be 1D\n");
            }
            return false;
        }
        CoordinateAxis t = cs.getTaxis();
        if (t != null && !(t instanceof CoordinateAxis1D)) {
            if (sbuff != null) {
                sbuff.append(cs.getName() + " T axis must be 1D\n");
            }
            return false;
        }
        if (t != null) {
            ++countRangeRank;
        }
        return true;
    }

    public static GridCoordSys makeGridCoordSys(StringBuffer sbuff, CoordinateSystem cs, VariableEnhanced v) {
        if (sbuff != null) {
            sbuff.append(" ");
            v.getNameAndDimensions(sbuff, true, false);
            sbuff.append(" check CS " + cs.getName());
        }
        if (GridCoordSys.isGridCoordSys(sbuff, cs)) {
            GridCoordSys gcs = new GridCoordSys(cs);
            if (gcs.isComplete(v)) {
                if (sbuff != null) {
                    sbuff.append(" OK\n");
                }
                return gcs;
            }
            if (sbuff != null) {
                sbuff.append(" NOT complete\n");
            }
        }
        return null;
    }

    public GridCoordSys(CoordinateSystem cs) {
        CoordinateAxis t;
        CoordinateAxis z;
        if (cs.isGeoXY()) {
            this.horizXaxis = this.xAxis = cs.getXaxis();
            this.horizYaxis = this.yAxis = cs.getYaxis();
            if (!(cs.getProjection() instanceof RotatedPole)) {
                this.convertUnits(this.horizXaxis);
                this.convertUnits(this.horizYaxis);
            }
        } else if (cs.isLatLon()) {
            this.horizXaxis = this.lonAxis = cs.getLonAxis();
            this.horizYaxis = this.latAxis = cs.getLatAxis();
            this.isLatLon = true;
        } else {
            throw new IllegalArgumentException("CoordinateSystem is not geoReferencing");
        }
        this.coordAxes.add(this.horizXaxis);
        this.coordAxes.add(this.horizYaxis);
        this.proj = cs.getProjection();
        if (this.proj != null) {
            this.proj.setDefaultMapArea(this.getBoundingBox());
        }
        if ((z = (this.hAxis = cs.getHeightAxis())) == null || !(z instanceof CoordinateAxis1D)) {
            z = this.pAxis = cs.getPressureAxis();
        }
        if (z == null || !(z instanceof CoordinateAxis1D)) {
            z = this.zAxis = cs.getZaxis();
        }
        if (z != null && !(z instanceof CoordinateAxis1D)) {
            z = null;
        }
        if (z != null) {
            this.vertZaxis = (CoordinateAxis1D)z;
            this.coordAxes.add(this.vertZaxis);
        } else {
            this.zAxis = null;
            this.pAxis = null;
            this.hAxis = null;
        }
        List<CoordinateTransform> list = cs.getCoordinateTransforms();
        for (int i = 0; i < list.size(); ++i) {
            CoordinateTransform ct = list.get(i);
            if (!(ct instanceof VerticalCT)) continue;
            this.vCT = (VerticalCT)ct;
            break;
        }
        if ((t = cs.getTaxis()) != null && t instanceof CoordinateAxis1D) {
            this.tAxis = t;
            this.timeTaxis = (CoordinateAxis1D)t;
            this.coordAxes.add(this.timeTaxis);
            this.timeDim = t.getDimension(0);
        }
        Collections.sort(this.coordAxes, new CoordinateAxis.AxisComparator());
        this.name = GridCoordSys.makeName(this.coordAxes);
        this.coordTrans = new ArrayList<CoordinateTransform>(cs.getCoordinateTransforms());
        for (int i = 0; i < this.coordAxes.size(); ++i) {
            CoordinateAxis axis = (CoordinateAxis)this.coordAxes.get(i);
            List<Dimension> dims = axis.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (this.domain.contains(dim)) continue;
                this.domain.add(dim);
            }
        }
        this.makeLevels();
        this.makeTimes();
    }

    public GridCoordSys(GridCoordSys from, Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        CoordinateAxis1D taxis;
        CoordinateAxis1D zaxis;
        CoordinateAxis xaxis = from.getXHorizAxis();
        CoordinateAxis yaxis = from.getYHorizAxis();
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)xaxis;
            CoordinateAxis1D yaxis1 = (CoordinateAxis1D)yaxis;
            this.horizXaxis = x_range == null ? xaxis1 : xaxis1.section(x_range);
            this.horizYaxis = y_range == null ? yaxis : yaxis1.section(y_range);
        } else if (xaxis instanceof CoordinateAxis2D && yaxis instanceof CoordinateAxis2D && from.isLatLon()) {
            CoordinateAxis2D lon_axis = (CoordinateAxis2D)xaxis;
            CoordinateAxis2D lat_axis = (CoordinateAxis2D)yaxis;
            this.horizXaxis = lon_axis.section(y_range, x_range);
            this.horizYaxis = lat_axis.section(y_range, x_range);
        } else {
            throw new IllegalArgumentException("must be 1D or 2D/LatLon ");
        }
        if (from.isGeoXY()) {
            this.xAxis = this.horizXaxis;
            this.yAxis = this.horizYaxis;
        } else {
            this.lonAxis = this.horizXaxis;
            this.latAxis = this.horizYaxis;
            this.isLatLon = true;
        }
        this.coordAxes.add(this.horizXaxis);
        this.coordAxes.add(this.horizYaxis);
        this.proj = (ProjectionImpl)from.getProjection().clone();
        if (this.proj != null && this.getBoundingBox() != null) {
            this.proj.setDefaultMapArea(this.getBoundingBox());
        }
        if ((zaxis = from.getVerticalAxis()) != null) {
            this.vertZaxis = z_range == null ? zaxis : zaxis.section(z_range);
            this.coordAxes.add(this.vertZaxis);
        }
        if (from.getVerticalTransform2() != null) {
            VerticalTransform vt = from.getVerticalTransform();
            if (vt != null) {
                vt = vt.subset(t_range, z_range, y_range, x_range);
            }
            this.vCT = new VerticalCT(from.getVerticalTransform2());
            this.vCT.setVerticalTransform(vt);
        }
        if ((taxis = from.getTimeAxis()) != null) {
            this.timeTaxis = t_range == null ? taxis : taxis.section(t_range);
            this.tAxis = this.timeTaxis;
            this.coordAxes.add(this.timeTaxis);
            this.timeDim = this.timeTaxis.getDimension(0);
        }
        Collections.sort(this.coordAxes, new CoordinateAxis.AxisComparator());
        this.name = GridCoordSys.makeName(this.coordAxes);
        this.coordTrans = new ArrayList<CoordinateTransform>(from.getCoordinateTransforms());
        for (int i = 0; i < this.coordAxes.size(); ++i) {
            CoordinateAxis axis = (CoordinateAxis)this.coordAxes.get(i);
            List<Dimension> dims = axis.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                dim.setShared(true);
                if (this.domain.contains(dim)) continue;
                this.domain.add(dim);
            }
        }
        this.makeLevels();
        this.makeTimes();
    }

    private void convertUnits(CoordinateAxis axis) {
        Array data;
        double factor;
        String units = axis.getUnitsString();
        SimpleUnit axisUnit = SimpleUnit.factory(units);
        try {
            factor = axisUnit.convertTo(1.0, kmUnit);
        }
        catch (ConversionException e) {
            e.printStackTrace();
            return;
        }
        if (factor == 1.0) {
            return;
        }
        try {
            data = axis.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            ii.setDoubleCurrent(factor * ii.getDoubleNext());
        }
        axis.setCachedData(data, false);
        axis.setUnitsString("km");
    }

    public VerticalTransform getVerticalTransform() {
        return this.vCT == null ? null : this.vCT.getVerticalTransform();
    }

    public VerticalCT getVerticalTransform2() {
        return this.vCT;
    }

    void makeVerticalTransform(GridDataset gds, StringBuffer parseInfo) {
        if (this.vCT == null) {
            return;
        }
        if (this.vCT.getVerticalTransform() != null) {
            return;
        }
        this.vCT.makeVerticalTransform(gds.getNetcdfDataset(), this.timeDim);
        if (this.vCT.getVerticalTransform() == null) {
            parseInfo.append("  - CAN'T make VerticalTransform = " + this.vCT.getVerticalTransformType() + "\n");
        } else {
            parseInfo.append("  - makeVerticalTransform = " + this.vCT.getVerticalTransformType() + "\n");
        }
    }

    public CoordinateAxis getXHorizAxis() {
        return this.horizXaxis;
    }

    public CoordinateAxis getYHorizAxis() {
        return this.horizYaxis;
    }

    public CoordinateAxis1D getVerticalAxis() {
        return this.vertZaxis;
    }

    public CoordinateAxis1D getTimeAxis() {
        return this.timeTaxis;
    }

    public ProjectionImpl getProjection() {
        return this.proj;
    }

    public ArrayList getLevels() {
        return this.levels;
    }

    public ArrayList getTimes() {
        return this.times;
    }

    public Date[] getTimeDates() {
        return this.timeDates;
    }

    public boolean isLatLon() {
        return this.isLatLon;
    }

    public boolean isDate() {
        return this.isDate;
    }

    public boolean isZPositive() {
        if (this.vertZaxis == null) {
            return false;
        }
        if (this.vertZaxis.getPositive() != null) {
            return this.vertZaxis.getPositive().equalsIgnoreCase("up");
        }
        if (this.vertZaxis.getAxisType() == AxisType.Height) {
            return true;
        }
        return this.vertZaxis.getAxisType() != AxisType.Pressure;
    }

    public boolean isRegularSpatial() {
        if (!this.isRegularSpatial(this.getXHorizAxis())) {
            return false;
        }
        return this.isRegularSpatial(this.getYHorizAxis());
    }

    private boolean isRegularSpatial(CoordinateAxis axis) {
        if (axis == null) {
            return true;
        }
        if (!(axis instanceof CoordinateAxis1D)) {
            return false;
        }
        return ((CoordinateAxis1D)axis).isRegular();
    }

    public int[] findXYCoordElement(double xpos, double ypos, int[] result) {
        if (result == null) {
            result = new int[2];
        }
        if (this.horizXaxis instanceof CoordinateAxis1D && this.horizYaxis instanceof CoordinateAxis1D) {
            result[0] = ((CoordinateAxis1D)this.horizXaxis).findCoordElement(xpos);
            result[1] = ((CoordinateAxis1D)this.horizYaxis).findCoordElement(ypos);
            return result;
        }
        if (this.horizXaxis instanceof CoordinateAxis2D && this.horizYaxis instanceof CoordinateAxis2D) {
            result[0] = -1;
            result[1] = -1;
            return result;
        }
        throw new IllegalStateException("GridCoordSystem.findXYCoordElement");
    }

    public int findTimeCoordElement(Date d) {
        int index;
        if (this.timeTaxis == null || !this.isDate()) {
            throw new UnsupportedOperationException("GridCoordSys: ti");
        }
        int n = (int)this.timeTaxis.getSize();
        long m = d.getTime();
        for (index = 0; index < n && m >= this.timeDates[index].getTime(); ++index) {
        }
        return index - 1;
    }

    public String getLevelName(int index) {
        if (this.vertZaxis == null || index < 0 || (long)index >= this.vertZaxis.getSize()) {
            throw new IllegalArgumentException("getLevelName = " + index);
        }
        NamedAnything name = (NamedAnything)this.levels.get(index);
        return name.getName();
    }

    public int getLevelIndex(String name) {
        if (this.vertZaxis == null || name == null) {
            return -1;
        }
        for (int i = 0; i < this.levels.size(); ++i) {
            NamedAnything level = (NamedAnything)this.levels.get(i);
            if (!level.getName().trim().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public String getTimeName(int index) {
        if (this.timeTaxis == null || index < 0 || (long)index >= this.timeTaxis.getSize()) {
            throw new IllegalArgumentException("getTimeName = " + index);
        }
        NamedAnything name = (NamedAnything)this.times.get(index);
        return name.getName();
    }

    public int getTimeIndex(String name) {
        if (this.timeTaxis == null || name == null) {
            return -1;
        }
        for (int i = 0; i < this.times.size(); ++i) {
            NamedAnything time = (NamedAnything)this.times.get(i);
            if (!time.getName().trim().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public DateRange getDateRange() {
        if (this.isDate()) {
            Date[] dates = this.getTimeDates();
            return new DateRange(dates[0], dates[dates.length - 1]);
        }
        return null;
    }

    public DateUnit getDateUnit() throws Exception {
        String tUnits = this.getTimeAxis().getUnitsString();
        return (DateUnit)SimpleUnit.factory(tUnits);
    }

    public TimeUnit getTimeResolution() throws Exception {
        CoordinateAxis1D taxis = this.getTimeAxis();
        String tUnits = taxis.getUnitsString();
        StringTokenizer stoker = new StringTokenizer(tUnits);
        double tResolution = taxis.getIncrement();
        return new TimeUnit(tResolution, stoker.nextToken());
    }

    public ProjectionRect getBoundingBox() {
        if (this.mapArea == null) {
            if (this.horizXaxis == null || !this.horizXaxis.isNumeric() || this.horizYaxis == null || !this.horizYaxis.isNumeric()) {
                return null;
            }
            if (!(this.horizXaxis instanceof CoordinateAxis1D) || !(this.horizYaxis instanceof CoordinateAxis1D)) {
                this.mapArea = new ProjectionRect(this.horizXaxis.getMinValue(), this.horizYaxis.getMinValue(), this.horizXaxis.getMaxValue(), this.horizYaxis.getMaxValue());
            } else {
                CoordinateAxis1D xaxis1 = (CoordinateAxis1D)this.horizXaxis;
                CoordinateAxis1D yaxis1 = (CoordinateAxis1D)this.horizYaxis;
                this.mapArea = new ProjectionRect(xaxis1.getCoordEdge(0), yaxis1.getCoordEdge(0), xaxis1.getCoordEdge((int)xaxis1.getSize()), yaxis1.getCoordEdge((int)yaxis1.getSize()));
            }
        }
        return this.mapArea;
    }

    public LatLonRect getLatLonBoundingBox() {
        if (this.llbb == null) {
            if (this.isLatLon()) {
                double startLat = this.horizYaxis.getMinValue();
                double startLon = this.horizXaxis.getMinValue();
                double deltaLat = this.horizYaxis.getMaxValue() - startLat;
                double deltaLon = this.horizXaxis.getMaxValue() - startLon;
                LatLonPointImpl llpt = new LatLonPointImpl(startLat, startLon);
                this.llbb = new LatLonRect(llpt, deltaLat, deltaLon);
            } else {
                ProjectionImpl dataProjection = this.getProjection();
                ProjectionRect bb = this.getBoundingBox();
                LatLonPointImpl llpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getLowerLeftPoint(), new LatLonPointImpl());
                LatLonPointImpl urpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getUpperRightPoint(), new LatLonPointImpl());
                LatLonPointImpl ulpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getUpperLeftPoint(), new LatLonPointImpl());
                LatLonPointImpl lrpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getLowerRightPoint(), new LatLonPointImpl());
                double latMin = Math.min(llpt.getLatitude(), lrpt.getLatitude());
                double latMax = Math.max(ulpt.getLatitude(), urpt.getLatitude());
                double lonMin = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
                double lonMax = this.getMinOrMaxLon(lrpt.getLongitude(), urpt.getLongitude(), false);
                llpt.set(latMin, lonMin);
                urpt.set(latMax, lonMax);
                this.llbb = new LatLonRect(llpt, urpt);
            }
        }
        return this.llbb;
    }

    private double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
        double midpoint = (lon1 + lon2) / 2.0;
        lon1 = LatLonPointImpl.lonNormal(lon1, midpoint);
        lon2 = LatLonPointImpl.lonNormal(lon2, midpoint);
        return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
    }

    public List getLatLonBoundingBox(LatLonRect rect) {
        double maxy;
        double maxx;
        double miny;
        double minx;
        LatLonPointImpl llpt = rect.getLowerLeftPoint();
        LatLonPointImpl urpt = rect.getUpperRightPoint();
        LatLonPointImpl lrpt = rect.getLowerRightPoint();
        LatLonPointImpl ulpt = rect.getUpperLeftPoint();
        if (this.isLatLon()) {
            minx = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            maxx = this.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
            maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
        } else {
            ProjectionImpl dataProjection = this.getProjection();
            ProjectionPoint ll = dataProjection.latLonToProj(llpt, new ProjectionPointImpl());
            ProjectionPoint ur = dataProjection.latLonToProj(urpt, new ProjectionPointImpl());
            ProjectionPoint lr = dataProjection.latLonToProj(lrpt, new ProjectionPointImpl());
            ProjectionPoint ul = dataProjection.latLonToProj(ulpt, new ProjectionPointImpl());
            minx = Math.min(ll.getX(), ul.getX());
            miny = Math.min(ll.getY(), lr.getY());
            maxx = Math.max(ur.getX(), lr.getX());
            maxy = Math.max(ul.getY(), ur.getY());
        }
        CoordinateAxis xaxis = this.getXHorizAxis();
        CoordinateAxis yaxis = this.getYHorizAxis();
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)xaxis;
            CoordinateAxis1D yaxis1 = (CoordinateAxis1D)yaxis;
            int minxIndex = xaxis1.findCoordElementBounded(minx);
            int minyIndex = yaxis1.findCoordElementBounded(miny);
            int maxxIndex = xaxis1.findCoordElementBounded(maxx);
            int maxyIndex = yaxis1.findCoordElementBounded(maxy);
            ArrayList<Range> list = new ArrayList<Range>();
            try {
                list.add(new Range(Math.min(minyIndex, maxyIndex), Math.max(minyIndex, maxyIndex)));
                list.add(new Range(Math.min(minxIndex, maxxIndex), Math.max(minxIndex, maxxIndex)));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            return list;
        }
        if (xaxis instanceof CoordinateAxis2D && yaxis instanceof CoordinateAxis2D && this.isLatLon()) {
            CoordinateAxis2D lon_axis = (CoordinateAxis2D)xaxis;
            CoordinateAxis2D lat_axis = (CoordinateAxis2D)yaxis;
            int[] shape = lon_axis.getShape();
            int nj = shape[0];
            int ni = shape[1];
            int mini = Integer.MAX_VALUE;
            int minj = Integer.MAX_VALUE;
            int maxi = -1;
            int maxj = -1;
            for (int j = 0; j < nj; ++j) {
                for (int i = 0; i < ni; ++i) {
                    double lat = lat_axis.getCoordValue(j, i);
                    double lon = lon_axis.getCoordValue(j, i);
                    if (!(lat >= miny) || !(lat <= maxy) || !(lon >= minx) || !(lon <= maxx)) continue;
                    if (i > maxi) {
                        maxi = i;
                    }
                    if (i < mini) {
                        mini = i;
                    }
                    if (j > maxj) {
                        maxj = j;
                    }
                    if (j >= minj) continue;
                    minj = j;
                }
            }
            if (mini > maxi || minj > maxj) {
                mini = 0;
                minj = 0;
                maxi = -1;
                maxj = -1;
            }
            ArrayList<Range> list = new ArrayList<Range>();
            try {
                list.add(new Range(minj, maxj));
                list.add(new Range(mini, maxi));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            return list;
        }
        throw new IllegalArgumentException("must be 1D or 2D/LatLon ");
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(200);
        buff.setLength(0);
        buff.append("(" + this.getName() + ") ");
        if (this.proj != null) {
            buff.append("  Projection:" + this.proj.getName() + " " + this.proj.getClassName());
        }
        return buff.toString();
    }

    private void makeLevels() {
        this.levels = new ArrayList();
        if (this.vertZaxis == null) {
            return;
        }
        int n = (int)this.vertZaxis.getSize();
        for (int i = 0; i < n; ++i) {
            this.levels.add(new NamedAnything(this.vertZaxis.getCoordName(i), this.vertZaxis.getUnitsString()));
        }
    }

    private void makeTimes() {
        this.times = new ArrayList();
        if (this.timeTaxis == null || this.timeTaxis.getSize() == 0L) {
            return;
        }
        int n = (int)this.timeTaxis.getSize();
        this.timeDates = new Date[n];
        SimpleUnit su = null;
        String units = this.timeTaxis.getUnitsString();
        if (units != null) {
            su = SimpleUnit.factory(units);
        }
        if (su != null && su instanceof DateUnit) {
            DateFormatter formatter = new DateFormatter();
            DateUnit du = (DateUnit)su;
            for (int i = 0; i < n; ++i) {
                Date d = du.makeDate(this.timeTaxis.getCoordValue(i));
                String name = formatter.toDateTimeString(d);
                if (name == null) {
                    name = Double.toString(this.timeTaxis.getCoordValue(i));
                }
                this.times.add(new NamedAnything(name, "date/time"));
                this.timeDates[i] = d;
            }
            this.isDate = true;
            return;
        }
        if (this.timeTaxis.getDataType() == DataType.STRING || this.timeTaxis.getDataType() == DataType.CHAR) {
            this.isDate = true;
            DateFormatter formatter = new DateFormatter();
            for (int i = 0; i < n; ++i) {
                String coordValue = this.timeTaxis.getCoordName(i);
                Date d = formatter.getISODate(coordValue);
                if (d == null) {
                    this.isDate = false;
                    this.times.add(new NamedAnything(coordValue, this.timeTaxis.getUnitsString()));
                    continue;
                }
                this.times.add(new NamedAnything(formatter.toDateTimeString(d), "date/time"));
                this.timeDates[i] = d;
            }
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.times.add(new NamedAnything(this.timeTaxis.getCoordName(i), this.timeTaxis.getUnitsString()));
        }
    }

    private static class NamedAnything
    implements NamedObject {
        private String name;
        private String desc;

        NamedAnything(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return this.name;
        }
    }
}

