/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingResultSet;
import org.apache.commons.dbcp.DelegatingStatement;

public class DelegatingPreparedStatement
extends DelegatingStatement
implements PreparedStatement {
    public DelegatingPreparedStatement(DelegatingConnection delegatingConnection, PreparedStatement preparedStatement) {
        super(delegatingConnection, preparedStatement);
    }

    public boolean equals(Object object) {
        PreparedStatement preparedStatement = (PreparedStatement)this.getInnermostDelegate();
        if (preparedStatement == null) {
            return false;
        }
        if (object instanceof DelegatingPreparedStatement) {
            DelegatingPreparedStatement delegatingPreparedStatement = (DelegatingPreparedStatement)object;
            return preparedStatement.equals(delegatingPreparedStatement.getInnermostDelegate());
        }
        return preparedStatement.equals(object);
    }

    public void setDelegate(PreparedStatement preparedStatement) {
        super.setDelegate(preparedStatement);
        this._stmt = preparedStatement;
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, ((PreparedStatement)this._stmt).executeQuery());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    public int executeUpdate() throws SQLException {
        this.checkOpen();
        try {
            return ((PreparedStatement)this._stmt).executeUpdate();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setNull(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setByte(n, by);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setShort(n, s);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setLong(n, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setString(int n, String string) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setString(n, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setDate(n, date);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setTime(n, time);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void clearParameters() throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).clearParameters();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setObject(n, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public boolean execute() throws SQLException {
        this.checkOpen();
        try {
            return ((PreparedStatement)this._stmt).execute();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public void addBatch() throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).addBatch();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setArray(n, array);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return ((PreparedStatement)this._stmt).getMetaData();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public String toString() {
        return this._stmt.toString();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this._stmt).setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        try {
            return ((PreparedStatement)this._stmt).getParameterMetaData();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }
}

