/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.etlserver.utils.Column;
import ch.systemsx.cisd.etlserver.utils.TabSeparatedValueTable;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import eu.basysbio.cisd.dss.DataColumnHeader;
import eu.basysbio.cisd.dss.DataHeaderProperty;
import eu.basysbio.cisd.dss.TimeSeriesPropertyType;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

class HeaderUtils {
    private static final String DOTS = "...";
    private static final String QUANTIFIED_PEPTIDES = "QuantifiedPeptides";
    private static final String PROTEIN_LCMS_RATIO = "ProteinLcmsRatio";
    private static final Pattern DATA_COLUMN_HEADER_PATTERN = Pattern.compile(".*(::.*)+");
    private static final String LIST_SEPARATOR = ", ";
    private static final String[] TSV_EXTENSIONS = new String[]{"tsv", "TSV", "txt", "TXT"};
    public static final TimeSeriesPropertyType[] TIME_SERIES_HEADER_PROPERTIES = new TimeSeriesPropertyType[]{TimeSeriesPropertyType.TECHNICAL_REPLICATE_CODE_LIST, TimeSeriesPropertyType.BIOLOGICAL_REPLICATE_CODE, TimeSeriesPropertyType.TIME_SERIES_DATA_SET_TYPE, TimeSeriesPropertyType.CEL_LOC, TimeSeriesPropertyType.CG_LIST, TimeSeriesPropertyType.CULTIVATION_METHOD_EXPERIMENT_CODE, TimeSeriesPropertyType.EXPERIMENT_CODE, TimeSeriesPropertyType.GENOTYPE, TimeSeriesPropertyType.GROWTH_PHASE, TimeSeriesPropertyType.SCALE_LIST, TimeSeriesPropertyType.TIME_POINT_LIST, TimeSeriesPropertyType.TIME_POINT_TYPE, TimeSeriesPropertyType.BI_ID, TimeSeriesPropertyType.VALUE_TYPE_LIST};

    HeaderUtils() {
    }

    private static Collection<DataColumnHeader> extractDataColumnHeaders(Collection<Column> columns) {
        ArrayList<DataColumnHeader> result = new ArrayList<DataColumnHeader>();
        for (Column c : columns) {
            String header = c.getHeader();
            if (!HeaderUtils.isDataColumnHeader(header)) continue;
            result.add(new DataColumnHeader(header));
        }
        return result;
    }

    private static Map<DataHeaderProperty, Set<String>> extractHeaderPropertyValues(Collection<DataColumnHeader> headers) {
        return HeaderUtils.extractHeaderPropertyValues(headers, Arrays.asList(DataHeaderProperty.values()));
    }

    private static Map<DataHeaderProperty, Set<String>> extractHeaderPropertyValues(Collection<DataColumnHeader> headers, Collection<DataHeaderProperty> properties) {
        HashMap<DataHeaderProperty, Set<String>> map = new HashMap<DataHeaderProperty, Set<String>>();
        for (DataColumnHeader dataColumnHeader : headers) {
            for (DataHeaderProperty p : properties) {
                HeaderUtils.updateMap(map, p, p.getValue(dataColumnHeader));
            }
        }
        return map;
    }

    private static void updateMap(Map<DataHeaderProperty, Set<String>> map, DataHeaderProperty property, String value) {
        if (!map.containsKey((Object)property)) {
            map.put(property, new HashSet());
        }
        map.get((Object)property).add(value);
    }

    private static Collection<DataColumnHeader> loadHeaders(File dir, boolean ignoreEmptyLines, boolean ignoreHashedLines) {
        ArrayList<DataColumnHeader> headers = new ArrayList<DataColumnHeader>();
        List<File> tsvFiles = HeaderUtils.listFiles(dir);
        for (File tsvFile : tsvFiles) {
            headers.addAll(HeaderUtils.loadHeadersFromFile(tsvFile, ignoreEmptyLines, ignoreHashedLines));
        }
        return headers;
    }

    static File getTabSeparatedValueFile(File dir) {
        List<File> files = HeaderUtils.listFiles(dir);
        if (files.size() > 1) {
            throw new UserFailureException("Exactly one file with extensions [" + StringUtils.join((Object[])TSV_EXTENSIONS) + "] expected instead of " + files.size());
        }
        return files.get(0);
    }

    private static List<File> listFiles(File dir) {
        List tsvFiles = FileUtilities.listFiles((File)dir, (String[])TSV_EXTENSIONS, (boolean)true, null);
        if (tsvFiles.size() == 0) {
            throw new UserFailureException(String.format("Could not find any files with extensions [%s].", StringUtils.join((Object[])TSV_EXTENSIONS, (String)",")));
        }
        return tsvFiles;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Collection<DataColumnHeader> loadHeadersFromFile(File tsvFile, boolean ignoreEmptyLines, boolean ignoreHashedLines) {
        Collection<DataColumnHeader> collection;
        FileReader reader = null;
        try {
            reader = new FileReader(tsvFile);
            String fileName = tsvFile.toString();
            TabSeparatedValueTable table = new TabSeparatedValueTable((Reader)reader, fileName, ignoreEmptyLines, false, ignoreHashedLines);
            List columns = table.getColumns();
            collection = HeaderUtils.extractDataColumnHeaders(columns);
        }
        catch (RuntimeException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return collection;
    }

    private static NewProperty extractProperty(TimeSeriesPropertyType timeSeriesPropertyType, boolean multipleValuesAllowed, Map<DataHeaderProperty, Set<String>> map) {
        String propertyValue = HeaderUtils.getPropertyValue(timeSeriesPropertyType.getHeaderProperty(), map, multipleValuesAllowed || timeSeriesPropertyType.isMultipleValues());
        if (propertyValue == null) {
            return null;
        }
        NewProperty newProperty = new NewProperty(timeSeriesPropertyType.name(), propertyValue);
        return newProperty;
    }

    @Private
    static String getPropertyValue(DataHeaderProperty property, Map<DataHeaderProperty, Set<String>> map, boolean multipleValuesAllowed) {
        return HeaderUtils.getPropertyValue(property, map, multipleValuesAllowed, true);
    }

    @Private
    static String getPropertyValue(DataHeaderProperty property, Map<DataHeaderProperty, Set<String>> map, boolean multipleValuesAllowed, boolean treatQuantifiedPeptidesAsProteins) {
        Set<String> set = map.get((Object)property);
        if (set == null || set.size() < 1) {
            String message = String.format("%s not defined", property.name());
            throw new UserFailureException(message);
        }
        Iterator<String> iterator = set.iterator();
        if (set.size() == 1) {
            return iterator.next();
        }
        if (!multipleValuesAllowed) {
            String second;
            String first;
            if (treatQuantifiedPeptidesAsProteins && property.equals((Object)DataHeaderProperty.DataSetType) && set.size() == 2 && HeaderUtils.equal(first = iterator.next(), second = iterator.next(), PROTEIN_LCMS_RATIO, QUANTIFIED_PEPTIDES)) {
                return PROTEIN_LCMS_RATIO;
            }
            String message = String.format("Inconsistent header values of '%s'. Expected the same value in all the columns, found: [%s].", property.name(), StringUtils.join(set, (String)LIST_SEPARATOR));
            throw new UserFailureException(message);
        }
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                try {
                    int i1 = Integer.parseInt(s1);
                    int i2 = Integer.parseInt(s2);
                    return i1 - i2;
                }
                catch (NumberFormatException numberFormatException) {
                    return s1.compareTo(s2);
                }
            }
        });
        return HeaderUtils.join(list);
    }

    static String join(List<String> list) {
        return HeaderUtils.join(list, LIST_SEPARATOR, 200);
    }

    @Private
    static String join(List<String> list, String separator, int maxSize) {
        String lastElement = list.get(list.size() - 1);
        int maxSizeWithoutLastElement = maxSize - separator.length() - lastElement.length();
        int n = 0;
        int totalLength = 0;
        while (n < list.size() - 1) {
            int length = HeaderUtils.calculateLengthOfElement(list, n, separator);
            if ((totalLength += length) > maxSizeWithoutLastElement) {
                if ((totalLength -= length) + (length = (n == 0 ? 0 : separator.length()) + DOTS.length()) <= maxSizeWithoutLastElement) break;
                --n;
                break;
            }
            ++n;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < n) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(list.get(i));
            ++i;
        }
        if (n < list.size() - 1) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(DOTS);
        }
        builder.append(separator).append(lastElement);
        return builder.toString();
    }

    private static int calculateLengthOfElement(List<String> list, int i, String separator) {
        return (i == 0 ? 0 : separator.length()) + list.get(i).length();
    }

    private static boolean equal(String first, String second, String expectedFirst, String expectedSecond) {
        return first.equals(expectedFirst) && second.equals(expectedSecond) || first.equals(expectedSecond) && second.equals(expectedFirst);
    }

    public static List<NewProperty> extractHeaderProperties(File dir, boolean ignoreEmptyLines) {
        return HeaderUtils.extractHeaderProps(dir, ignoreEmptyLines, false, false, new TimeSeriesPropertyType[0]);
    }

    public static List<NewProperty> extractHeaderPropertiesIgnoringTimeSeriesDataSetType(File dir, boolean ignoreEmptyLines, boolean ignoreHashedLines, boolean multipleValuesAllowed) {
        return HeaderUtils.extractHeaderProps(dir, ignoreEmptyLines, ignoreHashedLines, multipleValuesAllowed, TimeSeriesPropertyType.TIME_SERIES_DATA_SET_TYPE);
    }

    static List<NewProperty> extractHeaderProps(File dir, boolean ignoreEmptyLines, boolean ignoreHashedLines, boolean multipleValuesAllowed, TimeSeriesPropertyType ... ignoredTypes) {
        HashSet<TimeSeriesPropertyType> typesToBeIgnored = new HashSet<TimeSeriesPropertyType>(Arrays.asList(ignoredTypes));
        Collection<DataColumnHeader> headers = HeaderUtils.loadHeaders(dir, ignoreEmptyLines, ignoreHashedLines);
        Map<DataHeaderProperty, Set<String>> values = HeaderUtils.extractHeaderPropertyValues(headers);
        ArrayList<NewProperty> headerProperties = new ArrayList<NewProperty>();
        TimeSeriesPropertyType[] timeSeriesPropertyTypeArray = TIME_SERIES_HEADER_PROPERTIES;
        int n = TIME_SERIES_HEADER_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            TimeSeriesPropertyType pt = timeSeriesPropertyTypeArray[n2];
            if (!typesToBeIgnored.contains((Object)pt)) {
                NewProperty property = HeaderUtils.extractProperty(pt, multipleValuesAllowed, values);
                if (property == null) {
                    if (!pt.isOptional()) {
                        throw new UserFailureException("Header property '" + (Object)((Object)pt) + "' missing.");
                    }
                } else {
                    headerProperties.add(property);
                }
            }
            ++n2;
        }
        return headerProperties;
    }

    public static boolean isDataColumnHeader(String header) {
        return DATA_COLUMN_HEADER_PATTERN.matcher(header).matches();
    }

    public static void assertMetadataConsistent(Collection<DataColumnHeader> headers, Collection<DataHeaderProperty> consistentProperties) {
        Map<DataHeaderProperty, Set<String>> map = HeaderUtils.extractHeaderPropertyValues(headers, consistentProperties);
        StringBuilder sb = new StringBuilder();
        for (DataHeaderProperty key : map.keySet()) {
            if (map.get((Object)key).size() <= 1) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((Object)key);
            sb.append("(");
            sb.append(StringUtils.join((Collection)map.get((Object)key), (String)","));
            sb.append(")");
        }
        if (sb.length() > 0) {
            throw new UserFailureException("Inconsistent data column headers: [" + sb + "]");
        }
    }
}

