/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.cina.client.util.cli.AbstractCinaCommand;
import ch.systemsx.cisd.cina.client.util.cli.AbstractExecutor;
import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;

public class CommandGenerateSampleCode
extends AbstractCinaCommand<CommandGenerateSampleCodeArguments> {
    public CommandGenerateSampleCode() {
        super(new CommandGenerateSampleCodeArguments());
    }

    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new GenerateSampleIdExecutor(this).execute(args);
    }

    public String getName() {
        return "gencode";
    }

    protected String getRequiredArgumentsString() {
        return "<sample type code>";
    }

    static class CommandGenerateSampleCodeArguments
    extends GlobalArguments {
        CommandGenerateSampleCodeArguments() {
        }

        public String getSampleTypeCode() {
            return ((String)this.getArguments().get(0)).toString().toUpperCase();
        }

        public boolean allAdditionalMandatoryArgumentsPresent() {
            if (this.getArguments().size() < 1) {
                return false;
            }
            return this.getSampleTypeCode().length() >= 1;
        }
    }

    private static class GenerateSampleIdExecutor
    extends AbstractExecutor<CommandGenerateSampleCodeArguments> {
        GenerateSampleIdExecutor(CommandGenerateSampleCode command) {
            super(command);
        }

        @Override
        protected ResultCode doExecute(ICinaUtilities component) {
            String sampleTypeCode = ((CommandGenerateSampleCodeArguments)this.arguments).getSampleTypeCode();
            String result = component.generateSampleCode(sampleTypeCode);
            System.out.println(result);
            return ResultCode.OK;
        }
    }
}

