/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.dss.bundle.registrators;

import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleRegistrationState;
import ch.systemsx.cisd.cina.shared.metadata.IMetadataExtractor;
import ch.systemsx.cisd.etlserver.IDataSetHandlerRpc;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyTypeWithVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

abstract class BundleDataSetHelper {
    private static final String MISC_DATA_SET_PROPERTY_CODE = "MISC";
    protected final BundleRegistrationState globalState;
    protected final File dataSet;
    protected final ArrayList<DataSetInformation> registeredDataSets;

    BundleDataSetHelper(BundleRegistrationState globalState, File dataSet) {
        this.globalState = globalState;
        this.dataSet = dataSet;
        this.registeredDataSets = new ArrayList();
    }

    public ArrayList<DataSetInformation> getDataSetInformation() {
        return this.registeredDataSets;
    }

    protected List<DataSetInformation> registerDataSet(File dataSetFile, DataSetInformation dataSetInfo) {
        List bigDataSet = this.getDelegator().handleDataSet(dataSetFile, dataSetInfo);
        this.registeredDataSets.addAll(bigDataSet);
        return bigDataSet;
    }

    protected List<DataSetInformation> registerLinkedDataSet(File dataSetFile, DataSetInformation dataSetInfo) {
        List bigDataSet = this.getDelegator().linkAndHandleDataSet(dataSetFile, dataSetInfo);
        this.registeredDataSets.addAll(bigDataSet);
        return bigDataSet;
    }

    protected IEncapsulatedOpenBISService getOpenbisService() {
        return this.globalState.getOpenbisService();
    }

    protected IDataSetHandlerRpc getDelegator() {
        return this.globalState.getDelegator();
    }

    protected SessionContextDTO getSessionContext() {
        return this.globalState.getSessionContext();
    }

    protected ArrayList<NewProperty> createDataSetProperties(DataSetTypeWithVocabularyTerms type, IMetadataExtractor metadata) {
        List propertyTypes = type.getPropertyTypes();
        ArrayList<NewProperty> properties = new ArrayList<NewProperty>();
        for (PropertyTypeWithVocabulary propertyType : propertyTypes) {
            String value = metadata.getMetadataMap().get(propertyType.getCode().toLowerCase());
            if (value == null) continue;
            NewProperty prop = new NewProperty(propertyType.getCode(), value);
            properties.add(prop);
        }
        properties.add(new NewProperty(MISC_DATA_SET_PROPERTY_CODE, metadata.getMetadataMap().toString()));
        return properties;
    }
}

