/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ITerminableFuture;
import ch.systemsx.cisd.common.concurrent.TerminableCallable;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.ServiceConversationDTO;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.common.serviceconversation.UnknownClientException;
import ch.systemsx.cisd.common.serviceconversation.UnknownServiceTypeException;
import ch.systemsx.cisd.common.serviceconversation.client.ServiceExecutionException;
import ch.systemsx.cisd.common.serviceconversation.server.BidirectionalServiceMessenger;
import ch.systemsx.cisd.common.serviceconversation.server.ConversationMap;
import ch.systemsx.cisd.common.serviceconversation.server.IService;
import ch.systemsx.cisd.common.serviceconversation.server.IServiceFactory;
import ch.systemsx.cisd.common.serviceconversation.server.ProgressInfo;
import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationRecord;
import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationServerConfig;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ServiceConversationServer {
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ServiceConversationServer.class);
    private final int shutdownTimeoutMillis;
    private final NamingThreadPoolExecutor executor;
    private final Map<String, IServiceFactory> serviceFactoryMap = new ConcurrentHashMap<String, IServiceFactory>();
    private final Map<String, IServiceMessageTransport> responseMessageMap = new ConcurrentHashMap<String, IServiceMessageTransport>();
    private final ConversationMap conversations = new ConversationMap();
    private final Random rng = new Random();
    private final IServiceMessageTransport incomingTransport = new IServiceMessageTransport(){

        @Override
        public void send(ServiceMessage message) {
            String conversationId = message.getConversationId();
            ServiceConversationRecord record = ServiceConversationServer.this.conversations.get(conversationId);
            if (record == null) {
                if (!ServiceConversationServer.this.conversations.recentlySeen(conversationId)) {
                    operationLog.error((Object)String.format("Message for unknown service conversation '%s'", conversationId));
                }
                return;
            }
            if (message.hasPayload()) {
                record.getMessenger().sendToService(message);
            } else if (this.serviceShouldBeInterrupted(record, message)) {
                if (message.isException()) {
                    operationLog.error((Object)String.format("[id: %s] Client execution exception.\n%s", conversationId, message.tryGetExceptionDescription()));
                } else {
                    operationLog.error((Object)String.format("[id: %s] Client requests termination of service conversation.", conversationId));
                }
                record.getMessenger().markAsInterrupted();
                record.getController().cancel(true);
            }
        }

        private boolean serviceShouldBeInterrupted(ServiceConversationRecord record, ServiceMessage message) {
            if (record.getMessenger().isMarkedAsInterrupted()) {
                return false;
            }
            return message.isTerminate() || record.isInterruptServerOnClientException();
        }
    };

    public ServiceConversationServer() {
        this(ServiceConversationServerConfig.create());
    }

    public ServiceConversationServer(ServiceConversationServerConfig config) {
        this.executor = new NamingThreadPoolExecutor("Service Conversations", config.getWorkQueueSize()).corePoolSize(config.getNumberOfCoreThreads()).maximumPoolSize(config.getMaxNumberOfThreads());
        if (config.isDaemonize()) {
            this.executor.daemonize();
        }
        this.shutdownTimeoutMillis = config.getShutdownTimeoutMillis();
    }

    public void addServiceType(IServiceFactory factory) {
        String id = factory.getServiceTypeId();
        if (this.serviceFactoryMap.containsKey(id)) {
            throw new IllegalArgumentException("Service type '" + id + "' is already registered.");
        }
        this.serviceFactoryMap.put(id, factory);
    }

    public void addClientResponseTransport(String clientId, IServiceMessageTransport responseTransport) {
        this.responseMessageMap.put(clientId, responseTransport);
    }

    public boolean removeClientResponseTransport(String clientId) {
        return this.responseMessageMap.remove(clientId) != null;
    }

    public IServiceMessageTransport getIncomingMessageTransport() {
        return this.incomingTransport;
    }

    public ServiceConversationDTO startConversation(final String typeId, String clientId, int messageReceivingTimeoutMillis) {
        IServiceFactory serviceFactory = this.serviceFactoryMap.get(typeId);
        if (serviceFactory == null) {
            throw new UnknownServiceTypeException(typeId);
        }
        IServiceMessageTransport responseMessenger = this.responseMessageMap.get(clientId);
        if (responseMessenger == null) {
            UnknownClientException ex = new UnknownClientException(clientId);
            operationLog.error((Object)ex.getMessage());
            throw ex;
        }
        final IService serviceInstance = serviceFactory.create();
        final String serviceConversationId = String.valueOf(Long.toString(System.currentTimeMillis())) + "-" + this.rng.nextInt(Integer.MAX_VALUE);
        final BidirectionalServiceMessenger messenger = new BidirectionalServiceMessenger(serviceConversationId, messageReceivingTimeoutMillis, responseMessenger);
        ServiceConversationRecord record = new ServiceConversationRecord(messenger, serviceFactory.interruptServiceOnClientException());
        this.conversations.put(serviceConversationId, record);
        try {
            ITerminableFuture<Void> controller = ConcurrencyUtilities.submit((ExecutorService)this.executor, new TerminableCallable.INamedCallable<Void>(){

                @Override
                public Void call(TerminableCallable.IStoppableExecutor<Void> stoppableExecutor) throws Exception {
                    try {
                        try {
                            serviceInstance.run(messenger.getServiceMessenger());
                        }
                        catch (Throwable ex) {
                            if (!(ex instanceof InterruptedExceptionUnchecked)) {
                                String errorMessage = ServiceExecutionException.getDescriptionFromException(ex);
                                try {
                                    messenger.getServiceMessenger().sendException(errorMessage);
                                }
                                catch (Exception ex2) {
                                    operationLog.error((Object)String.format("[id: %s] Cannot send message about exception to client.", serviceConversationId), (Throwable)ex2);
                                }
                            }
                            ServiceConversationServer.this.conversations.remove(serviceConversationId);
                        }
                    }
                    finally {
                        ServiceConversationServer.this.conversations.remove(serviceConversationId);
                    }
                    return null;
                }

                @Override
                public String getCallableName() {
                    return String.valueOf(serviceConversationId) + " (" + typeId + ")";
                }
            });
            record.setController(controller);
            return new ServiceConversationDTO(serviceConversationId, serviceFactory.getClientTimeoutMillis(), this.executor.getQueue().size());
        }
        catch (Throwable th) {
            this.conversations.remove(serviceConversationId);
            throw CheckedExceptionTunnel.wrapIfNecessary(th);
        }
    }

    public boolean shutdown() {
        try {
            for (ServiceConversationRecord record : this.conversations.values()) {
                record.getController().cancel(true);
            }
            return this.executor.awaitTermination(this.shutdownTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new CheckedExceptionTunnel(ex);
        }
    }

    public boolean shutdownNow() {
        try {
            for (ServiceConversationRecord record : this.conversations.values()) {
                record.getController().cancel(true);
            }
            return this.executor.awaitTermination(0L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new CheckedExceptionTunnel(ex);
        }
    }

    public boolean hasConversation(String conversationId) {
        return this.conversations.containsKey(conversationId);
    }

    public void reportProgress(String conversationId, ProgressInfo progress) {
        if (conversationId == null) {
            return;
        }
        if (!this.hasConversation(conversationId)) {
            operationLog.warn((Object)("Progress reporting failed (" + progress + "). Conversation with id " + conversationId + " does not exist"));
            return;
        }
        BidirectionalServiceMessenger messenger = this.conversations.get(conversationId).getMessenger();
        messenger.getServiceMessenger().sendProgress(progress);
    }
}

