/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.conversation.annotation.Conversational;
import ch.systemsx.cisd.openbis.common.conversation.annotation.Progress;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.ISessionProvider;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityOperationsState;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ArchiverDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentWithContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationResult;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetShareId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServerInfo;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityCollectionForCreationOrUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.ListSamplesByPropertyCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public interface IServiceForDataStoreServer
extends IServer,
ISessionProvider {
    @Transactional(readOnly=true)
    public DatabaseInstance getHomeDatabaseInstance(String var1);

    @Transactional
    public void registerDataStoreServer(String var1, DataStoreServerInfo var2);

    @Transactional(readOnly=true)
    public Experiment tryGetExperiment(String var1, ExperimentIdentifier var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public Material tryGetMaterial(String var1, MaterialIdentifier var2);

    @Transactional(readOnly=true)
    public Metaproject tryGetMetaproject(String var1, String var2, String var3);

    @Transactional(readOnly=true)
    public SampleIdentifier tryGetSampleIdentifier(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public Map<String, SampleIdentifier> listSamplesByPermId(String var1, List<String> var2);

    @Transactional(readOnly=true)
    public ExperimentType getExperimentType(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public Sample tryGetSampleWithExperiment(String var1, SampleIdentifier var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public Collection<VocabularyTerm> listVocabularyTerms(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public Vocabulary tryGetVocabulary(String var1, String var2);

    @Transactional(readOnly=true)
    public SampleType getSampleType(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public DataSetTypeWithVocabularyTerms getDataSetType(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<AbstractExternalData> listDataSetsByExperimentID(String var1, TechId var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<AbstractExternalData> listDataSetsBySampleID(String var1, TechId var2, boolean var3) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<AbstractExternalData> listDataSetsByCode(String var1, List<String> var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<Sample> listSamples(String var1, ListSampleCriteria var2);

    @Transactional(readOnly=true)
    public IEntityProperty[] tryGetPropertiesOfTopSample(String var1, SampleIdentifier var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public IEntityProperty[] tryGetPropertiesOfSample(String var1, SampleIdentifier var2) throws UserFailureException;

    @Transactional
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DATA_SET})
    public void registerEntities(String var1, EntityCollectionForCreationOrUpdate var2) throws UserFailureException;

    @Transactional
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT})
    public long registerExperiment(String var1, NewExperiment var2) throws UserFailureException;

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    public void registerSamples(String var1, List<NewSamplesWithTypes> var2, String var3) throws UserFailureException;

    @Transactional
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    public long registerSample(String var1, NewSample var2, String var3) throws UserFailureException;

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    public void updateSample(String var1, SampleUpdatesDTO var2);

    @Transactional
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void registerDataSet(String var1, SampleIdentifier var2, NewExternalData var3) throws UserFailureException;

    @Transactional
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void registerDataSet(String var1, ExperimentIdentifier var2, NewExternalData var3) throws UserFailureException;

    @Transactional(readOnly=true)
    public void checkInstanceAdminAuthorization(String var1) throws UserFailureException;

    @Transactional(readOnly=true)
    public void checkSpacePowerUserAuthorization(String var1) throws UserFailureException;

    @Transactional(readOnly=true)
    public void checkDataSetAccess(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public void checkDataSetCollectionAccess(String var1, List<String> var2);

    @Transactional(readOnly=true)
    public IDatasetLocationNode tryGetDataSetLocation(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public AbstractExternalData tryGetDataSet(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public AbstractExternalData tryGetThinDataSet(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public AbstractExternalData tryGetLocalDataSet(String var1, String var2, String var3) throws UserFailureException;

    @Transactional
    public String createPermId(String var1) throws UserFailureException;

    @Transactional
    public List<String> createPermIds(String var1, int var2) throws UserFailureException;

    @Transactional
    public long drawANewUniqueID(String var1) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<Sample> listSamplesByCriteria(String var1, ListSamplesByPropertyCriteria var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<DataSetShareId> listShareIds(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<SimpleDataSetInformationDTO> listPhysicalDataSets(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<SimpleDataSetInformationDTO> listOldestPhysicalDataSets(String var1, String var2, int var3) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<SimpleDataSetInformationDTO> listOldestPhysicalDataSets(String var1, String var2, Date var3, int var4) throws UserFailureException;

    @Transactional(readOnly=true)
    public List<SimpleDataSetInformationDTO> listPhysicalDataSetsWithUnknownSize(String var1, String var2, int var3, String var4);

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void updatePhysicalDataSetsSize(String var1, Map<String, Long> var2);

    @Transactional(readOnly=true)
    public List<DeletedDataSet> listDeletedDataSets(String var1, Long var2, Date var3);

    @Transactional(readOnly=true)
    public List<AbstractExternalData> listAvailableDataSets(String var1, String var2, ArchiverDataSetCriteria var3);

    @Transactional(readOnly=true)
    public List<AbstractExternalData> listDataSets(String var1, String var2, TrackingDataSetCriteria var3);

    @Transactional(readOnly=true)
    public List<Experiment> listExperiments(String var1, ProjectIdentifier var2);

    @Transactional(readOnly=true)
    public List<Experiment> listExperiments(String var1, List<ExperimentIdentifier> var2, ExperimentFetchOptions var3);

    @Transactional(readOnly=true)
    public List<Experiment> listExperimentsForProjects(String var1, List<ProjectIdentifier> var2, ExperimentFetchOptions var3);

    @Transactional(readOnly=true)
    public List<Project> listProjects(String var1);

    @Transactional(readOnly=true)
    public List<Material> listMaterials(String var1, ListMaterialCriteria var2, boolean var3);

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void addPropertiesToDataSet(String var1, List<NewProperty> var2, String var3, SpaceIdentifier var4) throws UserFailureException;

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void updateShareIdAndSize(String var1, String var2, String var3, long var4) throws UserFailureException;

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void updateDataSetStatuses(String var1, List<String> var2, DataSetArchivingStatus var3, boolean var4) throws UserFailureException;

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public boolean compareAndSetDataSetStatus(String var1, String var2, DataSetArchivingStatus var3, DataSetArchivingStatus var4, boolean var5) throws UserFailureException;

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public int archiveDatasets(String var1, List<String> var2, boolean var3);

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public int unarchiveDatasets(String var1, List<String> var2);

    @Transactional(readOnly=true)
    public void checkSpaceAccess(String var1, SpaceIdentifier var2);

    @Transactional
    public List<String> generateCodes(String var1, String var2, ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind var3, int var4);

    @Transactional(readOnly=true)
    public List<Person> listAdministrators(String var1);

    @Transactional(readOnly=true)
    public Person tryPersonWithUserIdOrEmail(String var1, String var2);

    @Transactional
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DATA_SET})
    public Sample registerSampleAndDataSet(String var1, NewSample var2, NewExternalData var3, String var4) throws UserFailureException;

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public Sample updateSampleAndRegisterDataSet(String var1, SampleUpdatesDTO var2, NewExternalData var3);

    @Transactional
    @Conversational(progress=Progress.MANUAL)
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.DATA_SET})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SPACE, DatabaseModificationKind.ObjectKind.PROJECT, DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.DATA_SET})
    public AtomicEntityOperationResult performEntityOperations(String var1, AtomicEntityOperationDetails var2);

    @Transactional(readOnly=true)
    public Space tryGetSpace(String var1, SpaceIdentifier var2);

    @Transactional(readOnly=true)
    public Project tryGetProject(String var1, ProjectIdentifier var2);

    @Transactional(readOnly=true)
    public List<Sample> searchForSamples(String var1, SearchCriteria var2);

    @Transactional(readOnly=true)
    public List<AbstractExternalData> searchForDataSets(String var1, SearchCriteria var2);

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.EXPERIMENT})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void removeDataSetsPermanently(String var1, List<String> var2, String var3);

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DATA_SET})
    public void updateDataSet(String var1, DataSetUpdatesDTO var2);

    @Transactional
    public List<String> getTrustedCrossOriginDomains(String var1);

    @Transactional
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.POSTREGISTRATION_QUEUE})
    public void setStorageConfirmed(String var1, String var2);

    @Transactional
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.POSTREGISTRATION_QUEUE})
    public void markSuccessfulPostRegistration(String var1, String var2);

    @Transactional
    public void notifyDatasetAccess(String var1, String var2);

    @Transactional
    public List<AbstractExternalData> listDataSetsForPostRegistration(String var1, String var2);

    @Transactional(readOnly=true)
    public EntityOperationsState didEntityOperationsSucceed(String var1, TechId var2);

    @Transactional(readOnly=true)
    public void heartbeat(String var1);

    @Transactional(readOnly=true)
    public boolean doesUserHaveRole(String var1, String var2, String var3, String var4);

    @Transactional(readOnly=true)
    public List<String> filterToVisibleDataSets(String var1, String var2, List<String> var3);

    @Transactional(readOnly=true)
    public List<String> filterToVisibleExperiments(String var1, String var2, List<String> var3);

    @Transactional(readOnly=true)
    public List<String> filterToVisibleSamples(String var1, String var2, List<String> var3);

    @Transactional(readOnly=true)
    public ExternalDataManagementSystem tryGetExternalDataManagementSystem(String var1, String var2);

    @Transactional(readOnly=true)
    public List<? extends EntityTypePropertyType<?>> listPropertyDefinitionsForType(String var1, String var2, EntityKind var3);

    @Transactional(readOnly=true)
    public List<Metaproject> listMetaprojects(String var1, String var2);

    @Transactional(readOnly=true)
    public MetaprojectAssignments getMetaprojectAssignments(String var1, String var2, String var3, EnumSet<MetaprojectAssignmentsFetchOption> var4);

    @Transactional(readOnly=true)
    public List<Metaproject> listMetaprojectsForEntity(String var1, String var2, IObjectId var3);

    @Transactional(readOnly=true)
    public List<AuthorizationGroup> listAuthorizationGroups(String var1);

    @Transactional(readOnly=true)
    public List<AuthorizationGroup> listAuthorizationGroupsForUser(String var1, String var2);

    @Transactional(readOnly=true)
    public List<Person> listUsersForAuthorizationGroup(String var1, TechId var2);

    @Transactional(readOnly=true)
    public List<RoleAssignment> listRoleAssignments(String var1);

    @Transactional(readOnly=true)
    public List<Attachment> listAttachments(String var1, AttachmentHolderKind var2, Long var3);

    @Transactional(readOnly=true)
    public AttachmentWithContent getAttachment(String var1, AttachmentHolderKind var2, Long var3, String var4, Integer var5);
}

