/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.DssSessionAuthorizationHolder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.authorization.IAuthorizationGuardPredicate;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.Arrays;
import java.util.List;

public class NewDataSetPredicate
implements IAuthorizationGuardPredicate<IDssServiceRpcGeneric, NewDataSetDTO> {
    @Override
    public List<String> getDataSetCodes(NewDataSetDTO argument) {
        return Arrays.asList(new String[0]);
    }

    @Override
    public Status evaluate(IDssServiceRpcGeneric receiver, String sessionToken, NewDataSetDTO newDataSet) throws UserFailureException {
        NewDataSetDTO.DataSetOwner owner = newDataSet.getDataSetOwner();
        String ownerIdentifier = owner.getIdentifier();
        switch (owner.getType()) {
            case EXPERIMENT: {
                ExperimentIdentifier experimentId = new ExperimentIdentifierFactory(ownerIdentifier).createIdentifier();
                SpaceIdentifier spaceId = new SpaceIdentifier(experimentId.getDatabaseInstanceCode(), experimentId.getSpaceCode());
                return DssSessionAuthorizationHolder.getAuthorizer().checkSpaceWriteable(sessionToken, spaceId);
            }
            case SAMPLE: {
                SampleIdentifier sampleId = new SampleIdentifierFactory(ownerIdentifier).createIdentifier();
                SpaceIdentifier spaceId = sampleId.getSpaceLevel();
                return DssSessionAuthorizationHolder.getAuthorizer().checkSpaceWriteable(sessionToken, spaceId);
            }
            case DATA_SET: {
                return DssSessionAuthorizationHolder.getAuthorizer().checkDatasetAccess(sessionToken, ownerIdentifier);
            }
        }
        return null;
    }
}

