/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.shared.translator;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.ExpressionUtil;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.GridCustomExpressionTranslator;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryDatabaseDefinitionProvider;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryDatabase;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import java.util.ArrayList;
import java.util.List;

public final class QueryTranslator {
    private QueryTranslator() {
    }

    public static final List<QueryExpression> translate(List<QueryPE> queries, IQueryDatabaseDefinitionProvider dbDefinitionProvider) {
        ArrayList<QueryExpression> result = new ArrayList<QueryExpression>();
        for (QueryPE query : queries) {
            String dbKey = query.getQueryDatabaseKey();
            DatabaseDefinition database = dbDefinitionProvider.getDefinition(dbKey);
            if (database != null) {
                result.add(QueryTranslator.translate(query, database));
                continue;
            }
            UserFailureException.fromTemplate("Query database '%s' is not defined.", dbKey);
        }
        return result;
    }

    public static final QueryExpression translate(QueryPE original, DatabaseDefinition database) {
        if (original == null) {
            return null;
        }
        QueryExpression result = new QueryExpression();
        result.setName(original.getName());
        result.setQueryDatabase(new QueryDatabase(database.getKey(), database.getLabel()));
        result.setQueryType(original.getQueryType());
        result.setEntityTypeCode(original.getEntityTypeCodePattern());
        result.setupParameters(ExpressionUtil.extractParameters(original.getExpression()));
        GridCustomExpressionTranslator.translateExpression(original, result);
        return result;
    }
}

