/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.core.rules.process.ComparisonOperator;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import java.util.Comparator;

public class CompareversionsCondition
extends Condition {
    private static final long serialVersionUID = 5631805710151645907L;
    protected String operand1;
    protected String operand2;
    protected ComparisonOperator operator = ComparisonOperator.EQUAL;

    public CompareversionsCondition(String op1, String op2) {
        this.operand1 = op1;
        this.operand2 = op2;
    }

    public CompareversionsCondition() {
    }

    public String getLeftOperand() {
        return this.operand1;
    }

    public void setLeftOperand(String value) {
        this.operand1 = value;
    }

    public String getRightOperand() {
        return this.operand2;
    }

    public void setRightOperand(String value) {
        this.operand2 = value;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ComparisonOperator operator) {
        this.operator = operator;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        this.operand1 = xmlcondition.getFirstChildNamed("arg1").getContent();
        if (this.operand1 == null) {
            throw new Exception("Missing \"arg1\" element in condition \"" + this.getId() + "\"");
        }
        this.operand2 = xmlcondition.getFirstChildNamed("arg2").getContent();
        if (this.operand2 == null) {
            throw new Exception("Missing \"arg2\" element in condition \"" + this.getId() + "\"");
        }
        String operatorAttr = xmlcondition.getFirstChildNamed("operator").getContent();
        if (operatorAttr != null) {
            this.operator = ComparisonOperator.getComparisonOperatorFromAttribute(operatorAttr);
            if (this.operator == null) {
                throw new Exception("Unknown \"operator\" element value \"" + operatorAttr + "\" in condition \"" + this.getId() + "\"");
            }
        } else {
            throw new Exception("Missing \"operator\" element in condition \"" + this.getId() + "\"");
        }
    }

    @Override
    public boolean isTrue() {
        boolean result = false;
        if (this.getInstallData() != null && this.operand1 != null && this.operand2 != null) {
            VariableSubstitutorImpl subst = new VariableSubstitutorImpl(this.getInstallData().getVariables());
            String arg1 = subst.substitute(this.operand1);
            String arg2 = subst.substitute(this.operand2);
            if (this.operator == null) {
                this.operator = ComparisonOperator.EQUAL;
            }
            int res = new VersionStringComparator().compare(arg1, arg2);
            switch (this.operator) {
                case EQUAL: {
                    result = res == 0;
                    break;
                }
                case NOTEQUAL: {
                    result = res != 0;
                    break;
                }
                case GREATER: {
                    result = res > 0;
                    break;
                }
                case GREATEREQUAL: {
                    result = res >= 0;
                    break;
                }
                case LESS: {
                    result = res < 0;
                    break;
                }
                case LESSEQUAL: {
                    result = res <= 0;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on the values <b>");
        details.append(this.operand1);
        details.append("</b> and <b>");
        details.append(this.operand2);
        details.append("</b>");
        details.append("This value has to be <b>" + (Object)((Object)this.operator));
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameXml = new XMLElementImpl("arg1", conditionRoot);
        nameXml.setContent(this.operand1);
        conditionRoot.addChild(nameXml);
        XMLElementImpl valueXml = new XMLElementImpl("arg2", conditionRoot);
        valueXml.setContent(this.operand2);
        conditionRoot.addChild(valueXml);
        XMLElementImpl opXml = new XMLElementImpl("operator", conditionRoot);
        opXml.setContent(this.operator.getAttribute());
        conditionRoot.addChild(opXml);
    }

    private static class VersionStringComparator
    implements Comparator<String> {
        private VersionStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            String[] arr1 = s1.split("[^a-zA-Z0-9_]+");
            String[] arr2 = s2.split("[^a-zA-Z0-9_]+");
            int ii = 0;
            int max = Math.min(arr1.length, arr2.length);
            while (ii <= max) {
                int i2;
                int i1;
                if (ii == arr1.length) {
                    return ii == arr2.length ? 0 : -1;
                }
                if (ii == arr2.length) {
                    return 1;
                }
                try {
                    i1 = Integer.parseInt(arr1[ii]);
                }
                catch (Exception x) {
                    i1 = Integer.MAX_VALUE;
                }
                try {
                    i2 = Integer.parseInt(arr2[ii]);
                }
                catch (Exception x) {
                    i2 = Integer.MAX_VALUE;
                }
                if (i1 != i2) {
                    return i1 - i2;
                }
                int i3 = arr1[ii].compareTo(arr2[ii]);
                if (i3 != 0) {
                    return i3;
                }
                ++ii;
            }
            return 0;
        }
    }
}

