/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class EmptyCondition
extends Condition {
    private static final long serialVersionUID = -4626906695822723409L;
    private ContentType contentType;
    private String content;

    @Override
    public boolean isTrue() {
        boolean result = false;
        VariableSubstitutorImpl subst = new VariableSubstitutorImpl(this.getInstallData().getVariables());
        switch (this.contentType) {
            case STRING: {
                if (this.content == null) {
                    return true;
                }
                String s = subst.substitute(this.content);
                if (s == null || s.length() != 0) break;
                result = true;
                break;
            }
            case VARIABLE: {
                String value;
                if (this.content == null || (value = this.getInstallData().getVariable(this.content)) == null || value.length() != 0) break;
                result = true;
                break;
            }
            case FILE: {
                File file;
                if (this.content == null || (file = new File(subst.substitute(this.content))).exists() || file.length() != 0L) break;
                result = true;
                break;
            }
            case DIR: {
                File file;
                if (this.content == null || (file = new File(subst.substitute(this.content))).exists() && (!file.isDirectory() || file.listFiles().length != 0)) break;
                result = true;
                break;
            }
            default: {
                Debug.error("Illegal content type '" + this.contentType.getAttribute() + "' of ExistsCondition");
            }
        }
        return result;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition != null) {
            if (xmlcondition.getChildrenCount() != 1) {
                throw new Exception("Condition \"" + this.getId() + "\" needs exactly one nested element");
            }
            IXMLElement child = xmlcondition.getChildAtIndex(0);
            this.contentType = ContentType.getFromAttribute(child.getName());
            if (this.contentType == null) {
                throw new Exception("Unknown nested element '" + child.getName() + "' to condition \"" + this.getId() + "\"");
            }
            this.content = child.getContent();
            if (this.content == null || this.content.length() == 0) {
                throw new Exception("Condition \"" + this.getId() + "\" has a nested element without valid contents");
            }
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl el = new XMLElementImpl(this.contentType.getAttribute(), conditionRoot);
        el.setContent(this.content);
        conditionRoot.addChild(el);
    }

    public static enum ContentType {
        VARIABLE("variable"),
        STRING("string"),
        FILE("file"),
        DIR("dir");

        private static Map<String, ContentType> lookup;
        private String attribute;

        static {
            lookup = new HashMap<String, ContentType>();
            for (ContentType operation : EnumSet.allOf(ContentType.class)) {
                lookup.put(operation.getAttribute(), operation);
            }
        }

        private ContentType(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static ContentType getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }
    }
}

