/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.install;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.console.PanelConsole;
import com.izforge.izpack.installer.console.PanelConsoleHelper;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.unpacker.Unpacker;
import java.io.PrintWriter;
import java.util.Properties;

public class InstallPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole,
AbstractUIProgressHandler {
    private int noOfPacks = 0;

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return true;
    }

    @Override
    public boolean runConsoleFromProperties(AutomatedInstallData installData, Properties p) {
        return this.runConsole(installData);
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata) {
        VariableSubstitutorImpl variableSubstitutor = new VariableSubstitutorImpl(idata.getVariables());
        Unpacker unpacker = new Unpacker(idata, ResourceManager.getInstance(), idata.getRules(), variableSubstitutor, new UninstallData());
        unpacker.setHandler(this);
        unpacker.setRules(idata.getRules());
        Thread unpackerthread = new Thread((Runnable)unpacker, "IzPack - Unpacker thread");
        unpackerthread.start();
        boolean done = false;
        while (!done && unpackerthread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return unpacker.getResult();
    }

    @Override
    public void emitNotification(String message) {
        System.out.println(message);
    }

    @Override
    public boolean emitWarning(String title, String message) {
        System.err.println("[ WARNING: " + message + " ]");
        return true;
    }

    @Override
    public void emitError(String title, String message) {
        System.err.println("[ ERROR: " + message + " ]");
    }

    @Override
    public void emitErrorAndBlockNext(String title, String message) {
        System.err.println("[ ERROR: " + message + " ]");
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        return 45;
    }

    @Override
    public int askQuestion(String title, String question, int choices, int default_choice) {
        return default_choice;
    }

    @Override
    public void startAction(String name, int no_of_steps) {
        System.out.println("[ Starting to unpack ]");
        this.noOfPacks = no_of_steps;
    }

    @Override
    public void stopAction() {
        System.out.println("[ Unpacking finished ]");
        boolean done = true;
    }

    @Override
    public void progress(int val, String msg) {
    }

    @Override
    public void nextStep(String packName, int stepno, int stepsize) {
        System.out.print("[ Processing package: " + packName + " (");
        System.out.print(stepno);
        System.out.print('/');
        System.out.print(this.noOfPacks);
        System.out.println(") ]");
    }

    @Override
    public void setSubStepNo(int no_of_substeps) {
    }
}

