/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackColor;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.panels.packs.PacksPanelInterface;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

public class PacksModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3258128076746733110L;
    private static final String INITAL_PACKSELECTION = "initial.pack.selection";
    private List<Pack> packs;
    private List<Pack> hiddenPacks;
    private List<Pack> packsToInstall;
    private Map<String, Pack> installedpacks;
    private boolean modifyinstallation;
    private PacksPanelInterface panel;
    private LocaleDatabase langpack;
    private int[] checkValues;
    Map<String, Pack> namesObj;
    Map<String, Integer> namesPos;
    private RulesEngine rules;
    private Properties variables;
    private GUIInstallData idata;

    public PacksModel(PacksPanelInterface panel, GUIInstallData idata, RulesEngine rules) {
        this.idata = idata;
        this.modifyinstallation = Boolean.valueOf(idata.getVariable("modify.izpack.install"));
        this.installedpacks = new HashMap<String, Pack>();
        if (this.modifyinstallation) {
            try {
                FileInputStream fin = new FileInputStream(new File(String.valueOf(idata.getInstallPath()) + File.separator + ".installationinformation"));
                ObjectInputStream oin = new ObjectInputStream(fin);
                List packsinstalled = (List)oin.readObject();
                for (Pack installedpack : packsinstalled) {
                    if (installedpack.id != null && installedpack.id.length() > 0) {
                        this.installedpacks.put(installedpack.id, installedpack);
                        continue;
                    }
                    this.installedpacks.put(installedpack.name, installedpack);
                }
                this.removeAlreadyInstalledPacks(idata.getSelectedPacks());
                Debug.trace("Found " + packsinstalled.size() + " installed packs");
                Properties variables = (Properties)oin.readObject();
                for (Object key : variables.keySet()) {
                    idata.setVariable((String)key, (String)variables.get(key));
                }
                fin.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.rules = rules;
        this.packs = new ArrayList<Pack>();
        this.hiddenPacks = new ArrayList<Pack>();
        for (Pack availablePack : idata.getAvailablePacks()) {
            if (!availablePack.isHidden()) {
                this.packs.add(availablePack);
                continue;
            }
            this.hiddenPacks.add(availablePack);
        }
        this.packsToInstall = idata.getSelectedPacks();
        this.panel = panel;
        this.variables = idata.getVariables();
        this.variables.setProperty(INITAL_PACKSELECTION, Boolean.toString(true));
        this.langpack = panel.getLangpack();
        this.checkValues = new int[this.packs.size()];
        this.reverseDeps();
        this.initvalues();
        this.updateConditions(true);
        this.refreshPacksToInstall();
        this.variables.setProperty(INITAL_PACKSELECTION, Boolean.toString(false));
    }

    public Pack getPackAtRow(int row) {
        return this.packs.get(row);
    }

    private void removeAlreadyInstalledPacks(List<Pack> selectedpacks) {
        ArrayList<Pack> removepacks = new ArrayList<Pack>();
        for (Pack selectedpack : selectedpacks) {
            String key = "";
            key = selectedpack.id != null && selectedpack.id.length() > 0 ? selectedpack.id : selectedpack.name;
            if (!this.installedpacks.containsKey(key)) continue;
            removepacks.add(selectedpack);
        }
        for (Pack removepack : removepacks) {
            selectedpacks.remove(removepack);
        }
    }

    public void updateConditions() {
        this.updateConditions(false);
    }

    private void updateConditions(boolean initial) {
        boolean changes = true;
        while (changes) {
            changes = false;
            for (Pack pack : this.packs) {
                int pos = this.getPos(pack.name);
                Debug.trace("Conditions fulfilled for: " + pack.name + "?");
                if (this.rules.canInstallPack(pack.id, this.variables)) continue;
                Debug.trace("no");
                if (this.rules.canInstallPackOptional(pack.id, this.variables)) {
                    Debug.trace("optional");
                    Debug.trace(String.valueOf(pack.id) + " can be installed optionally.");
                    if (!initial || this.checkValues[pos] == 0) continue;
                    this.checkValues[pos] = 0;
                    changes = true;
                    break;
                }
                Debug.trace(String.valueOf(pack.id) + " can not be installed.");
                if (this.checkValues[pos] == -2) continue;
                this.checkValues[pos] = -2;
                changes = true;
                break;
            }
            this.refreshPacksToInstall();
        }
    }

    private void reverseDeps() {
        this.namesObj = new HashMap<String, Pack>();
        for (Pack pack : this.packs) {
            this.namesObj.put(pack.name, pack);
        }
        for (Pack pack : this.packs) {
            List<String> deps = pack.dependencies;
            int j = 0;
            while (deps != null && j < deps.size()) {
                String name = deps.get(j);
                Pack parent = this.namesObj.get(name);
                parent.addRevDep(pack.name);
                ++j;
            }
        }
    }

    private void initvalues() {
        Pack pack;
        this.namesPos = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.packs.size()) {
            pack = this.packs.get(i);
            this.namesPos.put(pack.name, i);
            ++i;
        }
        i = 0;
        while (i < this.packs.size()) {
            pack = this.packs.get(i);
            if (this.packsToInstall.contains(pack)) {
                this.checkValues[i] = 1;
            }
            ++i;
        }
        i = 0;
        while (i < this.packs.size()) {
            pack = this.packs.get(i);
            if (this.checkValues[i] == 0) {
                List<String> deps = pack.revDependencies;
                int j = 0;
                while (deps != null && j < deps.size()) {
                    String name = deps.get(j);
                    int pos = this.getPos(name);
                    this.checkValues[pos] = -2;
                    ++j;
                }
            }
            if (this.checkValues[i] > 0 && pack.excludeGroup != null) {
                int q = 0;
                while (q < this.packs.size()) {
                    if (q != i) {
                        Pack otherpack = this.packs.get(q);
                        if (pack.excludeGroup.equals(otherpack.excludeGroup) && this.checkValues[q] == 1) {
                            this.checkValues[q] = 0;
                        }
                    }
                    ++q;
                }
            }
            ++i;
        }
        for (Pack pack2 : this.packs) {
            if (!pack2.required) continue;
            this.propRequirement(pack2.name);
        }
        this.refreshPacksToInstall();
    }

    private void propRequirement(String name) {
        int pos = this.getPos(name);
        this.checkValues[pos] = -1;
        List<String> deps = this.packs.get((int)pos).dependencies;
        int i = 0;
        while (deps != null && i < deps.size()) {
            String s = deps.get(i);
            this.propRequirement(s);
            ++i;
        }
    }

    private int getPos(String name) {
        return this.namesPos.get(name);
    }

    @Override
    public int getRowCount() {
        return this.packs.size();
    }

    @Override
    public int getColumnCount() {
        boolean doNotShowPackSize = Boolean.parseBoolean(this.idata.guiPrefs.modifier.get("doNotShowPackSizeColumn"));
        int result = 0;
        result = !doNotShowPackSize ? 3 : 2;
        return result;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.checkValues[rowIndex] < 0) {
            return false;
        }
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = this.packs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.checkValues[rowIndex];
            }
            case 1: {
                String name = null;
                if (this.langpack != null && pack.id != null && !pack.id.equals("")) {
                    name = this.langpack.get(pack.id);
                }
                if (name == null || "".equals(name)) {
                    name = pack.name;
                }
                return name;
            }
            case 2: {
                return Pack.toByteUnitsString(pack.nbytes);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Integer) {
            Pack pack = this.packs.get(rowIndex);
            boolean packadded = false;
            if ((Integer)aValue == 1) {
                packadded = true;
                String packid = pack.id;
                if (packid != null) {
                    if (this.rules.canInstallPack(packid, this.variables) || this.rules.canInstallPackOptional(packid, this.variables)) {
                        this.checkValues[rowIndex] = pack.required ? -1 : 1;
                    }
                } else {
                    this.checkValues[rowIndex] = pack.required ? -1 : 1;
                }
            } else {
                packadded = false;
                this.checkValues[rowIndex] = 0;
            }
            this.updateExcludes(rowIndex);
            this.updateDeps();
            if (packadded) {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after adding pack " + pack.id);
                }
                this.packsToInstall.add(pack);
            } else {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after removing pack " + pack.id);
                }
                this.packsToInstall.remove(pack);
            }
            this.updateConditions();
            if (packadded) {
                this.packsToInstall.remove(pack);
            } else {
                this.packsToInstall.add(pack);
            }
            this.refreshPacksToInstall();
            this.updateBytes();
            this.fireTableDataChanged();
            this.panel.showSpaceRequired();
        }
    }

    private void refreshPacksToInstall() {
        String key;
        Pack pack;
        this.packsToInstall.clear();
        int i = 0;
        while (i < this.packs.size()) {
            pack = this.packs.get(i);
            key = "";
            key = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (Math.abs(this.checkValues[i]) == 1 && !this.installedpacks.containsKey(key)) {
                this.packsToInstall.add(pack);
            }
            ++i;
        }
        i = 0;
        while (i < this.packs.size()) {
            pack = this.packs.get(i);
            key = "";
            key = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (this.installedpacks.containsKey(key)) {
                this.checkValues[i] = -3;
            }
            ++i;
        }
        for (Pack hiddenpack : this.hiddenPacks) {
            if (!this.rules.canInstallPack(hiddenpack.id, this.variables)) continue;
            this.packsToInstall.add(hiddenpack);
        }
    }

    private void updateDeps() {
        int[] statusArray = new int[this.packs.size()];
        int i = 0;
        while (i < statusArray.length) {
            statusArray[i] = 0;
            ++i;
        }
        this.dfs(statusArray);
        i = 0;
        while (i < statusArray.length) {
            if (statusArray[i] == 0 && this.checkValues[i] < 0) {
                int n = i;
                this.checkValues[n] = this.checkValues[n] + 2;
            }
            if (statusArray[i] == 1 && this.checkValues[i] >= 0) {
                this.checkValues[i] = -2;
            }
            ++i;
        }
        for (Pack pack : this.packs) {
            if (!pack.required) continue;
            String packid = pack.id;
            if (packid != null) {
                if (!this.rules.canInstallPack(packid, this.variables) && this.rules.canInstallPackOptional(packid, this.variables)) continue;
                this.propRequirement(pack.name);
                continue;
            }
            this.propRequirement(pack.name);
        }
    }

    private void updateExcludes(int rowindex) {
        int value = this.checkValues[rowindex];
        Pack pack = this.packs.get(rowindex);
        if (value > 0 && pack.excludeGroup != null) {
            int q = 0;
            while (q < this.packs.size()) {
                if (rowindex != q) {
                    Pack otherpack = this.packs.get(q);
                    String name2 = pack.excludeGroup;
                    String name1 = otherpack.excludeGroup;
                    if (name2.equals(name1) && this.checkValues[q] == 1) {
                        this.checkValues[q] = 0;
                    }
                }
                ++q;
            }
        }
    }

    private void updateBytes() {
        long bytes = 0L;
        int q = 0;
        while (q < this.packs.size()) {
            if (Math.abs(this.checkValues[q]) == 1) {
                Pack pack = this.packs.get(q);
                bytes += pack.nbytes;
            }
            ++q;
        }
        for (Pack hidden : this.hiddenPacks) {
            if (!this.rules.canInstallPack(hidden.id, this.variables)) continue;
            bytes += hidden.nbytes;
        }
        this.panel.setBytes(bytes);
    }

    private int dfs(int[] status) {
        int i = 0;
        while (i < this.packs.size()) {
            boolean wipe;
            Pack pack2;
            for (Pack pack2 : this.packs) {
                pack2.color = PackColor.WHITE;
            }
            pack2 = this.packs.get(i);
            if (this.dfsVisit(pack2, status, wipe = false) != 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    private int dfsVisit(Pack u, int[] status, boolean wipe) {
        List<String> deps;
        u.color = PackColor.GREY;
        int check = this.checkValues[this.getPos(u.name)];
        if (Math.abs(check) != 1) {
            wipe = true;
        }
        if ((deps = u.revDependencies) != null) {
            for (String name : deps) {
                int result;
                Pack v = this.namesObj.get(name);
                if (wipe) {
                    status[this.getPos((String)v.name)] = 1;
                }
                if (v.color != PackColor.WHITE || (result = this.dfsVisit(v, status, wipe)) == 0) continue;
                return result;
            }
        }
        u.color = PackColor.BLACK;
        return 0;
    }

    public Map<String, Pack> getInstalledpacks() {
        return this.installedpacks;
    }

    public boolean isModifyinstallation() {
        return this.modifyinstallation;
    }
}

