/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.converter;

import ch.systemsx.cisd.common.converter.Converter;
import java.util.HashMap;
import java.util.Map;

public final class ConverterPool {
    private static final ConverterPool instance = new ConverterPool();
    private final Map<Class<?>, Converter<?>> converters = ConverterPool.createConverters();

    private static final Map<Class<?>, Converter<?>> createConverters() {
        return new HashMap();
    }

    public static final ConverterPool getInstance() {
        return instance;
    }

    private static final <T> T defaultConvert(String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(value);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(value);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(value);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(value);
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return (T)Byte.valueOf(value);
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return (T)Short.valueOf(value);
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            char c = value.length() > 0 ? value.charAt(0) : (char)'\u0000';
            return (T)Character.valueOf(c);
        }
        if (type.equals(String.class)) {
            return (T)value;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(value);
        }
        throw new IllegalArgumentException("No converter for type '" + type.getCanonicalName() + "'.");
    }

    public final <T> void registerConverter(Class<T> type, Converter<T> converter) {
        assert (type != null);
        assert (converter != null);
        this.converters.put(type, converter);
    }

    public final <T> void unregisterConverter(Class<T> type) {
        assert (type != null);
        this.converters.remove(type);
    }

    public final <T> T convert(String value, Class<T> type) {
        assert (type != null);
        Converter<T> converter = this.getConverter(type);
        T returned = null;
        returned = converter == null ? (T)ConverterPool.defaultConvert(value, type) : (T)converter.convert(value);
        if (returned == null && converter != null) {
            return converter.getDefaultValue();
        }
        return returned;
    }

    final <T> Converter<T> getConverter(Class<T> type) {
        return this.converters.get(type);
    }
}

