/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ReflectionUtils;

public class ArgumentConvertingMethodInvoker
extends MethodInvoker {
    private TypeConverter typeConverter;
    private boolean useDefaultConverter = true;

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        this.useDefaultConverter = false;
    }

    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null && this.useDefaultConverter) {
            this.typeConverter = this.getDefaultTypeConverter();
        }
        return this.typeConverter;
    }

    protected TypeConverter getDefaultTypeConverter() {
        return new SimpleTypeConverter();
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        TypeConverter converter = this.getTypeConverter();
        if (!(converter instanceof PropertyEditorRegistry)) {
            throw new IllegalStateException("TypeConverter does not implement PropertyEditorRegistry interface: " + converter);
        }
        ((PropertyEditorRegistry)((Object)converter)).registerCustomEditor(requiredType, propertyEditor);
    }

    protected Method findMatchingMethod() {
        Method matchingMethod = super.findMatchingMethod();
        if (matchingMethod == null) {
            matchingMethod = this.doFindMatchingMethod(this.getArguments());
        }
        if (matchingMethod == null) {
            matchingMethod = this.doFindMatchingMethod(new Object[]{this.getArguments()});
        }
        return matchingMethod;
    }

    protected Method doFindMatchingMethod(Object[] arguments2) {
        TypeConverter converter = this.getTypeConverter();
        if (converter != null) {
            String targetMethod = this.getTargetMethod();
            Method matchingMethod = null;
            int argCount = arguments2.length;
            Method[] candidates = ReflectionUtils.getAllDeclaredMethods(this.getTargetClass());
            int minTypeDiffWeight = Integer.MAX_VALUE;
            Object[] argumentsToUse = null;
            for (int i = 0; i < candidates.length; ++i) {
                int typeDiffWeight;
                Class[] paramTypes;
                Method candidate = candidates[i];
                if (!candidate.getName().equals(targetMethod) || (paramTypes = candidate.getParameterTypes()).length != argCount) continue;
                Object[] convertedArguments = new Object[argCount];
                boolean match = true;
                for (int j = 0; j < argCount && match; ++j) {
                    try {
                        convertedArguments[j] = converter.convertIfNecessary(arguments2[j], paramTypes[j]);
                        continue;
                    }
                    catch (TypeMismatchException ex) {
                        match = false;
                    }
                }
                if (!match || (typeDiffWeight = ArgumentConvertingMethodInvoker.getTypeDifferenceWeight(paramTypes, convertedArguments)) >= minTypeDiffWeight) continue;
                minTypeDiffWeight = typeDiffWeight;
                matchingMethod = candidate;
                argumentsToUse = convertedArguments;
            }
            if (matchingMethod != null) {
                this.setArguments(argumentsToUse);
                return matchingMethod;
            }
        }
        return null;
    }
}

