/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityTypeInitializer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonObject(value="SampleType")
public class SampleType
extends EntityType {
    private static final long serialVersionUID = 1L;
    private boolean listable;
    private boolean showContainer;
    private boolean showParents;
    private boolean uniqueSubcodes;
    private boolean automaticCodeGeneration;
    private boolean showParentMetaData;
    private String codePrefix;

    public SampleType(SampleTypeInitializer initializer) {
        super(initializer);
        this.listable = initializer.isListable();
        this.showContainer = initializer.isShowContainer();
        this.showParents = initializer.isShowParents();
        this.uniqueSubcodes = initializer.isUniqueSubcodes();
        this.automaticCodeGeneration = initializer.isAutomaticCodeGeneration();
        this.showParentMetaData = initializer.isShowParentMetaData();
        this.codePrefix = initializer.getCodePrefix();
    }

    public boolean isListable() {
        return this.listable;
    }

    public boolean isShowContainer() {
        return this.showContainer;
    }

    public boolean isShowParents() {
        return this.showParents;
    }

    public boolean isUniqueSubcodes() {
        return this.uniqueSubcodes;
    }

    public boolean isAutomaticCodeGeneration() {
        return this.automaticCodeGeneration;
    }

    public boolean isShowParentMetaData() {
        return this.showParentMetaData;
    }

    public String getCodePrefix() {
        return this.codePrefix;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append(this.getCode());
        builder.append(this.getDescription());
        builder.append(this.getValidationPluginInfo());
        builder.append("listable", this.isListable());
        builder.append("showContainer", this.isShowContainer());
        builder.append("showParents", this.isShowParents());
        builder.append("showParentMetaData", this.isShowParentMetaData());
        builder.append("uniqueSubcodes", this.isUniqueSubcodes());
        builder.append("automaticCodeGeneration", this.isAutomaticCodeGeneration());
        builder.append("codePrefix", this.getCodePrefix());
        builder.append(this.getPropertyTypeGroups());
        return builder.toString();
    }

    private SampleType() {
    }

    private void setListable(boolean listable) {
        this.listable = listable;
    }

    private void setShowContainer(boolean showContainer) {
        this.showContainer = showContainer;
    }

    private void setShowParents(boolean showParents) {
        this.showParents = showParents;
    }

    private void setUniqueSubcodes(boolean uniqueSubcodes) {
        this.uniqueSubcodes = uniqueSubcodes;
    }

    private void setAutomaticCodeGeneration(boolean automaticCodeGeneration) {
        this.automaticCodeGeneration = automaticCodeGeneration;
    }

    private void setShowParentMetaData(boolean showParentMetaData) {
        this.showParentMetaData = showParentMetaData;
    }

    private void setCodePrefix(String codePrefix) {
        this.codePrefix = codePrefix;
    }

    public static final class SampleTypeInitializer
    extends EntityTypeInitializer {
        private boolean listable;
        private boolean showContainer;
        private boolean showParents;
        private boolean uniqueSubcodes;
        private boolean automaticCodeGeneration;
        private boolean showParentMetaData;
        private String codePrefix;

        public boolean isListable() {
            return this.listable;
        }

        public void setListable(boolean listable) {
            this.listable = listable;
        }

        public boolean isShowContainer() {
            return this.showContainer;
        }

        public void setShowContainer(boolean showContainer) {
            this.showContainer = showContainer;
        }

        public boolean isShowParents() {
            return this.showParents;
        }

        public void setShowParents(boolean showParents) {
            this.showParents = showParents;
        }

        public boolean isUniqueSubcodes() {
            return this.uniqueSubcodes;
        }

        public void setUniqueSubcodes(boolean uniqueSubcodes) {
            this.uniqueSubcodes = uniqueSubcodes;
        }

        public boolean isAutomaticCodeGeneration() {
            return this.automaticCodeGeneration;
        }

        public void setAutomaticCodeGeneration(boolean automaticCodeGeneration) {
            this.automaticCodeGeneration = automaticCodeGeneration;
        }

        public boolean isShowParentMetaData() {
            return this.showParentMetaData;
        }

        public void setShowParentMetaData(boolean showParentMetaData) {
            this.showParentMetaData = showParentMetaData;
        }

        public String getCodePrefix() {
            return this.codePrefix;
        }

        public void setCodePrefix(String codePrefix) {
            this.codePrefix = codePrefix;
        }
    }
}

