/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;

public class PrimitiveValue
implements IsSerializable,
Serializable,
Comparable<PrimitiveValue> {
    private static final long serialVersionUID = 1L;
    public static PrimitiveValue NULL = new PrimitiveValue("");
    private Double doubleValueOrNull;
    private Long longValueOrNull;
    private String stringValueOrNull;
    private DataTypeCode dataTypeCodeOrNull;

    public PrimitiveValue(Double value) {
        assert (value != null);
        this.doubleValueOrNull = value;
        this.dataTypeCodeOrNull = DataTypeCode.REAL;
    }

    public PrimitiveValue(Long value) {
        assert (value != null);
        this.longValueOrNull = value;
        this.dataTypeCodeOrNull = DataTypeCode.INTEGER;
    }

    public PrimitiveValue(String value) {
        assert (value != null);
        this.stringValueOrNull = value;
        this.dataTypeCodeOrNull = DataTypeCode.VARCHAR;
    }

    public DataTypeCode getDataType() {
        return this.dataTypeCodeOrNull;
    }

    public String toString() {
        if (this.doubleValueOrNull != null) {
            return this.doubleValueOrNull.toString();
        }
        if (this.longValueOrNull != null) {
            return this.longValueOrNull.toString();
        }
        return this.stringValueOrNull;
    }

    @Override
    public int compareTo(PrimitiveValue o) {
        Integer thatTypeOrdinal;
        Integer thisTypeOrdinal = this.getComparableDataTypeOrdinal();
        int typeComparisonResult = thisTypeOrdinal.compareTo(thatTypeOrdinal = o.getComparableDataTypeOrdinal());
        if (typeComparisonResult != 0) {
            return typeComparisonResult;
        }
        Comparable<?> v1 = this.getComparableValue();
        Comparable<?> v2 = o.getComparableValue();
        return v1.compareTo(v2);
    }

    public Comparable<?> getComparableValue() {
        if (this.doubleValueOrNull != null) {
            return this.doubleValueOrNull;
        }
        if (this.longValueOrNull != null) {
            return new Double(this.longValueOrNull.longValue());
        }
        return this.stringValueOrNull != null ? this.stringValueOrNull : "";
    }

    private Integer getComparableDataTypeOrdinal() {
        switch (this.getDataType()) {
            case INTEGER: 
            case REAL: {
                return 1;
            }
        }
        return 0;
    }

    private PrimitiveValue() {
    }
}

