/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

public class BasicURLEncoder {
    public static String encode(String string) {
        return BasicURLEncoder.encode(string, "");
    }

    public static String encode(String string, String except) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int n = string.length();
        while (i < n) {
            char orginal = string.charAt(i);
            if (except.indexOf(orginal) >= 0) {
                buffer.append(orginal);
            } else {
                buffer.append(BasicURLEncoder.encode(orginal));
            }
            ++i;
        }
        return buffer.toString();
    }

    static String encode(char c) {
        if ("-_.*".indexOf(c) >= 0 || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
            return Character.toString(c);
        }
        if (c == ' ') {
            return "+";
        }
        int b1 = c >> 8 & 0xFF;
        int b2 = c & 0xFF;
        return String.valueOf(b1 == 0 ? "" : BasicURLEncoder.encode(b1)) + BasicURLEncoder.encode(b2);
    }

    private static String encode(int number) {
        return "%" + (String.valueOf(Integer.toHexString(number >> 4 & 0xF)) + Integer.toHexString(number & 0xF)).toUpperCase();
    }
}

